/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.DSAKey;
import com.bifit.security.core.DSAParams;
import com.bifit.security.core.Utils;

public class DSAPrivateKey
extends DSAKey {
    private final int[] a;

    DSAPrivateKey(DSAParams dSAParams, int[] nArray) {
        super(dSAParams);
        this.a = Utils.copy(nArray);
    }

    public DSAPrivateKey(DSAParams dSAParams, byte[] byArray) {
        super(dSAParams);
        this.a = Utils.fromByteArray(byArray, dSAParams.d());
    }

    public int[] getInternalX() {
        if (this.a == null) {
            throw new IllegalStateException("key was deallocated");
        }
        return Utils.copy(this.a);
    }

    public byte[] getX() {
        return Utils.toByteArray(this.a, 4 * this.getParams().d());
    }

    public void free() {
        Utils.clean(this.a);
    }
}

