/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.DSAParams;
import com.bifit.security.core.DSAPrivateKey;
import com.bifit.security.core.DSAPublicKey;
import com.bifit.security.core.Digest;
import com.bifit.security.core.DigestEngine;
import com.bifit.security.core.GFp;
import com.bifit.security.core.Sign;
import com.bifit.security.core.Utils;
import java.security.SecureRandom;
import java.util.Random;

public class DSASign
implements Sign {
    public static final int SHA1 = 0;
    public static final int SHA224 = 1;
    public static final int SHA256 = 2;
    public static final int SHA384 = 3;
    public static final int SHA512 = 4;
    private final Digest a;
    private DSAPrivateKey b = null;
    private DSAPublicKey c = null;
    private SecureRandom d;
    private DSAParams e;
    private GFp f;
    private GFp g;
    private int[] h;
    private int[] i;
    private int[] j;
    private int[] k;
    private int[] l;
    private byte[] m;
    private byte[] n;
    private int[] o;
    private int[] p;

    public DSASign() {
        this(0);
    }

    public DSASign(int n2) {
        if (n2 < 0 && n2 > 4) {
            throw new IllegalArgumentException("invalid type digest");
        }
        this.a = new DigestEngine(n2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    private void a(DSAParams dSAParams, SecureRandom secureRandom) {
        this.e = dSAParams;
        if (secureRandom != null) {
            this.d = secureRandom;
        }
        this.a.init();
        this.f = new GFp(this.e.a());
        this.g = new GFp(this.e.b());
        int n2 = this.e.d();
        int n3 = this.e.getSignatureLength() / 2;
        this.h = new int[n2];
        this.i = new int[n2];
        this.j = new int[n2];
        this.k = new int[n2];
        this.l = new int[n2];
        this.o = new int[n2];
        this.p = new int[n2];
        this.m = new byte[n3];
        this.n = new byte[n3];
    }

    public void initSign(DSAPrivateKey dSAPrivateKey, SecureRandom secureRandom) {
        this.b = dSAPrivateKey;
        this.a(this.b.getParams(), secureRandom);
    }

    @Override
    public byte[] sign() {
        if (this.b == null) {
            throw new IllegalStateException("instance was not initialized");
        }
        Object[] objectArray = this.a.doFinal();
        Object object = this.f.getBigInt();
        objectArray = this.a(this.e.b(), (byte[])objectArray);
        ((BigInt)object).getRandomNumber((Random)this.d, this.g.getOrder(), this.h);
        this.f.modPow(this.e.c(), this.h, this.e.e(), null, null, null, this.i);
        ((BigInt)object).divide(this.i, this.g.getOrder(), null, this.i);
        this.f.multiply(this.i, this.b.getInternalX(), this.j);
        this.f.add((int[])objectArray, this.j, this.j);
        this.g.invert(this.h, this.h);
        this.f.secureMultiply(this.h, this.j, this.j);
        ((BigInt)object).divide(this.j, this.g.getOrder(), null, this.j);
        Utils.clean(this.h);
        int n2 = this.e.getSignatureLength();
        object = new byte[n2];
        Utils.toByteArray(this.i, this.m);
        Utils.toByteArray(this.j, this.n);
        System.arraycopy(this.n, 0, object, 0, n2 >>>= 1);
        System.arraycopy(this.m, 0, object, n2, n2);
        return object;
    }

    @Override
    public byte[] sign(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
        return this.sign();
    }

    public void initVerify(DSAPublicKey dSAPublicKey) {
        this.c = dSAPublicKey;
        this.a(this.c.getParams(), null);
    }

    @Override
    public boolean verify(byte[] objectArray) {
        int n2;
        if (this.c == null) {
            throw new IllegalStateException("instance was not initialized");
        }
        int n3 = objectArray.length;
        int n4 = this.e.getSignatureLength();
        if ((n3 & 1) == 1 || n3 < n4) {
            return false;
        }
        n3 >>>= 1;
        n4 >>>= 1;
        for (n2 = 0; n2 < n3 - n4; ++n2) {
            if (objectArray[n2] == 0) continue;
            return false;
        }
        for (n2 = n3; n2 < 2 * n3 - n4; ++n2) {
            if (objectArray[n2] == 0) continue;
            return false;
        }
        System.arraycopy(objectArray, n3 - n4, this.n, 0, n4);
        System.arraycopy(objectArray, 2 * n3 - n4, this.m, 0, n4);
        Utils.fromByteArray(this.n, this.j);
        Utils.fromByteArray(this.m, this.i);
        byte[] byArray = this.a.doFinal();
        this.e = this.c.getParams();
        objectArray = this.a(this.e.b(), byArray);
        BigInt bigInt = this.f.getBigInt();
        if (BigInt.compare(bigInt.getZero(), this.i) >= 0 || BigInt.compare(this.e.b(), this.i) <= 0) {
            return false;
        }
        if (BigInt.compare(bigInt.getZero(), this.j) >= 0 || BigInt.compare(this.e.b(), this.j) <= 0) {
            return false;
        }
        this.g.invert(this.j, this.p);
        this.g.secureMultiply((int[])objectArray, this.p, this.k);
        this.g.secureMultiply(this.i, this.p, this.l);
        this.f.modPow(this.e.c(), this.k, this.e.e(), null, null, null, this.k);
        this.f.modPow(this.c.a(), this.l, this.c.b(), null, null, null, this.l);
        this.f.secureMultiply(this.k, this.l, this.o);
        bigInt.divide(this.o, this.g.getOrder(), null, this.o);
        return BigInt.equals(this.o, this.i);
    }

    @Override
    public boolean verify(byte[] byArray, byte[] byArray2) {
        this.update(byArray, 0, byArray.length);
        return this.verify(byArray2);
    }

    private int[] a(int[] nArray, byte[] byArray) {
        int n2 = BigInt.bitLength(nArray);
        if (n2 >= byArray.length << 3) {
            return Utils.fromByteArray(byArray, this.e.d());
        }
        byte[] byArray2 = new byte[n2 / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return Utils.fromByteArray(byArray2, this.e.d());
    }
}

