/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.DSTU4145ECParams;
import com.bifit.security.core.GF2m;
import com.bifit.security.core.LongIntUtils;
import com.bifit.security.core.Utils;
import com.bifit.security.core.n;
import com.bifit.security.core.p;

public final class DSTU4145ECPublicKey {
    private final n a;
    private final DSTU4145ECParams b;
    private byte[] c = null;
    private byte[] d = null;
    private byte[] e = null;

    public DSTU4145ECPublicKey(DSTU4145ECParams dSTU4145ECParams, byte[] byArray) {
        int n2;
        GF2m gF2m = new GF2m(dSTU4145ECParams);
        int n3 = gF2m.getN();
        int n4 = dSTU4145ECParams.a()[0];
        int n5 = dSTU4145ECParams.getA();
        long[] lArray = dSTU4145ECParams.b();
        long[] lArray2 = LongIntUtils.fromByteArray(byArray, n3);
        if (Utils.byteLength(byArray) > n3 * 8 || LongIntUtils.bitLength(lArray2) > n4) {
            throw new IllegalArgumentException("invalid compressed public key specified");
        }
        long[] lArray3 = new long[n3];
        if (LongIntUtils.equals(lArray2, gF2m.getZero())) {
            gF2m.squareRoot(lArray, lArray3);
        } else {
            int n6;
            n2 = LongIntUtils.getBit(lArray2, 0);
            if (dSTU4145ECParams.isONB()) {
                n6 = 0;
                --n4;
                while (n4 >= 0) {
                    n6 = (int)((long)n6 ^ lArray2[n3 - 1 - (n4 >>> 6)] >>> n4);
                    --n4;
                }
                if ((n6 & 1) != n5) {
                    GF2m.add(lArray2, gF2m.getOne(), lArray2);
                }
                dSTU4145ECParams.a(gF2m, lArray2);
            } else {
                n6 = gF2m.trace(lArray2);
                if (n6 != n5) {
                    GF2m.add(lArray2, gF2m.getOne(), lArray2);
                }
            }
            long[] lArray4 = new long[n3];
            long[] lArray5 = new long[n3];
            gF2m.square(lArray2, lArray5);
            gF2m.multiply(lArray2, lArray5, lArray4);
            if (n5 == 1) {
                GF2m.add(lArray4, lArray5, lArray4);
            }
            GF2m.add(lArray4, lArray, lArray4);
            gF2m.invert(lArray5, lArray5);
            gF2m.multiply(lArray4, lArray5, lArray4);
            if (!gF2m.solveQuadraticEq(lArray4, lArray3)) {
                throw new IllegalArgumentException("invalid compressed public key specified");
            }
            if (gF2m.trace(lArray3) == n2) {
                gF2m.multiply(lArray2, lArray3, lArray3);
            } else {
                GF2m.add(lArray3, gF2m.getOne(), lArray3);
                gF2m.multiply(lArray3, lArray2, lArray3);
            }
        }
        this.a = new n(lArray2, lArray3);
        this.b = dSTU4145ECParams;
        n2 = dSTU4145ECParams.a()[0] + 7 >>> 3;
        this.e = Utils.justifyArray(byArray, n2);
    }

    public DSTU4145ECPublicKey(DSTU4145ECParams dSTU4145ECParams, byte[] byArray, byte[] byArray2) {
        p p2 = new p(dSTU4145ECParams);
        int n2 = p2.b();
        int n3 = dSTU4145ECParams.a()[0];
        long[] lArray = LongIntUtils.fromByteArray(byArray, n2);
        if (LongIntUtils.bitLength(lArray) > n3 || Utils.byteLength(byArray) > n2 * 8) {
            throw new IllegalArgumentException("public key X-coordinate is not an element of GF(2^m)");
        }
        long[] lArray2 = LongIntUtils.fromByteArray(byArray2, n2);
        if (LongIntUtils.bitLength(lArray2) > n3 || Utils.byteLength(byArray2) > n2 * 8) {
            throw new IllegalArgumentException("public key Y-coordinate is not an element of GF(2^m)");
        }
        this.a = new n(lArray, lArray2);
        if (dSTU4145ECParams.isONB()) {
            dSTU4145ECParams.a(p2.a(), this.a.a());
            dSTU4145ECParams.a(p2.a(), this.a.b());
        }
        if (!p2.a(this.a)) {
            throw new IllegalArgumentException("public key is not a point on the elliptic curve");
        }
        this.b = dSTU4145ECParams;
        int n4 = dSTU4145ECParams.a()[0] + 7 >>> 3;
        this.c = Utils.justifyArray(byArray, n4);
        this.d = Utils.justifyArray(byArray2, n4);
    }

    DSTU4145ECPublicKey(DSTU4145ECParams dSTU4145ECParams, n n2) {
        this.b = dSTU4145ECParams;
        this.a = n2;
    }

    public final synchronized byte[] getQx() {
        if (this.c == null) {
            int n2 = this.b.a()[0] + 7 >>> 3;
            if (this.b.isONB()) {
                GF2m gF2m = new GF2m(this.b);
                long[] lArray = new long[gF2m.getN()];
                LongIntUtils.copy(this.a.a(), lArray);
                this.b.b(gF2m, lArray);
                this.c = LongIntUtils.toByteArray(lArray, n2);
            } else {
                this.c = LongIntUtils.toByteArray(this.a.a(), n2);
            }
        }
        return Utils.copy(this.c);
    }

    public final synchronized byte[] getQy() {
        if (this.d == null) {
            int n2 = this.b.a()[0] + 7 >>> 3;
            if (this.b.isONB()) {
                GF2m gF2m = new GF2m(this.b);
                long[] lArray = new long[gF2m.getN()];
                LongIntUtils.copy(this.a.b(), lArray);
                this.b.b(gF2m, lArray);
                this.d = LongIntUtils.toByteArray(lArray, n2);
            } else {
                this.d = LongIntUtils.toByteArray(this.a.b(), n2);
            }
        }
        return Utils.copy(this.d);
    }

    public final synchronized byte[] getQc() {
        if (this.e == null) {
            GF2m gF2m = new GF2m(this.b);
            int n2 = this.b.a()[0] + 7 >>> 3;
            if (LongIntUtils.equals(this.a.a(), gF2m.getZero())) {
                this.e = new byte[n2];
                return Utils.copy(this.e);
            }
            long[] lArray = new long[gF2m.getN()];
            gF2m.invert(this.a.a(), lArray);
            gF2m.multiply(lArray, this.a.b(), lArray);
            if (this.b.isONB()) {
                this.e = this.getQx();
                if ((this.e[this.e.length - 1] & 1) != gF2m.trace(lArray)) {
                    int n3 = this.e.length - 1;
                    this.e[n3] = (byte)(this.e[n3] ^ 1);
                }
            } else if (LongIntUtils.getBit(this.a.a(), 0) != gF2m.trace(lArray)) {
                GF2m.add(this.a.a(), gF2m.getOne(), lArray);
                this.e = LongIntUtils.toByteArray(lArray, n2);
            } else {
                this.e = LongIntUtils.toByteArray(this.a.a(), n2);
            }
        }
        return Utils.copy(this.e);
    }

    public final synchronized void setOptLevel(int n2) {
        int n3 = Utils.getWidthByOptLevel(n2);
        if (n3 != 0) {
            p p2 = new p(this.b);
            n[] nArray = p2.a(this.a, Utils.getWidthByOptLevel(n2));
            this.a.a(nArray);
            return;
        }
        this.a.a(null);
    }

    public final synchronized void setOptData(byte[] byArray) {
        if (byArray != null) {
            p p2 = new p(this.b);
            this.a.a(p2.a(byArray));
            return;
        }
        this.a.a(null);
    }

    public final synchronized byte[] getOptData() {
        n[] nArray = this.a.d();
        if (nArray != null) {
            p p2 = new p(this.b);
            return p2.a(nArray);
        }
        return null;
    }

    public final DSTU4145ECParams getParams() {
        return this.b;
    }

    final n a() {
        return this.a;
    }
}

