/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.Digest;
import com.bifit.security.core.GOST28147CipherParams;
import com.bifit.security.core.GOST3411Digest;
import com.bifit.security.core.GOST3411Digest2012;
import com.bifit.security.core.MD2Digest;
import com.bifit.security.core.MD5Digest;
import com.bifit.security.core.SHA1Digest;
import com.bifit.security.core.SHA224Digest;
import com.bifit.security.core.SHA256Digest;
import com.bifit.security.core.SHA384Digest;
import com.bifit.security.core.SHA512Digest;

public final class DigestEngine
implements Digest {
    public static final int SHA1 = 0;
    public static final int SHA224 = 1;
    public static final int SHA256 = 2;
    public static final int SHA384 = 3;
    public static final int SHA512 = 4;
    public static final int MD2 = 5;
    public static final int MD5 = 6;
    public static final int GOST3411 = 7;
    public static final int GOST3411_2012_256 = 8;
    public static final int GOST3411_2012_512 = 9;
    private final Digest a;

    public DigestEngine(int n2, GOST28147CipherParams gOST28147CipherParams) {
        switch (n2) {
            case 0: {
                this.a = new SHA1Digest();
                return;
            }
            case 1: {
                this.a = new SHA224Digest();
                return;
            }
            case 2: {
                this.a = new SHA256Digest();
                return;
            }
            case 3: {
                this.a = new SHA384Digest();
                return;
            }
            case 4: {
                this.a = new SHA512Digest();
                return;
            }
            case 6: {
                this.a = new MD5Digest();
                return;
            }
            case 5: {
                this.a = new MD2Digest();
                return;
            }
            case 7: {
                if (gOST28147CipherParams == null) {
                    this.a = new GOST3411Digest(GOST28147CipherParams.DEFAULT_8);
                    return;
                }
                this.a = new GOST3411Digest(gOST28147CipherParams);
                return;
            }
            case 8: {
                this.a = new GOST3411Digest2012(GOST3411Digest2012.HashType.DIGEST256);
                return;
            }
            case 9: {
                this.a = new GOST3411Digest2012(GOST3411Digest2012.HashType.DIGEST512);
                return;
            }
        }
        throw new IllegalArgumentException("invalid type digest");
    }

    public DigestEngine(int n2) {
        this(n2, null);
    }

    @Override
    public final void init() {
        this.a.init();
    }

    @Override
    public final void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    @Override
    public final byte[] doFinal() {
        return this.a.doFinal();
    }

    @Override
    public final void doFinal(byte[] byArray, int n2) {
        this.a.doFinal(byArray, n2);
    }

    @Override
    public final int getDigestSize() {
        return this.a.getDigestSize();
    }

    @Override
    public final int getBlockSize() {
        return this.a.getBlockSize();
    }
}

