/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.DSTU4145ECParams;
import com.bifit.security.core.LongIntUtils;

public final class GF2m {
    private final BigInt a;
    private final long[] b;
    private final long[] c;
    private final int d;
    private int[] e;
    private long[] f = null;
    private final long[] g;
    private final long[] h;
    private long[] i;
    private long[] j;
    private long[] k;
    private long[] l;
    private final long[] m;
    private final long[] n;
    private final long[] o = new long[8];
    private final long[] p = new long[4];
    private final long[] q = new long[4];
    private final long[] r = new long[8];
    private static final short[] s = new short[256];

    public GF2m(int[] nArray) {
        this.e = nArray;
        this.d = nArray[0] + 63 >> 6;
        this.a = new BigInt(2 * this.d);
        this.b = new long[this.d];
        this.c = new long[this.d];
        this.c[this.d - 1] = 1L;
        this.g = new long[2 * this.d];
        this.h = new long[2 * this.d];
        this.n = new long[this.d];
        this.i = new long[this.d];
        this.j = new long[this.d];
        this.k = new long[this.d];
        this.l = new long[this.d];
        this.m = new long[2 * this.d];
    }

    public GF2m(DSTU4145ECParams dSTU4145ECParams) {
        this(dSTU4145ECParams.a());
    }

    public final int getN() {
        return this.d;
    }

    public final int[] getF() {
        return (int[])this.e.clone();
    }

    public final BigInt getBigInt() {
        return this.a;
    }

    public final long[] getZero() {
        return (long[])this.b.clone();
    }

    public final long[] getOne() {
        return (long[])this.c.clone();
    }

    public static void toInteger(long[] lArray, int[] nArray) {
        LongIntUtils.truncate(lArray, BigInt.bitLength(nArray) - 1);
    }

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i2 = lArray.length - 1; i2 >= 0; --i2) {
            lArray3[i2] = lArray[i2] ^ lArray2[i2];
        }
    }

    public final void multiply(long[] object, long[] lArray, long[] lArray2) {
        GF2m gF2m = this;
        long[] lArray3 = this.g;
        long[] lArray4 = lArray;
        lArray = object;
        object = gF2m;
        if (gF2m.d <= 4) {
            super.a(lArray, lArray4, lArray3, true);
        } else if (((GF2m)object).e[0] == 257) {
            int n2;
            lArray3[0] = 0L;
            lArray3[1] = lArray[0] == 1L && lArray4[0] == 1L ? 1 : 0;
            super.a(lArray, lArray4, lArray3, true);
            if (lArray[0] == 1L) {
                for (n2 = 1; n2 < 5; ++n2) {
                    int n3 = n2 + 1;
                    lArray3[n3] = lArray3[n3] ^ lArray4[n2];
                }
            }
            if (lArray4[0] == 1L) {
                for (n2 = 1; n2 < 5; ++n2) {
                    int n4 = n2 + 1;
                    lArray3[n4] = lArray3[n4] ^ lArray[n2];
                }
            }
        } else {
            int n5;
            int n6 = 2 * ((GF2m)object).d > 12 ? 2 * ((GF2m)object).d - 12 : 0;
            super.a(lArray, lArray4, lArray3, true);
            System.arraycopy(lArray3, n6 + 4, lArray3, n6, 2 * ((GF2m)object).d - 8 - n6);
            int n7 = 2 * ((GF2m)object).d - 8;
            for (n5 = 2 * ((GF2m)object).d - 4; n5 < 2 * ((GF2m)object).d; ++n5) {
                int n8 = n7++;
                lArray3[n8] = lArray3[n8] ^ lArray3[n5];
            }
            System.arraycopy(lArray, ((GF2m)object).d - 4, ((GF2m)object).p, 0, 4);
            n7 = 8 - ((GF2m)object).d;
            n5 = 0;
            while (n7 < 4) {
                int n9 = n7++;
                ((GF2m)object).p[n9] = ((GF2m)object).p[n9] ^ lArray[n5];
                ++n5;
            }
            System.arraycopy(lArray4, ((GF2m)object).d - 4, ((GF2m)object).q, 0, 4);
            n7 = 8 - ((GF2m)object).d;
            n5 = 0;
            while (n7 < 4) {
                int n10 = n7++;
                ((GF2m)object).q[n10] = ((GF2m)object).q[n10] ^ lArray4[n5];
                ++n5;
            }
            super.a(((GF2m)object).p, ((GF2m)object).q, ((GF2m)object).o, true);
            n7 = n6;
            for (n5 = 12 - 2 * ((GF2m)object).d + n6; n5 < 8; ++n5) {
                int n11 = n7++;
                lArray3[n11] = lArray3[n11] ^ ((GF2m)object).o[n5];
            }
            if (((GF2m)object).d <= 5) {
                long[] lArray5 = ((GF2m)object).o;
                long l2 = lArray[0];
                long l3 = lArray4[0];
                long l4 = 0L;
                long l5 = 0L;
                if (((int)l3 & 1) != 0) {
                    l4 = 0L ^ l2;
                }
                if (((int)l3 & 2) != 0) {
                    l4 ^= l2 << 1;
                    l5 = 0L ^ l2 >>> 63;
                }
                if (((int)l3 & 4) != 0) {
                    l4 ^= l2 << 2;
                    l5 ^= l2 >>> 62;
                }
                if (((int)l3 & 8) != 0) {
                    l4 ^= l2 << 3;
                    l5 ^= l2 >>> 61;
                }
                if (((int)l3 & 0x10) != 0) {
                    l4 ^= l2 << 4;
                    l5 ^= l2 >>> 60;
                }
                if (((int)l3 & 0x20) != 0) {
                    l4 ^= l2 << 5;
                    l5 ^= l2 >>> 59;
                }
                if (((int)l3 & 0x40) != 0) {
                    l4 ^= l2 << 6;
                    l5 ^= l2 >>> 58;
                }
                if (((int)l3 & 0x80) != 0) {
                    l4 ^= l2 << 7;
                    l5 ^= l2 >>> 57;
                }
                if (((int)l3 & 0x100) != 0) {
                    l4 ^= l2 << 8;
                    l5 ^= l2 >>> 56;
                }
                if (((int)l3 & 0x200) != 0) {
                    l4 ^= l2 << 9;
                    l5 ^= l2 >>> 55;
                }
                if (((int)l3 & 0x400) != 0) {
                    l4 ^= l2 << 10;
                    l5 ^= l2 >>> 54;
                }
                if (((int)l3 & 0x800) != 0) {
                    l4 ^= l2 << 11;
                    l5 ^= l2 >>> 53;
                }
                if (((int)l3 & 0x1000) != 0) {
                    l4 ^= l2 << 12;
                    l5 ^= l2 >>> 52;
                }
                if (((int)l3 & 0x2000) != 0) {
                    l4 ^= l2 << 13;
                    l5 ^= l2 >>> 51;
                }
                if (((int)l3 & 0x4000) != 0) {
                    l4 ^= l2 << 14;
                    l5 ^= l2 >>> 50;
                }
                if (((int)l3 & 0x8000) != 0) {
                    l4 ^= l2 << 15;
                    l5 ^= l2 >>> 49;
                }
                if (((int)l3 & 0x10000) != 0) {
                    l4 ^= l2 << 16;
                    l5 ^= l2 >>> 48;
                }
                if (((int)l3 & 0x20000) != 0) {
                    l4 ^= l2 << 17;
                    l5 ^= l2 >>> 47;
                }
                if (((int)l3 & 0x40000) != 0) {
                    l4 ^= l2 << 18;
                    l5 ^= l2 >>> 46;
                }
                if (((int)l3 & 0x80000) != 0) {
                    l4 ^= l2 << 19;
                    l5 ^= l2 >>> 45;
                }
                if (((int)l3 & 0x100000) != 0) {
                    l4 ^= l2 << 20;
                    l5 ^= l2 >>> 44;
                }
                if (((int)l3 & 0x200000) != 0) {
                    l4 ^= l2 << 21;
                    l5 ^= l2 >>> 43;
                }
                if (((int)l3 & 0x400000) != 0) {
                    l4 ^= l2 << 22;
                    l5 ^= l2 >>> 42;
                }
                if (((int)l3 & 0x800000) != 0) {
                    l4 ^= l2 << 23;
                    l5 ^= l2 >>> 41;
                }
                if (((int)l3 & 0x1000000) != 0) {
                    l4 ^= l2 << 24;
                    l5 ^= l2 >>> 40;
                }
                if (((int)l3 & 0x2000000) != 0) {
                    l4 ^= l2 << 25;
                    l5 ^= l2 >>> 39;
                }
                if (((int)l3 & 0x4000000) != 0) {
                    l4 ^= l2 << 26;
                    l5 ^= l2 >>> 38;
                }
                if (((int)l3 & 0x8000000) != 0) {
                    l4 ^= l2 << 27;
                    l5 ^= l2 >>> 37;
                }
                if (((int)l3 & 0x10000000) != 0) {
                    l4 ^= l2 << 28;
                    l5 ^= l2 >>> 36;
                }
                if (((int)l3 & 0x20000000) != 0) {
                    l4 ^= l2 << 29;
                    l5 ^= l2 >>> 35;
                }
                if (((int)l3 & 0x40000000) != 0) {
                    l4 ^= l2 << 30;
                    l5 ^= l2 >>> 34;
                }
                if (((int)l3 & Integer.MIN_VALUE) != 0) {
                    l4 ^= l2 << 31;
                    l5 ^= l2 >>> 33;
                }
                if ((l3 & 0x100000000L) != 0L) {
                    l4 ^= l2 << 32;
                    l5 ^= l2 >>> 32;
                }
                if ((l3 & 0x200000000L) != 0L) {
                    l4 ^= l2 << 33;
                    l5 ^= l2 >>> 31;
                }
                if ((l3 & 0x400000000L) != 0L) {
                    l4 ^= l2 << 34;
                    l5 ^= l2 >>> 30;
                }
                if ((l3 & 0x800000000L) != 0L) {
                    l4 ^= l2 << 35;
                    l5 ^= l2 >>> 29;
                }
                if ((l3 & 0x1000000000L) != 0L) {
                    l4 ^= l2 << 36;
                    l5 ^= l2 >>> 28;
                }
                if ((l3 & 0x2000000000L) != 0L) {
                    l4 ^= l2 << 37;
                    l5 ^= l2 >>> 27;
                }
                if ((l3 & 0x4000000000L) != 0L) {
                    l4 ^= l2 << 38;
                    l5 ^= l2 >>> 26;
                }
                if ((l3 & 0x8000000000L) != 0L) {
                    l4 ^= l2 << 39;
                    l5 ^= l2 >>> 25;
                }
                if ((l3 & 0x10000000000L) != 0L) {
                    l4 ^= l2 << 40;
                    l5 ^= l2 >>> 24;
                }
                if ((l3 & 0x20000000000L) != 0L) {
                    l4 ^= l2 << 41;
                    l5 ^= l2 >>> 23;
                }
                if ((l3 & 0x40000000000L) != 0L) {
                    l4 ^= l2 << 42;
                    l5 ^= l2 >>> 22;
                }
                if ((l3 & 0x80000000000L) != 0L) {
                    l4 ^= l2 << 43;
                    l5 ^= l2 >>> 21;
                }
                if ((l3 & 0x100000000000L) != 0L) {
                    l4 ^= l2 << 44;
                    l5 ^= l2 >>> 20;
                }
                if ((l3 & 0x200000000000L) != 0L) {
                    l4 ^= l2 << 45;
                    l5 ^= l2 >>> 19;
                }
                if ((l3 & 0x400000000000L) != 0L) {
                    l4 ^= l2 << 46;
                    l5 ^= l2 >>> 18;
                }
                if ((l3 & 0x800000000000L) != 0L) {
                    l4 ^= l2 << 47;
                    l5 ^= l2 >>> 17;
                }
                if ((l3 & 0x1000000000000L) != 0L) {
                    l4 ^= l2 << 48;
                    l5 ^= l2 >>> 16;
                }
                if ((l3 & 0x2000000000000L) != 0L) {
                    l4 ^= l2 << 49;
                    l5 ^= l2 >>> 15;
                }
                if ((l3 & 0x4000000000000L) != 0L) {
                    l4 ^= l2 << 50;
                    l5 ^= l2 >>> 14;
                }
                if ((l3 & 0x8000000000000L) != 0L) {
                    l4 ^= l2 << 51;
                    l5 ^= l2 >>> 13;
                }
                if ((l3 & 0x10000000000000L) != 0L) {
                    l4 ^= l2 << 52;
                    l5 ^= l2 >>> 12;
                }
                if ((l3 & 0x20000000000000L) != 0L) {
                    l4 ^= l2 << 53;
                    l5 ^= l2 >>> 11;
                }
                if ((l3 & 0x40000000000000L) != 0L) {
                    l4 ^= l2 << 54;
                    l5 ^= l2 >>> 10;
                }
                if ((l3 & 0x80000000000000L) != 0L) {
                    l4 ^= l2 << 55;
                    l5 ^= l2 >>> 9;
                }
                if ((l3 & 0x100000000000000L) != 0L) {
                    l4 ^= l2 << 56;
                    l5 ^= l2 >>> 8;
                }
                if ((l3 & 0x200000000000000L) != 0L) {
                    l4 ^= l2 << 57;
                    l5 ^= l2 >>> 7;
                }
                if ((l3 & 0x400000000000000L) != 0L) {
                    l4 ^= l2 << 58;
                    l5 ^= l2 >>> 6;
                }
                if ((l3 & 0x800000000000000L) != 0L) {
                    l4 ^= l2 << 59;
                    l5 ^= l2 >>> 5;
                }
                if ((l3 & 0x1000000000000000L) != 0L) {
                    l4 ^= l2 << 60;
                    l5 ^= l2 >>> 4;
                }
                if ((l3 & 0x2000000000000000L) != 0L) {
                    l4 ^= l2 << 61;
                    l5 ^= l2 >>> 3;
                }
                if ((l3 & 0x4000000000000000L) != 0L) {
                    l4 ^= l2 << 62;
                    l5 ^= l2 >>> 2;
                }
                if ((l3 & Long.MIN_VALUE) != 0L) {
                    l4 ^= l2 << 63;
                    l5 ^= l2 >>> 1;
                }
                lArray5[0] = l5;
                lArray5[1] = l4;
                for (n7 = 0; n7 < 2; ++n7) {
                    int n12 = n7;
                    lArray3[n12] = lArray3[n12] ^ ((GF2m)object).o[n7];
                    int n13 = n7 + 4;
                    lArray3[n13] = lArray3[n13] ^ ((GF2m)object).o[n7];
                }
            } else if (((GF2m)object).d <= 6) {
                long[] lArray6 = ((GF2m)object).o;
                long l6 = lArray[0];
                long l7 = lArray[1];
                long l8 = lArray4[0];
                long l9 = lArray4[1];
                lArray = new long[2];
                GF2m.a(l6, l8, lArray);
                long l10 = lArray[0];
                long l11 = lArray[1];
                GF2m.a(l7, l9, lArray);
                long l12 = lArray[1];
                GF2m.a(l6 ^ l7, l8 ^ l9, lArray);
                long l13 = lArray[0];
                long l14 = lArray[1];
                lArray6[3] = l12;
                lArray6[2] = l14 ^ l12 ^ (l11 ^= lArray[0]);
                lArray6[1] = l13 ^ l10 ^ l11;
                lArray6[0] = l10;
                n7 = 6 - ((GF2m)object).d << 1;
                for (n5 = 3 - n7; n5 >= 0; --n5) {
                    int n14 = n5;
                    lArray3[n14] = lArray3[n14] ^ ((GF2m)object).o[n5 + n7];
                    int n15 = n5 + 4;
                    lArray3[n15] = lArray3[n15] ^ ((GF2m)object).o[n5 + n7];
                }
            } else {
                super.a(lArray, lArray4, lArray3, false);
            }
        }
        this.reducePoly(this.g, lArray2);
    }

    public final void square(long[] lArray, long[] lArray2) {
        for (int i2 = 0; i2 < this.d; ++i2) {
            long l2 = lArray[i2];
            this.h[2 * i2] = (long)s[(int)(l2 >>> 56)] << 48 | (long)s[(int)(l2 >>> 48) & 0xFF] << 32 | (long)s[(int)(l2 >>> 40) & 0xFF] << 16 | (long)s[(int)(l2 >> 32) & 0xFF];
            this.h[2 * i2 + 1] = (long)s[(int)(l2 >>> 24) & 0xFF] << 48 | (long)s[(int)(l2 >>> 16) & 0xFF] << 32 | (long)s[(int)(l2 >>> 8) & 0xFF] << 16 | (long)s[(int)l2 & 0xFF];
        }
        this.reducePoly(this.h, lArray2);
    }

    public final void invert(long[] lArray, long[] lArray2) {
        if (LongIntUtils.equals(lArray, this.b)) {
            throw new RuntimeException("inverting ZERO");
        }
        if (LongIntUtils.equals(lArray, this.c)) {
            LongIntUtils.copy(lArray, lArray2);
            return;
        }
        if (this.f == null) {
            int n2 = this.e[0] + 63 >>> 6;
            this.f = new long[n2];
            int n3 = this.e.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = n2 - 1 - (this.e[i2] >>> 6);
                this.f[n4] = this.f[n4] | 1L << (this.e[i2] & 0x3F);
            }
        }
        this.gcd(lArray, this.f, null, lArray2, null);
    }

    public final boolean solveQuadraticEq(long[] object, long[] lArray) {
        if (this.trace((long[])object) != 0) {
            return false;
        }
        if (LongIntUtils.equals((long[])object, this.b)) {
            LongIntUtils.copy((long[])object, lArray);
            return true;
        }
        long[] lArray2 = lArray;
        lArray = object;
        object = this;
        LongIntUtils.copy(lArray, lArray2);
        for (int i2 = 0; i2 < (((GF2m)object).e[0] - 1) / 2; ++i2) {
            ((GF2m)object).square(lArray2, lArray2);
            ((GF2m)object).square(lArray2, lArray2);
            GF2m.add(lArray, lArray2, lArray2);
        }
        return true;
    }

    public final void squareRoot(long[] lArray, long[] lArray2) {
        LongIntUtils.copy(lArray, lArray2);
        if (LongIntUtils.equals(lArray, this.b) || LongIntUtils.equals(lArray, this.c)) {
            return;
        }
        int n2 = this.e[0] - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.square(lArray2, lArray2);
        }
    }

    public final int trace(long[] lArray) {
        LongIntUtils.copy(lArray, this.n);
        for (int i2 = this.e[0] - 2; i2 >= 0; --i2) {
            this.square(this.n, this.n);
            GF2m.add(lArray, this.n, this.n);
        }
        return (int)this.n[this.d - 1];
    }

    public final void gcd(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        int n2;
        LongIntUtils.copy(lArray, this.i);
        LongIntUtils.copy(lArray2, this.j);
        LongIntUtils.copy(this.c, this.k);
        LongIntUtils.copy(this.b, this.l);
        while ((n2 = LongIntUtils.bitLength(this.i)) > 1) {
            int n3 = n2 - LongIntUtils.bitLength(this.j);
            if (n3 < 0) {
                long[] lArray6 = this.i;
                this.i = this.j;
                this.j = lArray6;
                lArray6 = this.k;
                this.k = this.l;
                this.l = lArray6;
                n3 = -n3;
            }
            LongIntUtils.shiftLeft(this.j, n3, this.m);
            GF2m.add(this.i, this.m, this.i);
            LongIntUtils.shiftLeft(this.l, n3, this.m);
            GF2m.add(this.k, this.m, this.k);
        }
        if (lArray3 != null) {
            LongIntUtils.copy(this.i, lArray3);
        }
        if (lArray4 != null) {
            LongIntUtils.copy(this.k, lArray4);
        }
        if (lArray5 != null) {
            LongIntUtils.copy(this.l, lArray5);
        }
    }

    public final void reducePoly(long[] lArray, long[] lArray2) {
        int n2;
        int n3;
        int n4;
        int n5 = LongIntUtils.bitLength(lArray) - 1;
        if (n5 < (n4 = this.e[0])) {
            System.arraycopy(lArray, this.d, lArray2, 0, this.d);
            return;
        }
        if (n5 > (n4 << 1) - 2) {
            throw new RuntimeException("deg(x) > 2*deg(f) - 2");
        }
        int n6 = 2 * this.d - 1;
        int n7 = this.e.length;
        int n8 = 0;
        int n9 = 0;
        int n10 = n6 - (this.e[0] >>> 6);
        int n11 = n6 - (this.e[1] >>> 6);
        int n12 = n6 - (this.e[2] >>> 6);
        int n13 = this.e[0] & 0x3F;
        int n14 = this.e[1] & 0x3F;
        int n15 = this.e[2] & 0x3F;
        if (n7 == 5) {
            n8 = n6 - (this.e[3] >>> 6);
            n9 = this.e[3] & 0x3F;
        }
        if (n10 == (n3 = n5 - (n4 - n13) >>> 6)) {
            long l2 = lArray[0] >>> n13;
            lArray[0] = lArray[0] ^ l2 << n13;
            int n16 = n2 = n11 - n3;
            lArray[n16] = lArray[n16] ^ l2 << n14;
            if (n2 != 0 && n14 != 0) {
                int n17 = n2 - 1;
                lArray[n17] = lArray[n17] ^ l2 >>> -n14;
            }
            int n18 = n2 = n12 - n3;
            lArray[n18] = lArray[n18] ^ l2 << n15;
            if (n2 != 0 && n15 != 0) {
                int n19 = n2 - 1;
                lArray[n19] = lArray[n19] ^ l2 >>> -n15;
            }
            if (n7 == 5) {
                int n20 = n2 = n8 - n3;
                lArray[n20] = lArray[n20] ^ l2 << n9;
                if (n2 != 0 && n9 != 0) {
                    int n21 = n2 - 1;
                    lArray[n21] = lArray[n21] ^ l2 >>> -n9;
                }
                int n22 = n6 - n3;
                lArray[n22] = lArray[n22] ^ l2;
            }
            --n3;
        }
        while (n5 >= n4) {
            while (n3 >= 0) {
                int n23 = n10 - n3;
                int n24 = n11 - n3;
                n2 = n12 - n3;
                long l3 = lArray[n23] >>> n13 | lArray[n23 - 1] << -n13;
                int n25 = n23;
                lArray[n25] = lArray[n25] ^ l3 << n13;
                int n26 = n23 - 1;
                lArray[n26] = lArray[n26] ^ l3 >>> -n13;
                int n27 = n24;
                lArray[n27] = lArray[n27] ^ l3 << n14;
                if (n14 != 0) {
                    int n28 = n24 - 1;
                    lArray[n28] = lArray[n28] ^ l3 >>> -n14;
                }
                int n29 = n2;
                lArray[n29] = lArray[n29] ^ l3 << n15;
                if (n7 == 5) {
                    n5 = n8 - n3;
                    n23 = n6 - n3;
                    if (n15 != 0) {
                        int n30 = n2 - 1;
                        lArray[n30] = lArray[n30] ^ l3 >>> -n15;
                    }
                    int n31 = n5;
                    lArray[n31] = lArray[n31] ^ l3 << n9;
                    if (n9 != 0) {
                        int n32 = n5 - 1;
                        lArray[n32] = lArray[n32] ^ l3 >>> -n9;
                    }
                    int n33 = n23;
                    lArray[n33] = lArray[n33] ^ l3;
                }
                --n3;
            }
            n5 = LongIntUtils.bitLength(lArray) - 1;
            n3 = n5 - (n4 - n13) >>> 6;
        }
        System.arraycopy(lArray, this.d, lArray2, 0, this.d);
    }

    private static void a(long l2, long l3, long[] lArray) {
        long l4 = 0L;
        long l5 = 0L;
        if (((int)l3 & 1) != 0) {
            l4 = 0L ^ l2;
        }
        if (((int)l3 & 2) != 0) {
            l4 ^= l2 << 1;
            l5 = 0L ^ l2 >>> 63;
        }
        if (((int)l3 & 4) != 0) {
            l4 ^= l2 << 2;
            l5 ^= l2 >>> 62;
        }
        if (((int)l3 & 8) != 0) {
            l4 ^= l2 << 3;
            l5 ^= l2 >>> 61;
        }
        if (((int)l3 & 0x10) != 0) {
            l4 ^= l2 << 4;
            l5 ^= l2 >>> 60;
        }
        if (((int)l3 & 0x20) != 0) {
            l4 ^= l2 << 5;
            l5 ^= l2 >>> 59;
        }
        if (((int)l3 & 0x40) != 0) {
            l4 ^= l2 << 6;
            l5 ^= l2 >>> 58;
        }
        if (((int)l3 & 0x80) != 0) {
            l4 ^= l2 << 7;
            l5 ^= l2 >>> 57;
        }
        if (((int)l3 & 0x100) != 0) {
            l4 ^= l2 << 8;
            l5 ^= l2 >>> 56;
        }
        if (((int)l3 & 0x200) != 0) {
            l4 ^= l2 << 9;
            l5 ^= l2 >>> 55;
        }
        if (((int)l3 & 0x400) != 0) {
            l4 ^= l2 << 10;
            l5 ^= l2 >>> 54;
        }
        if (((int)l3 & 0x800) != 0) {
            l4 ^= l2 << 11;
            l5 ^= l2 >>> 53;
        }
        if (((int)l3 & 0x1000) != 0) {
            l4 ^= l2 << 12;
            l5 ^= l2 >>> 52;
        }
        if (((int)l3 & 0x2000) != 0) {
            l4 ^= l2 << 13;
            l5 ^= l2 >>> 51;
        }
        if (((int)l3 & 0x4000) != 0) {
            l4 ^= l2 << 14;
            l5 ^= l2 >>> 50;
        }
        if (((int)l3 & 0x8000) != 0) {
            l4 ^= l2 << 15;
            l5 ^= l2 >>> 49;
        }
        if (((int)l3 & 0x10000) != 0) {
            l4 ^= l2 << 16;
            l5 ^= l2 >>> 48;
        }
        if (((int)l3 & 0x20000) != 0) {
            l4 ^= l2 << 17;
            l5 ^= l2 >>> 47;
        }
        if (((int)l3 & 0x40000) != 0) {
            l4 ^= l2 << 18;
            l5 ^= l2 >>> 46;
        }
        if (((int)l3 & 0x80000) != 0) {
            l4 ^= l2 << 19;
            l5 ^= l2 >>> 45;
        }
        if (((int)l3 & 0x100000) != 0) {
            l4 ^= l2 << 20;
            l5 ^= l2 >>> 44;
        }
        if (((int)l3 & 0x200000) != 0) {
            l4 ^= l2 << 21;
            l5 ^= l2 >>> 43;
        }
        if (((int)l3 & 0x400000) != 0) {
            l4 ^= l2 << 22;
            l5 ^= l2 >>> 42;
        }
        if (((int)l3 & 0x800000) != 0) {
            l4 ^= l2 << 23;
            l5 ^= l2 >>> 41;
        }
        if (((int)l3 & 0x1000000) != 0) {
            l4 ^= l2 << 24;
            l5 ^= l2 >>> 40;
        }
        if (((int)l3 & 0x2000000) != 0) {
            l4 ^= l2 << 25;
            l5 ^= l2 >>> 39;
        }
        if (((int)l3 & 0x4000000) != 0) {
            l4 ^= l2 << 26;
            l5 ^= l2 >>> 38;
        }
        if (((int)l3 & 0x8000000) != 0) {
            l4 ^= l2 << 27;
            l5 ^= l2 >>> 37;
        }
        if (((int)l3 & 0x10000000) != 0) {
            l4 ^= l2 << 28;
            l5 ^= l2 >>> 36;
        }
        if (((int)l3 & 0x20000000) != 0) {
            l4 ^= l2 << 29;
            l5 ^= l2 >>> 35;
        }
        if (((int)l3 & 0x40000000) != 0) {
            l4 ^= l2 << 30;
            l5 ^= l2 >>> 34;
        }
        if (((int)l3 & Integer.MIN_VALUE) != 0) {
            l4 ^= l2 << 31;
            l5 ^= l2 >>> 33;
        }
        if ((l3 & 0x100000000L) != 0L) {
            l4 ^= l2 << 32;
            l5 ^= l2 >>> 32;
        }
        if ((l3 & 0x200000000L) != 0L) {
            l4 ^= l2 << 33;
            l5 ^= l2 >>> 31;
        }
        if ((l3 & 0x400000000L) != 0L) {
            l4 ^= l2 << 34;
            l5 ^= l2 >>> 30;
        }
        if ((l3 & 0x800000000L) != 0L) {
            l4 ^= l2 << 35;
            l5 ^= l2 >>> 29;
        }
        if ((l3 & 0x1000000000L) != 0L) {
            l4 ^= l2 << 36;
            l5 ^= l2 >>> 28;
        }
        if ((l3 & 0x2000000000L) != 0L) {
            l4 ^= l2 << 37;
            l5 ^= l2 >>> 27;
        }
        if ((l3 & 0x4000000000L) != 0L) {
            l4 ^= l2 << 38;
            l5 ^= l2 >>> 26;
        }
        if ((l3 & 0x8000000000L) != 0L) {
            l4 ^= l2 << 39;
            l5 ^= l2 >>> 25;
        }
        if ((l3 & 0x10000000000L) != 0L) {
            l4 ^= l2 << 40;
            l5 ^= l2 >>> 24;
        }
        if ((l3 & 0x20000000000L) != 0L) {
            l4 ^= l2 << 41;
            l5 ^= l2 >>> 23;
        }
        if ((l3 & 0x40000000000L) != 0L) {
            l4 ^= l2 << 42;
            l5 ^= l2 >>> 22;
        }
        if ((l3 & 0x80000000000L) != 0L) {
            l4 ^= l2 << 43;
            l5 ^= l2 >>> 21;
        }
        if ((l3 & 0x100000000000L) != 0L) {
            l4 ^= l2 << 44;
            l5 ^= l2 >>> 20;
        }
        if ((l3 & 0x200000000000L) != 0L) {
            l4 ^= l2 << 45;
            l5 ^= l2 >>> 19;
        }
        if ((l3 & 0x400000000000L) != 0L) {
            l4 ^= l2 << 46;
            l5 ^= l2 >>> 18;
        }
        if ((l3 & 0x800000000000L) != 0L) {
            l4 ^= l2 << 47;
            l5 ^= l2 >>> 17;
        }
        if ((l3 & 0x1000000000000L) != 0L) {
            l4 ^= l2 << 48;
            l5 ^= l2 >>> 16;
        }
        if ((l3 & 0x2000000000000L) != 0L) {
            l4 ^= l2 << 49;
            l5 ^= l2 >>> 15;
        }
        if ((l3 & 0x4000000000000L) != 0L) {
            l4 ^= l2 << 50;
            l5 ^= l2 >>> 14;
        }
        if ((l3 & 0x8000000000000L) != 0L) {
            l4 ^= l2 << 51;
            l5 ^= l2 >>> 13;
        }
        if ((l3 & 0x10000000000000L) != 0L) {
            l4 ^= l2 << 52;
            l5 ^= l2 >>> 12;
        }
        if ((l3 & 0x20000000000000L) != 0L) {
            l4 ^= l2 << 53;
            l5 ^= l2 >>> 11;
        }
        if ((l3 & 0x40000000000000L) != 0L) {
            l4 ^= l2 << 54;
            l5 ^= l2 >>> 10;
        }
        if ((l3 & 0x80000000000000L) != 0L) {
            l4 ^= l2 << 55;
            l5 ^= l2 >>> 9;
        }
        if ((l3 & 0x100000000000000L) != 0L) {
            l4 ^= l2 << 56;
            l5 ^= l2 >>> 8;
        }
        if ((l3 & 0x200000000000000L) != 0L) {
            l4 ^= l2 << 57;
            l5 ^= l2 >>> 7;
        }
        if ((l3 & 0x400000000000000L) != 0L) {
            l4 ^= l2 << 58;
            l5 ^= l2 >>> 6;
        }
        if ((l3 & 0x800000000000000L) != 0L) {
            l4 ^= l2 << 59;
            l5 ^= l2 >>> 5;
        }
        if ((l3 & 0x1000000000000000L) != 0L) {
            l4 ^= l2 << 60;
            l5 ^= l2 >>> 4;
        }
        if ((l3 & 0x2000000000000000L) != 0L) {
            l4 ^= l2 << 61;
            l5 ^= l2 >>> 3;
        }
        if ((l3 & 0x4000000000000000L) != 0L) {
            l4 ^= l2 << 62;
            l5 ^= l2 >>> 2;
        }
        if ((l3 & Long.MIN_VALUE) != 0L) {
            l4 ^= l2 << 63;
            l5 ^= l2 >>> 1;
        }
        lArray[0] = l5;
        lArray[1] = l4;
    }

    private void a(long[] lArray, long[] lArray2, long[] lArray3, boolean bl) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        int n2;
        long[] lArray4 = new long[2];
        int n3 = n2 = bl ? lArray.length : lArray.length - 4;
        if (bl && n2 >= 4) {
            l9 = lArray[n2 - 4];
            l8 = lArray[n2 - 3];
            l7 = lArray[n2 - 2];
            l6 = lArray[n2 - 1];
            l5 = lArray2[n2 - 4];
            l4 = lArray2[n2 - 3];
            l3 = lArray2[n2 - 2];
            l2 = lArray2[n2 - 1];
        } else {
            this.r[0] = 0L;
            this.r[1] = 0L;
            this.r[2] = 0L;
            this.r[3] = 0L;
            System.arraycopy(lArray, 0, this.r, 4 - n2, n2);
            l9 = this.r[0];
            l8 = this.r[1];
            l7 = this.r[2];
            l6 = this.r[3];
            this.r[0] = 0L;
            this.r[1] = 0L;
            this.r[2] = 0L;
            this.r[3] = 0L;
            System.arraycopy(lArray2, 0, this.r, 4 - n2, n2);
            l5 = this.r[0];
            l4 = this.r[1];
            l3 = this.r[2];
            l2 = this.r[3];
        }
        GF2m.a(l9, l5, lArray4);
        long l10 = lArray4[0];
        long l11 = lArray4[1];
        GF2m.a(l8, l4, lArray4);
        long l12 = lArray4[0];
        long l13 = lArray4[1];
        GF2m.a(l7, l3, lArray4);
        long l14 = lArray4[0];
        long l15 = lArray4[1];
        GF2m.a(l6, l2, lArray4);
        long l16 = lArray4[0];
        long l17 = lArray4[1];
        GF2m.a(l9 ^ l8, l5 ^ l4, lArray4);
        long l18 = lArray4[0];
        long l19 = lArray4[1];
        GF2m.a(l7 ^ l6, l3 ^ l2, lArray4);
        long l20 = lArray4[0];
        long l21 = lArray4[1];
        GF2m.a(l9 ^ l7, l5 ^ l3, lArray4);
        long l22 = lArray4[0];
        long l23 = lArray4[1];
        GF2m.a(l8 ^ l6, l4 ^ l2, lArray4);
        long l24 = lArray4[0];
        long l25 = lArray4[1];
        GF2m.a(l9 ^ l8 ^ l7 ^ l6, l5 ^ l4 ^ l3 ^ l2, lArray4);
        long l26 = lArray4[0];
        long l27 = lArray4[1];
        long l28 = l17 ^ l15 ^ l16;
        long l29 = l28 ^ l13 ^ l14;
        long l30 = l29 ^ l11 ^ l12;
        long l31 = l30 ^ l17 ^ l10;
        long l32 = l31 ^ l15 ^ l16;
        long l33 = l32 ^ l13 ^ l14;
        long l34 = l23 ^ l24;
        this.r[7] = l17;
        this.r[6] = l21 ^ l28;
        this.r[5] = l25 ^ l29 ^ l20;
        this.r[4] = l27 ^ l25 ^ l19 ^ l21 ^ l30 ^ l34;
        this.r[3] = l26 ^ l22 ^ l18 ^ l20 ^ l31 ^ l34;
        this.r[2] = l19 ^ l32 ^ l22;
        this.r[1] = l18 ^ l33;
        this.r[0] = l10;
        if (!bl) {
            int n4;
            System.arraycopy(this.r, 2 * (4 - n2), lArray3, 0, 2 * n2 - 4);
            int n5 = 2 * n2 - 4;
            for (n4 = 4; n4 < 8; ++n4) {
                int n6 = n5++;
                lArray3[n6] = lArray3[n6] ^ this.r[n4];
            }
            n5 = 4;
            for (n4 = 2 * (4 - n2); n4 < 8; ++n4) {
                int n7 = n5++;
                lArray3[n7] = lArray3[n7] ^ this.r[n4];
            }
            return;
        }
        if (n2 >= 4) {
            System.arraycopy(this.r, 0, lArray3, 2 * (n2 - 4), 8);
            return;
        }
        System.arraycopy(this.r, 2 * (4 - n2), lArray3, 0, 2 * n2);
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = 1;
            int n3 = 1;
            GF2m.s[i2] = 0;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((i2 & n2) != 0) {
                    int n4 = i2;
                    s[n4] = (short)(s[n4] | n3);
                }
                n2 <<= 1;
                n3 <<= 2;
            }
        }
    }
}

