/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.Utils;
import java.util.Random;

public final class GFp {
    private final int a;
    private GFp b = null;
    private final BigInt c;
    private final int[] d;
    private final int[] e;
    private final int[] f;
    private final int[] g;
    public static final int WITHOUT_DOMAIN = 0;
    public static final int MONTGOMERY_DOMAIN = 1;
    public static final int AUTO_DOMAIN = 2;
    private final int h;
    private final int i;
    private int j;
    private int k;
    private int l;
    private final int[] m;
    private final int[] n;
    private final int[] o;
    private final int[] p;
    private final int[] q;
    private final int[] r;
    private final int[] s;
    private final int[] t;
    private final int[] u;
    private final int[] v;
    private final int[] w;
    private final int[] x;
    private final int[] y;
    private final int[] z;
    private final int[] A;
    private final int[] B;
    private final int[] C;
    private final int[] D;
    private final int[] E;
    private final int[] F;
    private final int[] G;
    private final int[] H;
    private final int[] I;
    private final int[] J;
    private final int[] K;
    private final int[] L;
    private final int[] M;
    private final int[] N;
    private final int[] O;
    private final int[] P;
    private final int[] Q;
    private final int[] R;
    private final int[] S;
    private final int[][] T;
    private final int[] U;
    private final int[][] V;
    private final int[] W;

    public GFp(int[] nArray) {
        this(nArray, 0);
    }

    public GFp(int[] nArray, int n2) {
        this.d = nArray;
        this.a = nArray.length;
        this.c = new BigInt(this.a);
        this.i = this.a - 1;
        this.h = this.a - Utils.wordLength(nArray);
        this.f = new int[this.a];
        this.g = new int[this.a];
        this.e = this.c.getZero();
        this.n = new int[this.a << 1];
        this.o = new int[this.a << 1];
        this.u = new int[this.a << 1];
        this.v = new int[(this.a << 1) + 1];
        this.w = new int[this.a];
        this.x = new int[this.a];
        this.y = new int[this.a];
        this.z = new int[this.a];
        this.E = new int[this.a];
        this.F = new int[this.a];
        this.G = new int[this.a];
        this.H = new int[this.a];
        this.I = new int[this.a];
        this.p = new int[this.a];
        this.q = new int[this.a];
        this.r = new int[this.a];
        this.s = new int[this.a];
        this.t = new int[this.a];
        this.J = new int[this.a];
        this.K = new int[this.a];
        this.L = new int[this.a];
        this.M = new int[this.a];
        this.N = new int[this.a];
        this.O = new int[this.a];
        this.P = new int[this.a];
        this.Q = new int[this.a];
        this.R = new int[this.a];
        this.S = new int[this.a];
        this.A = new int[this.a << 1];
        this.D = new int[this.a << 1];
        this.B = new int[this.a];
        this.C = new int[this.a];
        this.m = new int[this.a];
        this.U = new int[this.a << 5];
        this.T = new int[16][this.a];
        this.W = new int[this.a << 5];
        this.V = new int[16][this.a];
        this.init(n2);
    }

    public final void init(int n2) {
        switch (n2) {
            case 0: {
                this.j = 1;
                this.b = new GFp(this.d, 2);
                break;
            }
            case 1: {
                this.j = 2;
                this.l = GFp.a(this.d);
                break;
            }
            case 2: {
                if (this.a == 8) {
                    if (this.d[0] == -1) {
                        for (n2 = 0; n2 < this.i && this.d[n2] == -1; ++n2) {
                        }
                        if (n2 == this.i) {
                            this.j = 3;
                            this.k = -this.d[this.i];
                        }
                    } else if (this.d[0] == Integer.MIN_VALUE) {
                        for (n2 = 1; n2 < this.i && this.d[n2] == 0; ++n2) {
                        }
                        if (n2 == this.i && this.d[this.i] > 0) {
                            this.j = 4;
                            this.k = this.d[this.i] << 1;
                        }
                    }
                }
                if (this.j != 0) break;
                this.j = 2;
                this.l = GFp.a(this.d);
                break;
            }
            default: {
                this.j = 1;
                this.b = new GFp(this.d, 2);
            }
        }
        this.toInternalDomain(this.c.getOne(), this.f);
        this.toInternalDomain(this.c.getTwo(), this.g);
        if (this.j == 2) {
            for (n2 = 0; n2 < this.h << 1; ++n2) {
                this.u[n2] = 0;
            }
            for (n2 = this.h << 1; n2 < this.a << 1; ++n2) {
                this.u[n2] = -1;
            }
            this.c.divide(this.u, this.d, null, this.m);
            this.c.add(this.m, this.c.getOne(), this.m);
            return;
        }
        Utils.copy(this.e, this.u);
        this.u[this.a - 1 + this.h] = 1;
        this.c.divide(this.u, this.d, null, this.p);
        this.a(this.p, this.m);
    }

    public final BigInt getBigInt() {
        return this.c;
    }

    public final int[] getZero() {
        return (int[])this.e.clone();
    }

    public final int[] getOne() {
        return (int[])this.f.clone();
    }

    public final int[] getTwo() {
        return (int[])this.g.clone();
    }

    public final int[] getOrder() {
        return (int[])this.d.clone();
    }

    public final void toInternalDomain(int[] nArray, int[] nArray2) {
        if (this.j == 2) {
            Utils.copy(this.e, this.u);
            System.arraycopy(nArray, 0, this.u, this.h, this.a);
            this.c.divide(this.u, this.d, null, nArray2);
            return;
        }
        Utils.copy(nArray, nArray2);
    }

    public final void fromInternalDomain(int[] nArray, int[] nArray2) {
        if (this.j == 2) {
            this.b(nArray, nArray2);
            return;
        }
        Utils.copy(nArray, nArray2);
    }

    public final void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.c.add(nArray, nArray2, nArray3) > 0 || BigInt.compare(nArray3, this.d) >= 0) {
            this.c.subtract(nArray3, this.d, nArray3);
        }
    }

    public final void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.c.subtract(nArray, nArray2, nArray3) < 0) {
            this.c.add(nArray3, this.d, nArray3);
        }
    }

    public final void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.a == 8) {
            int[] nArray4 = this.n;
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = nArray[3];
            int n6 = nArray[4];
            int n7 = nArray[5];
            int n8 = nArray[6];
            int n9 = nArray[7];
            long l2 = n9 & 0x1FFFFFFF;
            long l3 = n9 >>> 29 | (n8 & 0x3FFFFFF) << 3;
            long l4 = n8 >>> 26 | (n7 & 0x7FFFFF) << 6;
            long l5 = n7 >>> 23 | (n6 & 0xFFFFF) << 9;
            long l6 = n6 >>> 20 | (n5 & 0x1FFFF) << 12;
            long l7 = n5 >>> 17 | (n4 & 0x3FFF) << 15;
            long l8 = n4 >>> 14 | (n3 & 0x7FF) << 18;
            long l9 = n3 >>> 11 | (n2 & 0xFF) << 21;
            long l10 = n2 >>> 8;
            n2 = nArray2[0];
            n3 = nArray2[1];
            n4 = nArray2[2];
            n5 = nArray2[3];
            n6 = nArray2[4];
            n7 = nArray2[5];
            n8 = nArray2[6];
            n9 = nArray2[7];
            long l11 = n9 & 0x1FFFFFFF;
            long l12 = n9 >>> 29 | (n8 & 0x3FFFFFF) << 3;
            long l13 = n8 >>> 26 | (n7 & 0x7FFFFF) << 6;
            long l14 = n7 >>> 23 | (n6 & 0xFFFFF) << 9;
            long l15 = n6 >>> 20 | (n5 & 0x1FFFF) << 12;
            long l16 = n5 >>> 17 | (n4 & 0x3FFF) << 15;
            long l17 = n4 >>> 14 | (n3 & 0x7FF) << 18;
            long l18 = n3 >>> 11 | (n2 & 0xFF) << 21;
            long l19 = n2 >>> 8;
            long l20 = l2 * l11;
            long l21 = l3 * l12;
            long l22 = l4 * l13;
            long l23 = l5 * l14;
            long l24 = l6 * l15;
            long l25 = l7 * l16;
            long l26 = l8 * l17;
            long l27 = l9 * l18;
            long l28 = l10 * l19;
            long l29 = (l3 + l2) * (l12 + l11) - l21 - l20;
            long l30 = (l4 + l2) * (l13 + l11) - l22 - l20 + l21;
            long l31 = (l4 + l3) * (l13 + l12) - l22 - l21;
            long l32 = (l6 + l5) * (l15 + l14) - l24 - l23;
            long l33 = (l7 + l5) * (l16 + l14) - l25 - l23 + l24;
            long l34 = (l7 + l6) * (l16 + l15) - l25 - l24;
            long l35 = (l9 + l8) * (l18 + l17) - l27 - l26;
            long l36 = (l10 + l8) * (l19 + l17) - l28 - l26 + l27;
            long l37 = (l10 + l9) * (l19 + l18) - l28 - l27;
            long l38 = l7 + l4;
            long l39 = l6 + l3;
            long l40 = l5 + l2;
            long l41 = l16 + l13;
            long l42 = l15 + l12;
            long l43 = l14 + l11;
            long l44 = l40 * l43;
            long l45 = l39 * l42;
            long l46 = l38 * l41;
            long l47 = l10 + l4;
            long l48 = l9 + l3;
            long l49 = l8 + l2;
            long l50 = l19 + l13;
            long l51 = l18 + l12;
            long l52 = l17 + l11;
            long l53 = l49 * l52;
            long l54 = l48 * l51;
            long l55 = l47 * l50;
            long l56 = l10 + l7;
            long l57 = l9 + l6;
            long l58 = l8 + l5;
            long l59 = l19 + l16;
            long l60 = l18 + l15;
            long l61 = l17 + l14;
            long l62 = l58 * l61;
            long l63 = l57 * l60;
            long l64 = l56 * l59;
            long l65 = l20 >>> 29;
            long l66 = l20 & 0x1FFFFFFFL;
            long l67 = (l65 += l29) >>> 29;
            l65 &= 0x1FFFFFFFL;
            long l68 = (l67 += l30) >>> 29;
            l67 &= 0x1FFFFFFFL;
            long l69 = (l68 += l31 + (l44 - l20 - l23)) >>> 29;
            l68 &= 0x1FFFFFFFL;
            long l70 = (l69 += l22 + ((l39 + l40) * (l42 + l43) - l45 - l44 - l29 - l32)) >>> 29;
            l69 &= 0x1FFFFFFFL;
            long l71 = (l70 += (l38 + l40) * (l41 + l43) - l46 - l44 + l45 - l30 - l33) >>> 29;
            l70 &= 0x1FFFFFFFL;
            long l72 = (l71 += (l38 + l39) * (l41 + l42) - l46 - l45 - l31 - l34 + (l53 - l26 - l20 + l23)) >>> 29;
            l71 &= 0x1FFFFFFFL;
            long l73 = (l72 += l46 - l22 - l25 + ((l48 + l49) * (l51 + l52) - l54 - l53 - l35 - l29 + l32)) >>> 29;
            l72 &= 0x1FFFFFFFL;
            long l74 = (l73 += (l47 + l49) * (l50 + l52) - l55 - l53 + l54 - l36 - l30 + l33) >>> 29;
            l73 &= 0x1FFFFFFFL;
            long l75 = (l74 += (l47 + l48) * (l50 + l51) - l55 - l54 - l37 - l31 + l34 + (l62 - l26 - l23)) >>> 29;
            l74 &= 0x1FFFFFFFL;
            long l76 = (l75 += l55 - l28 - l22 + l25 + ((l57 + l58) * (l60 + l61) - l63 - l62 - l35 - l32)) >>> 29;
            l75 &= 0x1FFFFFFFL;
            long l77 = (l76 += (l56 + l58) * (l59 + l61) - l64 - l62 + l63 - l36 - l33) >>> 29;
            l76 &= 0x1FFFFFFFL;
            long l78 = (l77 += (l56 + l57) * (l59 + l60) - l64 - l63 - l37 - l34 + l26) >>> 29;
            l77 &= 0x1FFFFFFFL;
            long l79 = (l78 += l64 - l28 - l25 + l35) >>> 29;
            l78 &= 0x1FFFFFFFL;
            long l80 = (l79 += l36) >>> 29;
            l79 &= 0x1FFFFFFFL;
            long l81 = (l80 += l37) >>> 29;
            l80 &= 0x1FFFFFFFL;
            long l82 = (l81 += l28) >>> 29;
            l81 &= 0x1FFFFFFFL;
            nArray4[15] = (int)(l65 << 29 | l66);
            nArray4[14] = (int)(l67 << 26 | l65 >>> 3);
            nArray4[13] = (int)(l68 << 23 | l67 >>> 6);
            nArray4[12] = (int)(l69 << 20 | l68 >>> 9);
            nArray4[11] = (int)(l70 << 17 | l69 >>> 12);
            nArray4[10] = (int)(l71 << 14 | l70 >>> 15);
            nArray4[9] = (int)(l72 << 11 | l71 >>> 18);
            nArray4[8] = (int)(l73 << 8 | l72 >>> 21);
            nArray4[7] = (int)(l74 << 5 | l73 >>> 24);
            nArray4[6] = (int)(l76 << 31 | l75 << 2 | l74 >>> 27);
            nArray4[5] = (int)(l77 << 28 | l76 >>> 1);
            nArray4[4] = (int)(l78 << 25 | l77 >>> 4);
            nArray4[3] = (int)(l79 << 22 | l78 >>> 7);
            nArray4[2] = (int)(l80 << 19 | l79 >>> 10);
            nArray4[1] = (int)(l81 << 16 | l80 >>> 13);
            nArray4[0] = (int)(l82 << 13 | l81 >>> 16);
        } else if (this.a == 32) {
            int n10;
            int[] nArray5 = this.n;
            for (n10 = 63; n10 >= 0; --n10) {
                nArray5[n10] = 0;
            }
            for (n10 = 31; n10 >= 0; --n10) {
                long l83 = 0L;
                for (int i2 = 31; i2 >= 0; i2 -= 2) {
                    l83 = ((long)nArray5[n10 + i2 + 1] & 0xFFFFFFFFL) + ((long)nArray[n10] & 0xFFFFFFFFL) * ((long)nArray2[i2] & 0xFFFFFFFFL) + (l83 >>> 32);
                    nArray5[n10 + i2 + 1] = (int)l83;
                    l83 = ((long)nArray5[n10 + i2] & 0xFFFFFFFFL) + ((long)nArray[n10] & 0xFFFFFFFFL) * ((long)nArray2[i2 - 1] & 0xFFFFFFFFL) + (l83 >>> 32);
                    nArray5[n10 + i2] = (int)l83;
                }
                nArray5[n10] = (int)(l83 >>> 32);
            }
        } else {
            this.c.multiply(nArray, nArray2, this.n);
        }
        this.reduce(this.n, nArray3);
    }

    public final void secureMultiply(int[] nArray, int[] nArray2, int[] nArray3) {
        this.c.multiply(nArray, nArray2, this.n);
        this.c.divide(this.n, this.d, null, nArray3);
        Utils.clean(this.n);
    }

    public final void square(int[] nArray, int[] nArray2) {
        if (this.a == 8) {
            int[] nArray3 = this.o;
            long l2 = (long)nArray[0] & 0xFFFFFFFFL;
            long l3 = (long)nArray[1] & 0xFFFFFFFFL;
            long l4 = (long)nArray[2] & 0xFFFFFFFFL;
            long l5 = (long)nArray[3] & 0xFFFFFFFFL;
            long l6 = (long)nArray[4] & 0xFFFFFFFFL;
            long l7 = (long)nArray[5] & 0xFFFFFFFFL;
            long l8 = (long)nArray[6] & 0xFFFFFFFFL;
            long l9 = (long)nArray[7] & 0xFFFFFFFFL;
            long l10 = l9 * l9;
            long l11 = l9 * l8;
            long l12 = l11 >>> 31;
            l11 = ((l11 & Integer.MAX_VALUE) << 1) + (l10 >>> 32);
            long l13 = l12 + (l11 >>> 32);
            long l14 = l9 * l7;
            l12 = l14 >>> 31;
            l14 = ((l14 & Integer.MAX_VALUE) << 1) + l13;
            l12 += l14 >>> 32;
            l14 = (l14 & 0xFFFFFFFFL) + l8 * l8;
            l13 = l12 + (l14 >>> 32);
            long l15 = l9 * l6;
            l12 = l15 >>> 32;
            l15 = (l15 & 0xFFFFFFFFL) + l8 * l7;
            l12 += l15 >>> 32;
            l15 = ((l15 & 0xFFFFFFFFL) << 1) + l13;
            l13 = (l12 << 1) + (l15 >>> 32);
            long l16 = l9 * l5;
            l12 = l16 >>> 32;
            l16 = (l16 & 0xFFFFFFFFL) + l8 * l6;
            l12 += l16 >>> 32;
            l16 = ((l16 & 0xFFFFFFFFL) << 1) + l13;
            l12 = (l12 << 1) + (l16 >>> 32);
            l16 = (l16 & 0xFFFFFFFFL) + l7 * l7;
            l13 = l12 + (l16 >>> 32);
            long l17 = l9 * l4;
            l12 = l17 >>> 32;
            l17 = (l17 & 0xFFFFFFFFL) + l8 * l5;
            l12 += l17 >>> 32;
            l17 = (l17 & 0xFFFFFFFFL) + l7 * l6;
            l12 += l17 >>> 32;
            l17 = ((l17 & 0xFFFFFFFFL) << 1) + l13;
            l13 = (l12 << 1) + (l17 >>> 32);
            long l18 = l9 * l3;
            l12 = l18 >>> 32;
            l18 = (l18 & 0xFFFFFFFFL) + l8 * l4;
            l12 += l18 >>> 32;
            l18 = (l18 & 0xFFFFFFFFL) + l7 * l5;
            l12 += l18 >>> 32;
            l18 = ((l18 & 0xFFFFFFFFL) << 1) + l13;
            l12 = (l12 << 1) + (l18 >>> 32);
            l18 = (l18 & 0xFFFFFFFFL) + l6 * l6;
            l13 = l12 + (l18 >>> 32);
            long l19 = l9 * l2;
            l12 = l19 >>> 32;
            l19 = (l19 & 0xFFFFFFFFL) + l8 * l3;
            l12 += l19 >>> 32;
            l19 = (l19 & 0xFFFFFFFFL) + l7 * l4;
            l12 += l19 >>> 32;
            l19 = (l19 & 0xFFFFFFFFL) + l6 * l5;
            l12 += l19 >>> 32;
            l19 = ((l19 & 0xFFFFFFFFL) << 1) + l13;
            l13 = (l12 << 1) + (l19 >>> 32);
            long l20 = l8 * l2;
            l12 = l20 >>> 32;
            l20 = (l20 & 0xFFFFFFFFL) + l7 * l3;
            l12 += l20 >>> 32;
            l20 = (l20 & 0xFFFFFFFFL) + l6 * l4;
            l12 += l20 >>> 32;
            l20 = ((l20 & 0xFFFFFFFFL) << 1) + l13;
            l12 = (l12 << 1) + (l20 >>> 32);
            l20 = (l20 & 0xFFFFFFFFL) + l5 * l5;
            l13 = l12 + (l20 >>> 32);
            long l21 = l7 * l2;
            l12 = l21 >>> 32;
            l21 = (l21 & 0xFFFFFFFFL) + l6 * l3;
            l12 += l21 >>> 32;
            l21 = (l21 & 0xFFFFFFFFL) + l5 * l4;
            l12 += l21 >>> 32;
            l21 = ((l21 & 0xFFFFFFFFL) << 1) + l13;
            l13 = (l12 << 1) + (l21 >>> 32);
            long l22 = l6 * l2;
            l12 = l22 >>> 32;
            l22 = (l22 & 0xFFFFFFFFL) + l5 * l3;
            l12 += l22 >>> 32;
            l22 = ((l22 & 0xFFFFFFFFL) << 1) + l13;
            l12 = (l12 << 1) + (l22 >>> 32);
            l22 = (l22 & 0xFFFFFFFFL) + l4 * l4;
            l13 = l12 + (l22 >>> 32);
            long l23 = l5 * l2;
            l12 = l23 >>> 32;
            l23 = (l23 & 0xFFFFFFFFL) + l4 * l3;
            l12 += l23 >>> 32;
            l23 = ((l23 & 0xFFFFFFFFL) << 1) + l13;
            l13 = (l12 << 1) + (l23 >>> 32);
            long l24 = l4 * l2;
            l12 = l24 >>> 31;
            l24 = ((l24 & Integer.MAX_VALUE) << 1) + l13;
            l12 += l24 >>> 32;
            l24 = (l24 & 0xFFFFFFFFL) + l3 * l3;
            l13 = l12 + (l24 >>> 32);
            long l25 = l3 * l2;
            l12 = l25 >>> 31;
            l25 = ((l25 & Integer.MAX_VALUE) << 1) + l13;
            l13 = l12 + (l25 >>> 32);
            long l26 = l2 * l2 + l13;
            long l27 = l26 >>> 32;
            nArray3[0] = (int)l27;
            nArray3[1] = (int)l26;
            nArray3[2] = (int)l25;
            nArray3[3] = (int)l24;
            nArray3[4] = (int)l23;
            nArray3[5] = (int)l22;
            nArray3[6] = (int)l21;
            nArray3[7] = (int)l20;
            nArray3[8] = (int)l19;
            nArray3[9] = (int)l18;
            nArray3[10] = (int)l17;
            nArray3[11] = (int)l16;
            nArray3[12] = (int)l15;
            nArray3[13] = (int)l14;
            nArray3[14] = (int)l11;
            nArray3[15] = (int)l10;
        } else {
            this.c.square(nArray, this.o);
        }
        this.reduce(this.o, nArray2);
    }

    public final void modPow(int[] nArray, int[] nArray2, int[] nArray3) {
        this.modPow(nArray, nArray2, null, null, null, null, nArray3);
    }

    public final void modPow(int[] nArray, int[] nArray2, int[][] nArray3, int[] nArray4, int[] nArray5, int[][] nArray6, int[] nArray7) {
        if (this.j == 1) {
            int[] nArray8 = this.p;
            int[] nArray9 = this.q;
            if (nArray != null) {
                this.b.toInternalDomain(nArray, nArray8);
            } else {
                nArray8 = null;
            }
            if (nArray4 != null) {
                this.b.toInternalDomain(nArray4, nArray9);
            } else {
                nArray9 = null;
            }
            this.b.modPow(nArray8, nArray2, nArray3, nArray9, nArray5, nArray6, nArray7);
            this.b.fromInternalDomain(nArray7, nArray7);
            return;
        }
        if (nArray == null && nArray4 == null) {
            throw new RuntimeException("a && y are null");
        }
        int n2 = 0;
        int n3 = 0;
        if (nArray != null && nArray3 == null) {
            GFp.a(nArray2, 5, this.U);
            n2 = BigInt.bitLength(nArray2) - 1;
            if (!BigInt.equals(nArray, this.T[0])) {
                this.a(nArray, 5, this.T);
            }
        }
        if (nArray4 != null && nArray6 == null) {
            GFp.a(nArray5, 5, this.W);
            n3 = BigInt.bitLength(nArray5) - 1;
            this.a(nArray4, 5, this.V);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (nArray != null && nArray3 != null) {
            n6 = BigInt.bitLength(nArray3.length) - 1;
            n4 = (n6 + 256 - 1) / n6;
            n2 = n4 - 1;
        }
        if (nArray4 != null && nArray6 != null) {
            n7 = BigInt.bitLength(nArray6.length) - 1;
            n5 = (n7 + 256 - 1) / n7;
            n3 = n5 - 1;
        }
        n3 = n2 > n3 ? n2 : n3;
        Utils.copy(this.f, this.r);
        while (n3 >= 0) {
            this.square(this.r, this.r);
            if (nArray != null) {
                this.a(this.r, nArray2, nArray3, n4, n6, this.U, this.T, n3);
            }
            if (nArray4 != null) {
                this.a(this.r, nArray5, nArray6, n5, n7, this.W, this.V, n3);
            }
            --n3;
        }
        Utils.copy(this.r, nArray7);
        Utils.clean(this.U);
    }

    private void a(int[] nArray, int[] nArray2, int[][] nArray3, int n2, int n3, int[] nArray4, int[][] nArray5, int n4) {
        int n5;
        if (nArray3 != null) {
            if (n4 < n2) {
                int n6 = 0;
                int n7 = nArray2.length - 1;
                n3 = n4 + (n3 - 1) * n2;
                while (n3 >>> 5 > n7) {
                    n3 -= n2;
                }
                while (n3 >= 0) {
                    n6 <<= 1;
                    n6 |= nArray2[n7 - (n3 >>> 5)] >>> n3 & 1;
                    n3 -= n2;
                }
                if (n6 != 0) {
                    this.multiply(nArray, nArray3[n6], nArray);
                }
                return;
            }
            return;
        }
        if (n4 < nArray4.length && (n5 = nArray4[n4]) != 0) {
            this.multiply(nArray, nArray5[n5 >>> 1], nArray);
        }
    }

    public final int[][] getCombPrecomp(int[] nArray, int n2) {
        int n3 = (n2 + 256 - 1) / n2;
        int[][] nArray2 = new int[1 << n2][this.a];
        Utils.copy(nArray, this.s);
        Utils.copy(this.f, nArray2[0]);
        Utils.copy(nArray, nArray2[1]);
        for (int i2 = 1; i2 < n2; ++i2) {
            int n4;
            int n5 = 1 << i2;
            for (n4 = 0; n4 < n3; ++n4) {
                this.square(this.s, this.s);
            }
            for (n4 = 0; n4 < n5; ++n4) {
                this.multiply(nArray2[n4], this.s, nArray2[n5 | n4]);
            }
        }
        return nArray2;
    }

    public static byte[] exportPrecomp(int[] nArray, int[][] nArray2) {
        int n2 = BigInt.bitLength(nArray) + 7 >>> 3;
        int n3 = nArray2.length;
        byte[] byArray = new byte[n2 * (n3 - 1)];
        int n4 = 0;
        for (int i2 = 1; i2 < n3; ++i2) {
            byte[] byArray2 = Utils.toByteArray(nArray2[i2], n2);
            System.arraycopy(byArray2, 0, byArray, n4, n2);
            n4 += n2;
        }
        return byArray;
    }

    public final int[][] importPrecomp(byte[] byArray) {
        int n2 = BigInt.bitLength(this.d);
        n2 = n2 + 7 >>> 3;
        int n3 = BigInt.bitLength(byArray.length / n2 + 1) - 1;
        if (byArray.length % this.d.length != 0 || n3 < 2 || n3 > 21) {
            throw new IllegalArgumentException("illegal size of precomputations");
        }
        int n4 = 0;
        n3 = 1 << n3;
        int[][] nArrayArray = new int[n3][];
        byte[] byArray2 = new byte[n2];
        nArrayArray[0] = new int[this.a];
        System.arraycopy(this.f, 0, nArrayArray[0], 0, this.a);
        for (int i2 = 1; i2 < n3; ++i2) {
            System.arraycopy(byArray, n4, byArray2, 0, n2);
            n4 += n2;
            nArrayArray[i2] = Utils.fromByteArray(byArray2, this.a);
        }
        return nArrayArray;
    }

    private static void a(int[] nArray, int n2, int[] nArray2) {
        int n3;
        n2 = 0;
        int n4 = nArray.length;
        for (int i2 = (n4 << 5) - 1; i2 >= 0; --i2) {
            nArray2[i2] = 0;
            if (((n2 = n2 << 1 | nArray[n4 - 1 - (i2 >>> 5)] >>> i2 & 1) & 0x10) == 0) continue;
            n3 = 0;
            while ((n2 & 1) == 0) {
                n2 >>= 1;
                ++n3;
            }
            nArray2[i2 + n3] = n2;
            n2 = 0;
        }
        if (n2 != 0) {
            n3 = 0;
            while ((n2 & 1) == 0) {
                n2 >>= 1;
                ++n3;
            }
            nArray2[n3] = n2;
        }
    }

    private void a(int[] nArray, int n2, int[][] nArray2) {
        this.square(nArray, this.t);
        int[][] nArray3 = nArray2;
        Utils.copy(nArray, nArray3[0]);
        for (int i2 = 1; i2 < 16; ++i2) {
            this.multiply(nArray3[i2 - 1], this.t, nArray3[i2]);
        }
    }

    public final void reduce(int[] object, int[] nArray) {
        switch (this.j) {
            case 2: {
                if (this.a == 32 && this.d[0] != 0) {
                    int n2;
                    int[] nArray2 = nArray;
                    nArray = object;
                    object = this;
                    int n3 = 0;
                    System.arraycopy(nArray, 0, object.v, 0, 64);
                    for (n2 = 32; n2 > 0; --n2) {
                        long l2 = ((long)object.v[n2 + 31] & 0xFFFFFFFFL) * (long)object.l & 0xFFFFFFFFL;
                        long l3 = ((long)object.v[n2 + 31] & 0xFFFFFFFFL) + ((long)object.d[31] & 0xFFFFFFFFL) * l2;
                        for (int i2 = 30; i2 >= 0; --i2) {
                            l3 = ((long)object.v[n2 + i2] & 0xFFFFFFFFL) + ((long)object.d[i2] & 0xFFFFFFFFL) * l2 + (l3 >>> 32);
                            object.v[n2 + i2] = (int)l3;
                        }
                        l3 = ((long)object.v[n2 - 1] & 0xFFFFFFFFL) + (l3 >>> 32 & 0xFFFFFFFFL) + (long)n3;
                        object.v[n2 - 1] = (int)l3;
                        n3 = (int)(l3 >>> 32);
                    }
                    long l4 = n3;
                    for (n2 = 0; l4 == 0L && n2 < 32; ++n2) {
                        l4 = ((long)object.v[n2] & 0xFFFFFFFFL) - ((long)object.d[n2] & 0xFFFFFFFFL);
                    }
                    if (l4 >= 0L) {
                        for (n2 = 31; n2 >= 0; --n2) {
                            l4 = ((long)object.v[n2] & 0xFFFFFFFFL) - ((long)object.d[n2] & 0xFFFFFFFFL) - (long)(l4 < 0L ? 1 : 0);
                            nArray2[n2] = (int)l4;
                        }
                        break;
                    }
                    System.arraycopy(object.v, 0, nArray2, 0, 32);
                    return;
                }
                this.b((int[])object, nArray);
                return;
            }
            case 3: {
                int n4;
                int[] nArray3 = nArray;
                nArray = object;
                object = this;
                int[] nArray4 = nArray3;
                long l5 = 0L;
                for (n4 = object.i; n4 >= 0; --n4) {
                    l5 = (l5 >>> 32) + ((long)nArray[n4] & 0xFFFFFFFFL) * (long)object.k + ((long)nArray[n4 + object.a] & 0xFFFFFFFFL);
                    nArray4[n4] = (int)l5;
                }
                long l6 = l5 >>> 32;
                l5 = l6 + ((long)nArray4[0] & 0xFFFFFFFFL);
                long l7 = l6 + l5 / 0xFFFFFFFFL;
                long l8 = l5 % 0xFFFFFFFFL;
                if (l7 != 0L) {
                    if (l7 >= 0x100000000L || (l7 * 0xFFFFFFFFL ^ Long.MIN_VALUE) > ((l8 << 32) + ((long)nArray4[1] & 0xFFFFFFFFL) ^ Long.MIN_VALUE)) {
                        --l7;
                    }
                    l5 = l7 * ((long)object.d[object.i] & 0xFFFFFFFFL);
                    long l9 = ((long)nArray4[object.i] & 0xFFFFFFFFL) - (l5 & 0xFFFFFFFFL);
                    nArray4[object.i] = (int)l9;
                    long l10 = l7 * 0xFFFFFFFFL;
                    for (n4 = object.a - 2; n4 >= 0; --n4) {
                        l5 = l10 + (l5 >>> 32) + (l9 >>> 63);
                        l9 = ((long)nArray4[n4] & 0xFFFFFFFFL) - (l5 & 0xFFFFFFFFL);
                        nArray4[n4] = (int)l9;
                    }
                    if ((l9 = l6 - (l5 >>> 32) - (l9 >>> 63)) < 0L) {
                        l5 = ((long)nArray4[object.i] & 0xFFFFFFFFL) + ((long)object.d[object.i] & 0xFFFFFFFFL);
                        nArray4[object.i] = (int)l5;
                        for (n4 = object.a - 2; n4 >= 0; --n4) {
                            l5 = ((long)nArray4[n4] & 0xFFFFFFFFL) + 0xFFFFFFFFL + (l5 >>> 32);
                            nArray4[n4] = (int)l5;
                        }
                    }
                }
                return;
            }
            case 4: {
                int n5;
                int[] nArray5 = nArray;
                nArray = object;
                object = this;
                int[] nArray6 = nArray5;
                long l11 = 0L;
                long l12 = 0L;
                for (n5 = object.i; n5 >= 0; --n5) {
                    l11 = (l11 >>> 32) + ((long)nArray[n5] & 0xFFFFFFFFL) * (long)object.k;
                    l12 = (l11 & 0xFFFFFFFFL) - ((long)nArray[n5 + object.a] & 0xFFFFFFFFL) - (l12 >>> 63);
                    nArray6[n5] = (int)l12;
                }
                l12 = (l11 >>> 32) - (l12 >>> 63);
                long l13 = l12 & 0xFFFFFFFFL;
                if (l12 < 0L) {
                    l12 = 0L;
                    for (n5 = object.i; n5 >= 0; --n5) {
                        l12 = -((long)nArray6[n5] & 0xFFFFFFFFL) - (l12 >>> 63);
                        nArray6[n5] = (int)l12;
                    }
                    int n6 = 0;
                    for (n5 = 0; n5 < object.a; ++n5) {
                        if (nArray6[n5] == object.d[n5]) continue;
                        n6 = (nArray6[n5] ^ Integer.MIN_VALUE) > (object.d[n5] ^ Integer.MIN_VALUE) ? 1 : -1;
                        break;
                    }
                    if (n6 < 0) break;
                    l12 = ((long)nArray6[object.i] & 0xFFFFFFFFL) - (long)(object.k >>> 1);
                    nArray6[object.i] = (int)l12;
                    for (n5 = object.a - 2; n5 > 0; --n5) {
                        l12 = ((long)nArray6[n5] & 0xFFFFFFFFL) - (l12 >>> 63);
                        nArray6[n5] = (int)l12;
                    }
                    nArray6[0] = (int)(((long)nArray6[0] & 0xFFFFFFFFL) - 0x80000000L - (l12 >>> 63));
                    break;
                }
                long l14 = (l13 << 1) + (long)(nArray6[0] >>> 31);
                if (l14 >= 0x100000000L) {
                    --l14;
                }
                l11 = l14 * (long)(object.k >>> 1);
                l12 = ((long)nArray6[object.i] & 0xFFFFFFFFL) - (l11 & 0xFFFFFFFFL);
                nArray6[object.i] = (int)l12;
                for (n5 = object.a - 2; n5 > 0; --n5) {
                    l11 = (l11 >>> 32) + (l12 >>> 63);
                    l12 = ((long)nArray6[n5] & 0xFFFFFFFFL) - (l11 & 0xFFFFFFFFL);
                    nArray6[n5] = (int)l12;
                }
                l11 = l14 * 0x80000000L + (l11 >>> 32) + (l12 >>> 63);
                l12 = ((long)nArray6[0] & 0xFFFFFFFFL) - (l11 & 0xFFFFFFFFL);
                nArray6[0] = (int)l12;
                if ((l12 = l13 - (l11 >>> 32) - (l12 >>> 63)) < 0L) {
                    l12 = 0L;
                    for (n5 = object.i; n5 >= 0; --n5) {
                        l12 = -((long)nArray6[n5] & 0xFFFFFFFFL) - (l12 >>> 63);
                        nArray6[n5] = (int)l12;
                    }
                } else {
                    int n7 = nArray6[object.i];
                    l12 = (long)(object.k >>> 1) - ((long)nArray6[object.i] & 0xFFFFFFFFL);
                    nArray6[object.i] = (int)l12;
                    for (n5 = object.i - 1; n5 > 0; --n5) {
                        n7 |= nArray6[n5];
                        l12 = -((long)nArray6[n5] & 0xFFFFFFFFL) - (l12 >>> 63);
                        nArray6[n5] = (int)l12;
                    }
                    l12 = 0x80000000L - ((long)nArray6[0] & 0xFFFFFFFFL) - (l12 >>> 63);
                    nArray6[0] = (int)l12;
                    if ((n7 |= nArray6[0]) == 0) {
                        System.arraycopy(object.e, 0, nArray6, 0, nArray6.length);
                    }
                }
                return;
            }
            default: {
                this.c.divide((int[])object, this.d, null, nArray);
            }
        }
    }

    private static int b(int[] nArray, int n2) {
        int n3 = -GFp.a(nArray);
        if (n2 == 32) {
            return n3;
        }
        return n3 & (1 << n2) - 1;
    }

    public static int getLowestSetBit(int[] nArray) {
        int n2;
        int n3 = nArray.length;
        if (n3 == 0) {
            return -1;
        }
        for (n2 = n3 - 1; n2 > 0 && nArray[n2] == 0; --n2) {
        }
        int n4 = nArray[n2];
        if (n4 == 0) {
            return -1;
        }
        return (n3 - 1 - n2 << 5) + Integer.numberOfTrailingZeros(n4);
    }

    private void a(int[] nArray, int[] nArray2) {
        if (BigInt.equals(nArray, this.c.getOne())) {
            Utils.copy(nArray, nArray2);
            return;
        }
        Utils.copy(nArray, this.w);
        Utils.copy(this.d, this.x);
        Utils.copy(this.c.getOne(), this.y);
        Utils.copy(this.c.getZero(), this.z);
        while (!BigInt.equals(this.w, this.c.getOne()) && !BigInt.equals(this.x, this.c.getOne())) {
            while ((this.w[this.i] & 1) == 0) {
                BigInt.shiftRight(this.w, 0, 1, this.w);
                int n2 = 0;
                if ((this.y[this.i] & 1) != 0) {
                    n2 = this.c.add(this.y, this.d, this.y);
                }
                BigInt.shiftRight(this.y, n2, 1, this.y);
            }
            while ((this.x[this.i] & 1) == 0) {
                BigInt.shiftRight(this.x, 0, 1, this.x);
                int n3 = 0;
                if ((this.z[this.i] & 1) != 0) {
                    n3 = this.c.add(this.z, this.d, this.z);
                }
                BigInt.shiftRight(this.z, n3, 1, this.z);
            }
            if (BigInt.compare(this.w, this.x) >= 0) {
                this.c.subtract(this.w, this.x, this.w);
                this.subtract(this.y, this.z, this.y);
                continue;
            }
            this.c.subtract(this.x, this.w, this.x);
            this.subtract(this.z, this.y, this.z);
        }
        if (BigInt.equals(this.w, this.c.getOne())) {
            Utils.copy(this.y, nArray2);
            return;
        }
        Utils.copy(this.z, nArray2);
    }

    public final void invert(int[] object, int[] nArray) {
        if ((this.d[this.i] & 1) == 0) {
            int n2;
            GFp gFp = this;
            int[] nArray2 = nArray;
            nArray = object;
            object = gFp;
            int n3 = GFp.getLowestSetBit(gFp.d);
            Utils.copy(((GFp)object).d, ((GFp)object).F);
            BigInt.shiftRight(((GFp)object).F, 0, n3, ((GFp)object).F);
            Object object2 = new GFp(((GFp)object).F);
            ((GFp)object2).a(nArray, ((GFp)object).E);
            int n4 = GFp.b(nArray, n3);
            int[] nArray3 = ((GFp)object).G;
            int n5 = n3;
            int[] nArray4 = ((GFp)object).F;
            int[] nArray5 = ((GFp)object).f;
            object2 = object;
            Utils.copy(nArray4, ((GFp)object2).C);
            int n6 = GFp.a(((GFp)object2).F);
            System.arraycopy(nArray5, 0, ((GFp)object2).A, ((GFp)object2).a, ((GFp)object2).a);
            BigInt bigInt = new BigInt(2 * ((GFp)object2).a);
            int n7 = n5 >> 5;
            for (n2 = 0; n2 < n7; ++n2) {
                ((GFp)object2).B[((GFp)object2).i] = n6 * ((GFp)object2).A[(((GFp)object2).a << 1) - 1];
                ((GFp)object2).c.multiply(((GFp)object2).C, ((GFp)object2).B, ((GFp)object2).D);
                bigInt.add(((GFp)object2).A, ((GFp)object2).D, ((GFp)object2).A);
                System.arraycopy(((GFp)object2).A, 0, ((GFp)object2).A, ((GFp)object2).a, ((GFp)object2).a);
                System.arraycopy(((GFp)object2).e, 0, ((GFp)object2).A, 0, ((GFp)object2).a);
            }
            n2 = n5 & 0x1F;
            if (n2 != 0) {
                ((GFp)object2).B[((GFp)object2).i] = n6 * ((GFp)object2).A[(((GFp)object2).a << 1) - 1];
                int n8 = ((GFp)object2).i;
                ((GFp)object2).B[n8] = ((GFp)object2).B[n8] & (1 << n2) - 1;
                ((GFp)object2).c.multiply(((GFp)object2).C, ((GFp)object2).B, ((GFp)object2).D);
                bigInt.add(((GFp)object2).A, ((GFp)object2).D, ((GFp)object2).A);
                BigInt.shiftRight(((GFp)object2).A, 0, n2, ((GFp)object2).A);
            }
            System.arraycopy(((GFp)object2).A, ((GFp)object2).a, nArray5, 0, ((GFp)object2).a);
            while (BigInt.compare(nArray5, nArray4) >= 0) {
                ((GFp)object2).c.subtract(nArray5, ((GFp)object2).E, nArray5);
            }
            Utils.copy(nArray5, nArray3);
            int n9 = GFp.b(((GFp)object).F, n3);
            BigInt.shiftLeft(((GFp)object).E, n3, ((GFp)object).E);
            ((GFp)object).multiply(((GFp)object).E, ((GFp)object).G, ((GFp)object).E);
            ((GFp)object).I[((GFp)object).i] = n4;
            ((GFp)object).multiply(((GFp)object).I, ((GFp)object).F, ((GFp)object).I);
            ((GFp)object).H[((GFp)object).i] = n9;
            ((GFp)object).multiply(((GFp)object).I, ((GFp)object).H, ((GFp)object).H);
            ((GFp)object).add(((GFp)object).E, ((GFp)object).H, ((GFp)object).E);
            ((GFp)object).reduce(((GFp)object).E, nArray2);
            return;
        }
        if (BigInt.equals((int[])object, this.c.getZero())) {
            throw new RuntimeException("inverting ZERO.");
        }
        if (BigInt.equals((int[])object, this.f)) {
            Utils.copy((int[])object, nArray);
            return;
        }
        Utils.copy((int[])object, this.E);
        Utils.copy(this.d, this.F);
        Utils.copy(this.c.getOne(), this.G);
        Utils.copy(this.c.getZero(), this.H);
        int n10 = 0;
        int n11 = 0;
        while (!BigInt.equals(this.F, this.c.getZero())) {
            if ((this.F[this.i] & 1) == 0) {
                BigInt.shiftRight(this.F, 0, 1, this.F);
                n11 = BigInt.shiftLeft(this.G, 1, this.G);
            } else if ((this.E[this.i] & 1) == 0) {
                BigInt.shiftRight(this.E, 0, 1, this.E);
                BigInt.shiftLeft(this.H, 1, this.H);
            } else if (BigInt.compare(this.F, this.E) >= 0) {
                this.c.subtract(this.F, this.E, this.F);
                BigInt.shiftRight(this.F, 0, 1, this.F);
                this.c.add(this.H, this.G, this.H);
                n11 = BigInt.shiftLeft(this.G, 1, this.G);
            } else {
                this.c.subtract(this.E, this.F, this.E);
                BigInt.shiftRight(this.E, 0, 1, this.E);
                this.c.add(this.H, this.G, this.G);
                BigInt.shiftLeft(this.H, 1, this.H);
            }
            ++n10;
        }
        if (n11 > 0 || BigInt.compare(this.G, this.d) >= 0) {
            this.c.subtract(this.G, this.d, this.G);
        }
        int n12 = Utils.wordLength(this.d) << 5;
        if (this.j == 2) {
            this.multiply(this.G, this.m, this.G);
            if (n10 > n12) {
                n10 = (n12 << 1) - n10;
                Utils.copy(this.c.getZero(), nArray);
                nArray[this.i - (n10 >>> 5)] = 1 << n10;
                this.multiply(this.G, nArray, nArray);
                return;
            }
            Utils.copy(this.G, nArray);
            return;
        }
        while (n10 > n12) {
            n11 = 0;
            if ((this.G[this.i] & 1) != 0) {
                n11 = this.c.add(this.G, this.d, this.G);
            }
            BigInt.shiftRight(this.G, n11, 1, this.G);
            --n10;
        }
        this.multiply(this.G, this.m, nArray);
    }

    public final boolean squareRoot(int[] nArray, int[] nArray2) {
        int[] nArray3;
        if (this.j == 2) {
            throw new RuntimeException("unsupported operation");
        }
        if (BigInt.equals(nArray, this.e) || BigInt.equals(nArray, this.f)) {
            Utils.copy(nArray, nArray2);
            return true;
        }
        if ((this.d[this.i] & 3) == 3) {
            int[] nArray4 = this.J;
            BigInt.shiftRight(this.d, 0, 2, nArray4);
            this.c.add(nArray4, this.f, nArray4);
            this.modPow(nArray, nArray4, this.K);
            this.square(this.K, this.L);
            if (BigInt.equals(this.L, nArray)) {
                Utils.copy(this.K, nArray2);
                return true;
            }
            return false;
        }
        if ((this.d[this.i] & 7) == 5) {
            int[] nArray5 = this.J;
            int[] nArray6 = this.K;
            int[] nArray7 = this.L;
            int[] nArray8 = this.M;
            this.add(nArray, nArray, nArray5);
            BigInt.shiftRight(this.d, 0, 3, nArray7);
            this.modPow(nArray5, nArray7, nArray6);
            this.square(nArray6, nArray8);
            this.multiply(nArray8, nArray5, nArray8);
            this.subtract(nArray8, this.f, nArray8);
            this.multiply(nArray8, nArray6, nArray8);
            this.multiply(nArray, nArray8, this.J);
            this.square(this.J, this.L);
            if (BigInt.equals(this.L, nArray)) {
                Utils.copy(this.J, nArray2);
                return true;
            }
            return false;
        }
        int[] nArray9 = this.J;
        int[] nArray10 = this.K;
        int[] nArray11 = this.L;
        int[] nArray12 = this.M;
        int[] nArray13 = this.N;
        int n2 = this.c.add(this.d, this.f, nArray11);
        BigInt.shiftRight(nArray11, n2, 1, nArray11);
        Utils.copy(nArray, nArray10);
        Random random = new Random();
        do {
            this.c.getRandomNumber(random, this.d, nArray9);
            this.a(nArray9, nArray10, nArray11, nArray12, nArray13);
            n2 = 0;
            if (BigInt.getBit(nArray12, 0) == 1) {
                n2 = this.c.add(nArray12, this.d, nArray12);
            }
            BigInt.shiftRight(nArray12, n2, 1, nArray12);
            this.square(nArray12, nArray9);
            if (BigInt.equals(nArray9, nArray)) {
                Utils.copy(nArray12, nArray2);
                return true;
            }
            nArray3 = this.M;
            this.c.subtract(this.d, this.f, nArray3);
        } while (BigInt.compare(nArray13, this.f) <= 0 || BigInt.compare(nArray13, nArray3) >= 0);
        return false;
    }

    private void a(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        Utils.copy(this.f, this.O);
        Utils.copy(this.O, this.P);
        Utils.copy(this.g, this.Q);
        Utils.copy(nArray, this.R);
        for (int i2 = BigInt.bitLength(nArray3) - 1; i2 >= 0; --i2) {
            this.multiply(this.O, this.P, this.O);
            if (BigInt.getBit(nArray3, i2) == 1) {
                this.multiply(this.O, nArray2, this.P);
                this.multiply(this.Q, this.R, this.Q);
                this.multiply(this.O, nArray, this.S);
                this.subtract(this.Q, this.S, this.Q);
                this.square(this.R, this.R);
                this.add(this.P, this.P, this.S);
                this.subtract(this.R, this.S, this.R);
                continue;
            }
            Utils.copy(this.O, this.P);
            this.multiply(this.Q, this.R, this.R);
            this.multiply(this.O, nArray, this.S);
            this.subtract(this.R, this.S, this.R);
            this.square(this.Q, this.Q);
            this.add(this.O, this.O, this.S);
            this.subtract(this.Q, this.S, this.Q);
        }
        Utils.copy(this.Q, nArray4);
        Utils.copy(this.O, nArray5);
    }

    private static int a(int[] nArray) {
        int n2 = nArray[nArray.length - 1];
        int n3 = n2 * (2 - n2 * n2);
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        return -n3;
    }

    static int[] a(int[] nArray, int n2) {
        GFp gFp = new GFp(nArray, 0);
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 << 1];
        int[] nArray3 = new int[n3 << 1];
        int[] nArray4 = nArray3;
        nArray3[(n3 << 1) - 1] = 1;
        int n4 = BigInt.bitLength(nArray);
        n4 = n2 * (n4 % n2 == 0 ? n4 / n2 : n4 / n2 + 1);
        BigInt.shiftLeft(nArray4, n4, nArray2);
        int[] nArray5 = new int[n3];
        gFp.reduce(nArray2, nArray5);
        return nArray5;
    }

    private void b(int[] nArray, int[] nArray2) {
        long l2;
        int n2;
        int n3 = (this.a << 1) + 1;
        Utils.copy(nArray, this.v);
        int n4 = this.a - this.h;
        block0: for (n2 = 0; n2 < n4; ++n2) {
            int n5 = n3 - 1 - n2;
            l2 = (long)(this.v[n5] * this.l) & 0xFFFFFFFFL;
            long l3 = 0L;
            int n6 = this.i;
            while (n6 >= this.h) {
                l3 = ((long)this.v[n5] & 0xFFFFFFFFL) + ((long)this.d[n6] & 0xFFFFFFFFL) * l2 + (l3 >>> 32);
                this.v[n5] = (int)l3;
                --n6;
                --n5;
            }
            l3 = ((long)this.v[n5] & 0xFFFFFFFFL) + (l3 >>> 32);
            this.v[n5] = (int)l3;
            if (l3 >>> 32 <= 0L) continue;
            for (n6 = n5 - 1; n6 >= 2 * this.h; --n6) {
                int n7 = n6;
                this.v[n7] = this.v[n7] + 1;
                if (this.v[n6] != 0) continue block0;
            }
        }
        while (true) {
            if (this.v[2 * this.h] == 0) {
                boolean bl = true;
                for (n2 = 1 + this.h; n2 < this.a + 1; ++n2) {
                    if (this.v[n2 + this.h] == this.d[n2 - 1]) continue;
                    if ((this.v[n2 + this.h] ^ Integer.MIN_VALUE) >= (this.d[n2 - 1] ^ Integer.MIN_VALUE)) break;
                    bl = false;
                }
                if (!bl) break;
            }
            l2 = 0L;
            for (n2 = this.a; n2 > this.h; --n2) {
                l2 = ((long)this.v[n2 + this.h] & 0xFFFFFFFFL) - ((long)this.d[n2 - 1] & 0xFFFFFFFFL) + (l2 >> 32);
                this.v[n2 + this.h] = (int)l2;
            }
            int n8 = 2 * this.h;
            this.v[n8] = this.v[n8] + (int)(l2 >> 32);
        }
        System.arraycopy(this.v, 1 + this.h, nArray2, 0, this.a);
    }
}

