/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.GOST3410ECParams2012;
import com.bifit.security.core.Utils;
import com.bifit.security.core.l;
import com.bifit.security.core.m;
import com.bifit.security.core.o;

public final class GOST3410ECPublicKey2012 {
    private final m a;
    private final GOST3410ECParams2012 b;

    public GOST3410ECPublicKey2012(GOST3410ECParams2012 gOST3410ECParams2012, byte[] byArray) {
        int n2 = gOST3410ECParams2012.f();
        GFp gFp = new GFp(gOST3410ECParams2012.b());
        if (byArray.length > 65 || byArray[0] != 0 && byArray[0] != 1) {
            throw new IllegalArgumentException("invalid compressed public key specified");
        }
        Object[] objectArray = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, objectArray, 0, byArray.length - 1);
        int[] nArray = Utils.fromByteArray(objectArray, n2);
        objectArray = nArray;
        if (BigInt.bitLength(nArray) == 0 || BigInt.compare(objectArray, gFp.getOrder()) >= 0) {
            throw new IllegalArgumentException("invalid compressed public key specified");
        }
        int[] nArray2 = new int[n2];
        int[] nArray3 = gOST3410ECParams2012.c();
        int[] nArray4 = gOST3410ECParams2012.d();
        gFp.square((int[])objectArray, nArray2);
        gFp.add(nArray2, nArray3, nArray2);
        gFp.multiply((int[])objectArray, nArray2, nArray2);
        gFp.add(nArray2, nArray4, nArray2);
        if (!gFp.squareRoot(nArray2, nArray2)) {
            throw new IllegalArgumentException("invalid compressed public key specified");
        }
        if (BigInt.getBit(nArray2, 0) != (byArray[0] & 1)) {
            gFp.subtract(gFp.getZero(), nArray2, nArray2);
        }
        this.a = new m((int[])objectArray, nArray2);
        this.b = gOST3410ECParams2012;
    }

    public GOST3410ECPublicKey2012(GOST3410ECParams2012 object, byte[] byArray, byte[] byArray2) {
        int n2 = ((l)object).f();
        GFp gFp = new GFp(((l)object).b());
        int[] nArray = Utils.fromByteArray(byArray, n2);
        int[] nArray2 = Utils.fromByteArray(byArray2, n2);
        this.b = object;
        this.a = new m(nArray, nArray2);
        if (BigInt.bitLength(nArray) == 0 || byArray.length > 64 || BigInt.compare(nArray, gFp.getOrder()) >= 0) {
            throw new IllegalArgumentException("condition 0 < Qx < p is not met");
        }
        if (BigInt.bitLength(nArray2) == 0 || byArray2.length > 64 || BigInt.compare(nArray2, gFp.getOrder()) >= 0) {
            throw new IllegalArgumentException("condition 0 < Qy < p is not met");
        }
        if (!((o)(object = new o((GOST3410ECParams2012)object))).a(this.a)) {
            throw new IllegalArgumentException("public key is not a point on the elliptic curve");
        }
    }

    GOST3410ECPublicKey2012(GOST3410ECParams2012 gOST3410ECParams2012, m m2) {
        this.b = gOST3410ECParams2012;
        this.a = m2;
    }

    public final byte[] getQx() {
        return Utils.toByteArray(this.a.a(), this.b.getNbyte());
    }

    public final byte[] getQy() {
        return Utils.toByteArray(this.a.b(), this.b.getNbyte());
    }

    public final byte[] getQc() {
        byte[] byArray = Utils.toByteArray(this.a.a(), this.b.getNbyte());
        byte[] byArray2 = new byte[this.b.getNbyte() + 1];
        byte[] byArray3 = byArray2;
        byArray2[0] = (byte)BigInt.getBit(this.a.b(), 0);
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        return byArray3;
    }

    public final GOST3410ECParams2012 getParams() {
        return this.b;
    }

    public final synchronized void setOptLevel(int n2) {
        int n3 = Utils.getWidthByOptLevel(n2);
        if (n3 != 0) {
            o o2 = new o(this.b);
            m[] mArray = o2.a(this.a, Utils.getWidthByOptLevel(n2));
            this.a.a(mArray);
            return;
        }
        this.a.a(null);
    }

    public final synchronized void setOptData(byte[] objectArray) {
        if (objectArray != null) {
            o o2 = new o(this.b);
            objectArray = o2.a((byte[])objectArray);
            m m2 = new m(objectArray[1].a(), objectArray[1].b());
            o2.b().fromInternalDomain(m2.a(), m2.a());
            o2.b().fromInternalDomain(m2.b(), m2.b());
            if (!this.a.equals(m2)) {
                throw new IllegalArgumentException("precomputations are not for current public key");
            }
            this.a.a((m[])objectArray);
            return;
        }
        this.a.a(null);
    }

    public final synchronized byte[] getOptData() {
        m[] mArray = this.a.d();
        if (mArray != null) {
            o o2 = new o(this.b);
            return o2.a(mArray);
        }
        return null;
    }

    final m a() {
        return this.a;
    }
}

