/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.SecurePRNG;
import com.bifit.security.core.Utils;
import java.util.Hashtable;

public final class GOST3410Params {
    public static final GOST3410Params DEFAULT_1 = new GOST3410Params(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -293506386, -1986633585, -1231857224, -1632097687, -2059071262, -1753592477, -1130941908, -438553722, -368438605, 1139349775, 588739897, -2074592904, 1806746437, -781871250, -233218359, -1312589341}, new int[]{-1735303554, -937009441, -844947832, -230159907, -1335575097, 677238029, 1921642668, 1867111725}, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1634335979, 13137738, -2037021996, -1344397017, -1347607240, -1263130870, 1870432311, -1257418510, 108353924, -1533128557, 81152190, 716548785, -1900139308, 1791219785, 1528048294, -836509156});
    public static final GOST3410Params DEFAULT_2 = new GOST3410Params(new int[]{-1416677485, -2091494754, -2028661567, -192127812, -411357361, -912103622, -1027513027, -1466417008, -1062440073, 1364828779, -279342947, 1285047907, 309387622, 1403396934, 1760732458, 27499410, 345040532, -1057946443, -1926359913, 265073784, -108199447, 1973486219, -1791567598, -565037358, -584072298, -1217309863, 1296136312, 241112823, 407313953, 298372708, -1479024234, -94956499}, new int[]{-1128256352, -833681581, -334098338, -439013206, 13868849, 1904487090, -1019960725, 1599565327}, new int[]{947109860, -1577120699, -1173174920, 1549975411, -673486122, 522970976, -1140137466, 2107904712, -567360074, 728787770, -875268293, -557393445, 445701427, -1960394912, -1295726093, -424254164, 1836170796, -527454909, 1705048122, 672052610, -1465946651, -887672049, -905256497, -1326494692, 1003821641, 1502653041, 970458257, 438500321, 1934833718, -870992660, 1169822171, 54134788});
    public static final GOST3410Params DEFAULT_3 = new GOST3410Params(new int[]{-1260232965, 26098827, -2024776150, 1733639262, -598293871, 1266569097, -767622160, 863495946, 688081053, -703694783, -1925348066, -615311420, -2028060496, 1109967799, -1876335676, -1210557102, -1180006158, -1344541912, -628594218, -544970211, -1735242094, 1432468841, 806067677, 97666997, -1842506116, -1157470440, -2117763824, -437292333, -421866462, 1036528289, -137352890, 1369735391}, new int[]{-1759235420, 924289840, -1114236581, 2000128427, 805246297, 1259826641, 1974874710, -296029489}, new int[]{-1881970895, 594957499, -467706081, -2074876132, -1542127678, 740677909, 815684910, 1654825580, 1897001980, 2035715503, -1607990225, -509269500, -1988076531, -375282583, -935016502, -1142005156, 813205644, 495316648, -2081313445, -991529106, -1910896816, -1859258801, 2039833753, -236879289, 1527472354, 1663753432, -812324411, 1339159473, 165158656, -1087719221, -2044010627, 1085879962});
    public static final GOST3410Params DEFAULT_4 = new GOST3410Params(new int[]{-963174459, 1965339404, -1877424666, 568202569, -1758034609, 1453783214, -430278080, 1177727420, -264986628, -1345648112, 829921055, -1050596644, -611545911, 952566309, -922938705, -266658554, 1309333245, -424963751, 376224242, -65593966, -255034518, 1798100986, 875219938, -919512510, -713641492, -831018653, 360660235, -647328080, -1326231510, -768077797, 85025588, -236603477}, new int[]{-1331862708, 277454039, -725375131, 1946411096, 280001633, -1500988750, -1015068834, 814417415}, new int[]{1025946727, -649445380, -1653489779, -1198309244, 326264051, -1024857322, -593357640, -1132689628, -2060228796, -1823485201, 1497627117, 192174992, -1438725929, 215781736, 611890788, -1562248965, 1456403095, 804159195, 139130694, 1100711247, -1392325570, 910622510, 437837131, -348371721, -227256952, 43403623, 1162267793, -2017327109, -1892881176, -500613272, 962348804, -1358644555});
    public static final GOST3410Params DEFAULT_5 = new GOST3410Params(new int[]{-1651972393, -30207043, 779377788, -584402450, 1257490569, -1635484185, 1244887102, -1500790011, -2001068173, -1939165302, -1286581473, 408208259, 2093205600, -2628895, 113505851, 1032473603, 1290221890, -1497115259, -1248211095, 1591190468, -1455740012, 2071025595, 438043706, -1273051050, 1818314217, 950407568, 1843450670, 1445237846, -1652647526, 232414343, -1679977986, 307098089}, new int[]{-86173318, -1122393676, 1698622711, -324741470, 723484553, 996417424, 373423029, 1429557167}, new int[]{1950870897, 1446053273, 118166112, -1723357752, -928488868, -238082773, 1081815839, -1814677027, -776324826, 1457441433, 768619829, 1126801897, 1517171414, -193428775, 1622733066, -889226899, 332240401, -128722250, -765315965, -462976912, -2070703238, 438912037, -1733377312, 1948262998, 876674716, 410259150, 1734716421, -84925274, 1258450558, 1082671233, -1634324866, 1598036707});
    public static final GOST3410Params DEFAULT_6 = new GOST3410Params(new int[]{-2131688749, 722456935, -798375302, 813357778, -999945959, 81504853, -709309328, 653457313, -1852077812, -1236089842, 89005715, 108223299, -676169235, -544144896, 484041128, 838765078, 1055754667, 131017406, -2109559651, -304234600, -701702703, -363897067, -744215962, 2008928915, -1304272704, -226750691, 362055188, -714623377, -1459438943, 443133499, -827475069, -476460619}, new int[]{-252361532, 413844020, -159125453, 1360750018, 374449671, -1948635799, -1147178200, 1733304649}, new int[]{1808534351, -1380743012, 503754194, 1019255690, -1225990433, 1945126450, 1499391013, 382639, 1599790660, -887216410, 641492771, 1204789871, -1634495640, 510358935, 863522014, 1572706836, -1550620193, -643848100, -1060044223, -1006566589, -213216967, 980446449, 645385210, 525831531, 1828448417, 606928073, 1262183738, 1198396510, 945996172, -1006708699, 2097084236, -618636303});
    public static final GOST3410Params DEFAULT_7 = new GOST3410Params(new int[]{-902086866, -291515293, 399807893, -1444458098, 1818482932, -347266351, 220770059, -2009468807, -131555744, 990073607, -2068202662, 511083934, 1213253232, -944301043, -129195040, -691963906, -1619482152, 1127362728, -2083683678, -1296709725, 812220455, -2056204873, -1678765964, -1499687389, 881337520, -986213931, 1013610698, -1231151877, 674661905, -1550322417, 1411258075, 881704543}, new int[]{-890972065, -2134816912, 1259119758, -2047147863, 91923628, -1002018591, 2132383447, 354848985}, new int[]{-1104685486, -219028679, -629980655, -1201994066, 1306670762, -1883313345, 450676012, -734506121, 2122533482, 1367423079, -1970611245, -1520668505, -357451142, 119100550, 2007692518, 167752831, 1805483589, -1328517757, -676477645, 279697495, -2082000513, 2126983784, -1230389107, 638289368, 1213634250, 968981271, -263925280, 1346932790, -1412202043, -423656774, 891951871, 325452207});
    public static final GOST3410Params DEFAULT_8 = new GOST3410Params(new int[]{-1836655654, -1846751293, 101360985, -2095521114, 972405392, -1530239647, 1471309631, -1315844859, -1980889612, -823018221, 1350830119, 341361416, 1372486222, -181111765, -82709388, 1016035451, 286866339, 79750844, -1571356225, -2001789767, -1191360751, -660633373, 725080403, 374610929, -438586216, -1690439370, 1505266703, -1750875896, 2074029395, 399857628, -726677808, -1487609223}, new int[]{-916002381, -1195913768, 804321338, -126863677, -1891490930, -989165716, -745479107, 1739981119}, new int[]{2124165270, 1735348707, -1292269492, -257154730, 2006226676, 283134414, -672842357, 2069575275, 442501349, 426116517, 1586086681, 229373963, -1626250295, 2046611843, 685434345, 76026291, 1880128439, 1902084617, 465165838, 871247853, 1649755983, -2023097115, -352653583, -883281184, -708394256, -66374585, 120145909, -1262254234, 1771283251, -66693490, 1397413229, 590927657});
    public static final GOST3410Params DEFAULT_9 = new GOST3410Params(new int[]{-1315699862, -837545059, 920011413, -1368633092, 1266509272, -1287622381, 1724552179, -2090518264, -295470108, 671423878, 1629909165, 2067803145, -1205798281, -640013880, 286950550, -630446566, 1408050478, 1300916642, 58123949, -616833837, 829725257, 437799823, -630356797, 485515153, 431353141, 611230806, 763728523, -1592563059, 240811612, 1984669840, 539599155, 1818434077}, new int[]{-1777204105, -552650602, 1653501770, -1999094637, 541860111, -228410165, 2108572931, 1427264089}, new int[]{1058543365, 732591512, -29470897, -976882154, -517812231, -338125064, 499633803, -177420725, 1129868416, -238750355, -713977891, 1982860259, 913850969, -903501090, 1514684260, -1070980913, 1242626497, -1983630370, -30289309, -423004602, 1621570028, -890456244, -2105987017, 837341033, 542885694, 1517338105, 1046197889, -625676615, -952907093, 795294791, 1578027666, 489257006});
    private final int[] a;
    private final int[] b;
    private final int[] c;
    private int[][] d = null;
    private static Hashtable e = new Hashtable<GOST3410Params, GOST3410Params>();

    private GOST3410Params(int[] nArray, int[] nArray2, int[] nArray3) {
        this.a = Utils.copy(nArray);
        this.c = Utils.copy(nArray3);
        this.b = new int[32];
        System.arraycopy(nArray2, 0, this.b, 32 - nArray2.length, nArray2.length);
    }

    private GOST3410Params(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n2 = Utils.byteLength(byArray);
        if (n2 != 64 && n2 != 128) {
            throw new IllegalArgumentException("condition 2^509 < p < 2^512 || 2^1020 < p < 2^1024 is not met");
        }
        if (Utils.byteLength(byArray3) > n2) {
            throw new IllegalArgumentException("condition 1 < \u0430 < \u0440-1 is not met");
        }
        if (Utils.byteLength(byArray2) != 32) {
            throw new IllegalArgumentException("condition 2^254 < q < 2^256 is not met");
        }
        this.a = Utils.fromByteArray(byArray, 32);
        this.c = Utils.fromByteArray(byArray3, 32);
        this.b = Utils.fromByteArray(byArray2, 32);
    }

    public static GOST3410Params getParams(byte[] object, byte[] object2, byte[] object3) {
        object = new GOST3410Params((byte[])object, (byte[])object2, (byte[])object3);
        Object v2 = e.get(object);
        object2 = v2;
        if (v2 == null) {
            object2 = object;
            GFp gFp = new GFp(object2.a);
            object3 = gFp;
            BigInt bigInt = gFp.getBigInt();
            int n2 = BigInt.bitLength(object2.a);
            if (n2 <= 509 || n2 > 1024 || n2 > 512 && n2 <= 1020) {
                throw new IllegalArgumentException("condition 2^509 < p < 2^512 || 2^1020 < p < 2^1024 is not met");
            }
            if (!BigInt.isPrime(object2.a)) {
                throw new IllegalArgumentException("parameter p is not prime");
            }
            int[] nArray = new int[32];
            bigInt.subtract(object2.a, bigInt.getOne(), nArray);
            if (BigInt.bitLength(object2.c) <= 1 || BigInt.compare(object2.c, nArray) >= 0) {
                throw new IllegalArgumentException("condition 1 < a < p - 1 is not met");
            }
            int n3 = BigInt.bitLength(object2.b);
            if (n3 != 255 && n3 != 256) {
                throw new IllegalArgumentException("condition 2^254 < q < 2^256 is not met");
            }
            if (!BigInt.isPrime(object2.b)) {
                throw new IllegalArgumentException("parameter q is not prime");
            }
            int[] nArray2 = new int[32];
            int[] nArray3 = new int[64];
            Utils.copy(nArray, nArray3);
            bigInt.divide(nArray3, object2.b, null, nArray2);
            if (!BigInt.equals(nArray2, bigInt.getZero())) {
                throw new IllegalArgumentException("parameter q doesn't divide p - 1");
            }
            nArray = new int[32];
            ((GFp)object3).modPow(object2.c, object2.b, nArray);
            if (!BigInt.equals(nArray, bigInt.getOne())) {
                throw new IllegalArgumentException("condition a^q (mod p) = 1 is not met");
            }
            e.put(object, object);
            return object;
        }
        return (GOST3410Params)object2;
    }

    public static GOST3410Params generateParams(SecurePRNG object, int n2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        byte[] byArray = new byte[]{0};
        int[] nArray5 = new int[32];
        int[] nArray6 = new int[32];
        int[] nArray7 = new int[8];
        int[] nArray8 = new int[32];
        int[] nArray9 = new int[32];
        n2 = n2 == 0 ? 16 : 32;
        ((SecurePRNG)object).nextBytes(byArray);
        int n3 = 1021 + (byArray[0] & 3);
        int n4 = 255 + (byArray[0] >> 2 & 1);
        do {
            ((SecurePRNG)object).a(nArray3);
            if (16 != n2) continue;
            nArray3[0] = nArray3[0] & 0xFFFF;
        } while (nArray3[0] == 0);
        do {
            ((SecurePRNG)object).a(nArray4);
            if (16 != n2) continue;
            nArray4[0] = nArray4[0] & 0xFFFF;
        } while (nArray4[0] == 0);
        Object object2 = nArray7;
        Object object3 = nArray5;
        int n5 = n2;
        int n6 = nArray4[0];
        int n7 = nArray3[0];
        int n8 = n5 == 16 ? 19381 : 97781173;
        int n9 = n5 == 16 ? 64 : 32;
        int[] nArray10 = new int[32];
        int[] nArray11 = new int[64];
        int[] nArray12 = new int[32];
        int[] nArray13 = new int[32];
        int[] nArray14 = new int[32];
        int[] nArray15 = new int[32];
        int[] nArray16 = new int[32];
        nArray15[31] = 1;
        nArray16[31] = 2;
        int[] nArray17 = new int[64];
        int[] nArray18 = new int[64];
        int[] nArray19 = new int[32];
        int[] nArray20 = new int[32];
        int[] nArray21 = new int[32];
        BigInt bigInt = new BigInt(16);
        BigInt bigInt2 = new BigInt(32);
        int[] nArray22 = new int[32];
        int[] nArray23 = new int[32];
        n2 = 1;
        block11: while (n2 != 11) {
            switch (n2) {
                case 1: {
                    int[] nArray24 = new int[]{n7};
                    GOST3410Params.a(nArray24, n6, n4, n5, nArray12, null);
                    n7 = nArray24[0];
                }
                case 2: {
                    int[] nArray25 = new int[]{n7};
                    GOST3410Params.a(nArray25, n6, 512, n5, nArray14, null);
                    n7 = nArray25[0];
                    nArray25 = new int[16];
                    int[] nArray26 = new int[16];
                    System.arraycopy(nArray12, 16, nArray25, 0, 16);
                    System.arraycopy(nArray14, 16, nArray26, 0, 16);
                    bigInt.multiply(nArray25, nArray26, nArray13);
                }
                case 3: 
                case 4: 
                case 5: {
                    int n10 = 32 / n5;
                    for (n2 = 0; n2 < nArray11.length; ++n2) {
                        nArray11[n2] = 0;
                    }
                    for (n2 = 0; n2 < n9; ++n2) {
                        int n11 = 63 - n2 / n10;
                        nArray11[n11] = nArray11[n11] | (int)((long)n7 << n2 % n10 * n5);
                        n7 = (int)((long)(n8 * n7 + n6) & (1L << n5) - 1L);
                    }
                }
                case 6: 
                case 7: {
                    BigInt.shiftLeft(nArray15, n3 - 1, nArray10);
                    int n10 = bigInt2.add(nArray10, nArray13, nArray10);
                    n10 += bigInt2.subtract(nArray10, nArray15, nArray10);
                    for (n2 = 0; n2 < nArray17.length; ++n2) {
                        nArray17[n2] = 0;
                    }
                    nArray17[31] = n10;
                    System.arraycopy(nArray10, 0, nArray17, 32, 32);
                    bigInt2.divide(nArray17, nArray13, nArray17, null);
                    System.arraycopy(nArray17, 32, nArray10, 0, 32);
                    bigInt2.divide(nArray11, nArray13, nArray11, null);
                    BigInt.shiftRight(nArray11, 0, 1024 - n3 + 1, nArray11);
                    int[] nArray27 = new int[32];
                    System.arraycopy(nArray11, 32, nArray27, 0, 32);
                    bigInt2.add(nArray10, nArray27, nArray10);
                    if ((nArray10[31] & 1) == 1) {
                        bigInt2.add(nArray10, nArray15, nArray10);
                    }
                }
                case 8: {
                    bigInt2.multiply(nArray13, nArray10, nArray18);
                    System.arraycopy(nArray18, 32, nArray22, 0, 32);
                    if (bigInt2.add(nArray22, nArray15, nArray22) == 0) {
                        System.arraycopy(nArray22, 0, nArray18, 32, 32);
                    } else {
                        bigInt2.add(nArray18, nArray15, nArray18);
                    }
                }
                case 9: {
                    if (BigInt.bitLength(nArray18) > n3) {
                        n2 = 3;
                        continue block11;
                    }
                    n2 = 10;
                    continue block11;
                }
                case 10: {
                    System.arraycopy(nArray18, 32, nArray23, 0, 32);
                    GFp gFp = new GFp(nArray23);
                    System.arraycopy(nArray18, 32, nArray19, 0, 32);
                    bigInt2.subtract(nArray19, nArray15, nArray19);
                    gFp.modPow(nArray16, nArray19, nArray20);
                    gFp.modPow(nArray16, nArray10, nArray21);
                    if (!BigInt.equals(nArray20, nArray15) || BigInt.equals(nArray21, nArray15)) {
                        bigInt2.add(nArray10, nArray16, nArray10);
                        n2 = 8;
                        continue block11;
                    }
                    System.arraycopy(nArray18, 32, object3, 0, 32);
                    System.arraycopy(nArray12, nArray12.length - 8, object2, 0, 8);
                    n2 = 11;
                    continue block11;
                }
            }
            throw new IllegalStateException("Incorrect 'line' variable. How did this happened?");
        }
        System.arraycopy(nArray5, 0, nArray6, 0, 32);
        BigInt.add(nArray6, -2);
        BigInt bigInt3 = new BigInt(32);
        do {
            bigInt3.getRandomNumber((SecurePRNG)object, nArray6, nArray8);
            BigInt.add(nArray8, 1);
            nArray2 = nArray9;
            int[] nArray28 = nArray8;
            int[] nArray29 = nArray7;
            int[] nArray30 = nArray5;
            GFp gFp = new GFp(nArray30, 0);
            object3 = new BigInt(32);
            object2 = new BigInt(16);
            int[] nArray31 = new int[32];
            int[] nArray32 = new int[16];
            int[] nArray33 = new int[32];
            nArray = nArray33;
            nArray33[31] = 1;
            System.arraycopy(nArray29, 0, nArray32, nArray32.length - nArray29.length, nArray29.length);
            ((BigInt)object3).subtract(nArray30, nArray, nArray31);
            ((BigInt)object2).divide(nArray31, nArray32, nArray31, null);
            gFp.modPow(nArray28, nArray31, nArray2);
        } while (BigInt.equals(nArray2, nArray));
        object = new GOST3410Params(nArray5, nArray7, nArray9);
        bigInt3 = e.get(object);
        if (bigInt3 == null) {
            e.put(object, object);
        } else {
            object = (GOST3410Params)((Object)bigInt3);
        }
        return object;
    }

    public final byte[] getP() {
        return Utils.toByteArray(this.a, 4 * Utils.wordLength(this.a));
    }

    public final byte[] getQ() {
        return Utils.toByteArray(this.b, 32);
    }

    public final byte[] getA() {
        return Utils.toByteArray(this.c, 4 * Utils.wordLength(this.a));
    }

    final int[] a() {
        return this.a;
    }

    final int[] b() {
        return this.b;
    }

    final int[] c() {
        return this.c;
    }

    final synchronized int[][] d() {
        return this.d;
    }

    public final synchronized void setOptLevel(int n2) {
        if ((n2 = Utils.getWidthByOptLevel(n2)) != 0) {
            GFp gFp = new GFp(this.a, 2);
            int[] nArray = new int[32];
            gFp.toInternalDomain(this.c, nArray);
            this.d = gFp.getCombPrecomp(nArray, n2);
            return;
        }
        this.d = null;
    }

    public final synchronized void setOptData(byte[] object) {
        if (object != null) {
            GFp gFp = new GFp(this.a, 2);
            int[] nArray = new int[32];
            object = gFp.importPrecomp((byte[])object);
            gFp.toInternalDomain(this.c, nArray);
            if (!BigInt.equals(nArray, (int[])object[1])) {
                throw new IllegalArgumentException("precomputations are not for current GF(p) element a");
            }
            this.d = (int[][])object;
            return;
        }
        this.d = null;
    }

    public final synchronized byte[] getOptData() {
        if (this.d != null) {
            return GFp.exportPrecomp(this.a, this.d);
        }
        return null;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GOST3410Params)) {
            return false;
        }
        object = (GOST3410Params)object;
        if (!BigInt.equals(this.a, ((GOST3410Params)object).a)) {
            return false;
        }
        if (!BigInt.equals(this.b, ((GOST3410Params)object).b)) {
            return false;
        }
        return BigInt.equals(this.c, ((GOST3410Params)object).c);
    }

    public final int hashCode() {
        int n2 = BigInt.hashCode(this.a);
        n2 = n2 * 31 + BigInt.hashCode(this.b);
        n2 = n2 * 31 + BigInt.hashCode(this.c);
        return n2;
    }

    private static void a(int[] nArray, int n2, int n3, int n4, int[] nArray2, int[] nArray3) {
        int[] nArray4 = new int[32];
        nArray3 = nArray4;
        nArray4[31] = 1;
        int[] nArray5 = new int[32];
        int[] nArray6 = nArray5;
        nArray5[31] = 2;
        BigInt bigInt = new BigInt(32);
        int n5 = 0;
        int[] nArray7 = new int[7];
        int[] nArray8 = new int[64];
        int[] nArray9 = new int[32];
        int[] nArray10 = new int[32];
        int[] nArray11 = new int[64];
        int[] nArray12 = new int[32];
        int[] nArray13 = new int[64];
        int n6 = 0;
        int[] nArray14 = new int[32];
        int[] nArray15 = new int[32];
        int[] nArray16 = new int[32];
        long l2 = n4 == 16 ? 19381L : 97781173L;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        block13: while (n8 <= 14) {
            switch (n8) {
                case 1: {
                    n5 = nArray[0];
                }
                case 2: {
                    nArray7[0] = n3;
                    n7 = 0;
                    while (nArray7[n7] > n4) {
                        nArray7[n7 + 1] = nArray7[n7] >> 1;
                        ++n7;
                    }
                }
                case 3: {
                    BigInt.shiftLeft(nArray3, nArray7[n7] - 1, nArray9);
                    nArray9[31] = nArray9[31] + 1;
                    while (!BigInt.isPrime(nArray9)) {
                        bigInt.add(nArray6, nArray9, nArray9);
                    }
                    System.arraycopy(nArray9, 0, nArray8, 32, 32);
                }
                case 4: {
                    n9 = n7 - 1;
                }
                case 5: {
                    System.arraycopy(nArray8, 32, nArray9, 0, 32);
                    n6 = (nArray7[n9] + (n4 - 1)) / n4;
                }
                case 6: 
                case 7: 
                case 8: {
                    n8 = 32 / n4;
                    for (n7 = nArray11.length - 1; n7 >= 0; --n7) {
                        nArray11[n7] = 0;
                    }
                    for (n7 = 0; n7 < n6; ++n7) {
                        int n10 = 63 - n7 / n8;
                        nArray11[n10] = nArray11[n10] | n5 << n7 % n8 * n4;
                        n5 = (int)(l2 * (long)n5 + (long)n2 & (1L << n4) - 1L);
                    }
                }
                case 9: {
                    BigInt.shiftLeft(nArray3, nArray7[n9] - 1, nArray12);
                    n8 = bigInt.add(nArray12, nArray9, nArray12);
                    n8 += bigInt.subtract(nArray12, nArray3, nArray12);
                    for (n7 = 0; n7 < 31; ++n7) {
                        nArray13[n7] = 0;
                    }
                    nArray13[31] = n8;
                    System.arraycopy(nArray12, 0, nArray13, 32, 32);
                    bigInt.divide(nArray13, nArray9, nArray13, null);
                    System.arraycopy(nArray13, 32, nArray12, 0, 32);
                    bigInt.divide(nArray11, nArray9, nArray11, null);
                    BigInt.shiftRight(nArray11, 0, n4 * n6 - (nArray7[n9] - 1), nArray11);
                    System.arraycopy(nArray11, 32, nArray14, 0, 32);
                    bigInt.add(nArray12, nArray14, nArray12);
                    if ((nArray12[31] & 1) == 1) {
                        bigInt.add(nArray12, nArray3, nArray12);
                    }
                }
                case 10: 
                case 11: {
                    bigInt.multiply(nArray9, nArray12, nArray8);
                    long l3 = 1L;
                    n7 = 63;
                    while (l3 == 1L) {
                        nArray8[n7] = (int)(l3 += (long)nArray8[n7] & 0xFFFFFFFFL);
                        l3 >>>= 32;
                        --n7;
                    }
                }
                case 12: {
                    if (BigInt.bitLength(nArray8) > nArray7[n9]) {
                        n8 = 6;
                        continue block13;
                    }
                    System.arraycopy(nArray8, 32, nArray14, 0, 32);
                }
                case 13: {
                    GFp gFp = new GFp(nArray14, 0);
                    System.arraycopy(nArray8, 32, nArray10, 0, 32);
                    bigInt.subtract(nArray10, nArray3, nArray10);
                    gFp.modPow(nArray6, nArray10, nArray15);
                    gFp.modPow(nArray6, nArray12, nArray16);
                    if (BigInt.equals(nArray15, nArray3) && !BigInt.equals(nArray16, nArray3)) {
                        --n9;
                    } else {
                        bigInt.add(nArray12, nArray6, nArray12);
                        n8 = 11;
                        continue block13;
                    }
                }
                case 14: {
                    if (n9 >= 0) {
                        n8 = 5;
                        continue block13;
                    }
                    n8 = 15;
                    continue block13;
                }
            }
            throw new IllegalStateException("Incorrect 'step' variable. How did this happened?");
        }
        nArray[0] = n5;
        if (nArray2 != null) {
            System.arraycopy(nArray8, 32, nArray2, 0, 32);
        }
    }

    static {
        e.put(DEFAULT_1, DEFAULT_1);
        e.put(DEFAULT_2, DEFAULT_2);
        e.put(DEFAULT_3, DEFAULT_3);
        e.put(DEFAULT_4, DEFAULT_4);
        e.put(DEFAULT_5, DEFAULT_5);
        e.put(DEFAULT_6, DEFAULT_6);
        e.put(DEFAULT_7, DEFAULT_7);
        e.put(DEFAULT_8, DEFAULT_8);
        e.put(DEFAULT_9, DEFAULT_9);
    }
}

