/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import java.math.BigInteger;
import java.security.SecureRandom;

public final class LongIntUtils {
    private static final BigInteger a = BigInteger.valueOf(0L);

    public static int bitLength(long[] lArray) {
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lArray[i2] == 0L) continue;
            return (lArray.length - i2 - 1 << 6) + LongIntUtils.bitLength(lArray[i2]);
        }
        return 0;
    }

    public static int bitLength(long l2) {
        if (l2 < 0x80000000L) {
            if (l2 < 32768L) {
                if (l2 < 128L) {
                    if (l2 < 8L) {
                        if (l2 < 2L) {
                            if (l2 < 1L) {
                                if (l2 < 0L) {
                                    return 64;
                                }
                                return 0;
                            }
                            return 1;
                        }
                        if (l2 < 4L) {
                            return 2;
                        }
                        return 3;
                    }
                    if (l2 < 32L) {
                        if (l2 < 16L) {
                            return 4;
                        }
                        return 5;
                    }
                    if (l2 < 64L) {
                        return 6;
                    }
                    return 7;
                }
                if (l2 < 2048L) {
                    if (l2 < 512L) {
                        if (l2 < 256L) {
                            return 8;
                        }
                        return 9;
                    }
                    if (l2 < 1024L) {
                        return 10;
                    }
                    return 11;
                }
                if (l2 < 8192L) {
                    if (l2 < 4096L) {
                        return 12;
                    }
                    return 13;
                }
                if (l2 < 16384L) {
                    return 14;
                }
                return 15;
            }
            if (l2 < 0x800000L) {
                if (l2 < 524288L) {
                    if (l2 < 131072L) {
                        if (l2 < 65536L) {
                            return 16;
                        }
                        return 17;
                    }
                    if (l2 < 262144L) {
                        return 18;
                    }
                    return 19;
                }
                if (l2 < 0x200000L) {
                    if (l2 < 0x100000L) {
                        return 20;
                    }
                    return 21;
                }
                if (l2 < 0x400000L) {
                    return 22;
                }
                return 23;
            }
            if (l2 < 0x8000000L) {
                if (l2 < 0x2000000L) {
                    if (l2 < 0x1000000L) {
                        return 24;
                    }
                    return 25;
                }
                if (l2 < 0x4000000L) {
                    return 26;
                }
                return 27;
            }
            if (l2 < 0x20000000L) {
                if (l2 < 0x10000000L) {
                    return 28;
                }
                return 29;
            }
            if (l2 < 0x40000000L) {
                return 30;
            }
            return 31;
        }
        if (l2 < 0x800000000000L) {
            if (l2 < 0x8000000000L) {
                if (l2 < 0x800000000L) {
                    if (l2 < 0x200000000L) {
                        if (l2 < 0x100000000L) {
                            return 32;
                        }
                        return 33;
                    }
                    if (l2 < 0x400000000L) {
                        return 34;
                    }
                    return 35;
                }
                if (l2 < 0x2000000000L) {
                    if (l2 < 0x1000000000L) {
                        return 36;
                    }
                    return 37;
                }
                if (l2 < 0x4000000000L) {
                    return 38;
                }
                return 39;
            }
            if (l2 < 0x80000000000L) {
                if (l2 < 0x20000000000L) {
                    if (l2 < 0x10000000000L) {
                        return 40;
                    }
                    return 41;
                }
                if (l2 < 0x40000000000L) {
                    return 42;
                }
                return 43;
            }
            if (l2 < 0x200000000000L) {
                if (l2 < 0x100000000000L) {
                    return 44;
                }
                return 45;
            }
            if (l2 < 0x400000000000L) {
                return 46;
            }
            return 47;
        }
        if (l2 < 0x80000000000000L) {
            if (l2 < 0x8000000000000L) {
                if (l2 < 0x2000000000000L) {
                    if (l2 < 0x1000000000000L) {
                        return 48;
                    }
                    return 49;
                }
                if (l2 < 0x4000000000000L) {
                    return 50;
                }
                return 51;
            }
            if (l2 < 0x20000000000000L) {
                if (l2 < 0x10000000000000L) {
                    return 52;
                }
                return 53;
            }
            if (l2 < 0x40000000000000L) {
                return 54;
            }
            return 55;
        }
        if (l2 < 0x800000000000000L) {
            if (l2 < 0x200000000000000L) {
                if (l2 < 0x100000000000000L) {
                    return 56;
                }
                return 57;
            }
            if (l2 < 0x400000000000000L) {
                return 58;
            }
            return 59;
        }
        if (l2 < 0x2000000000000000L) {
            if (l2 < 0x1000000000000000L) {
                return 60;
            }
            return 61;
        }
        if (l2 < 0x4000000000000000L) {
            return 62;
        }
        return 63;
    }

    public static void truncate(long[] lArray, int n2) {
        int n3 = lArray.length - (n2 >>> 6) - 1;
        if (n3 < 0) {
            return;
        }
        int n4 = n3;
        lArray[n4] = lArray[n4] & (1L << n2) - 1L;
        for (n2 = 0; n2 < n3; ++n2) {
            lArray[n2] = 0L;
        }
    }

    public static int wordLength(long[] lArray) {
        int n2;
        int n3 = lArray.length - 1;
        for (n2 = 0; n2 < n3 && lArray[n2] == 0L; ++n2) {
        }
        return n3 + 1 - n2;
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        int n2;
        int n3 = LongIntUtils.wordLength(lArray);
        if (n3 != (n2 = LongIntUtils.wordLength(lArray2))) {
            return false;
        }
        int n4 = lArray.length;
        n3 = lArray.length - n3;
        n2 = lArray2.length - n2;
        while (n3 < n4) {
            if (lArray[n3] != lArray2[n2]) {
                return false;
            }
            ++n3;
            ++n2;
        }
        return true;
    }

    public static long shiftLeft(long[] lArray, int n2, long[] lArray2) {
        int n3 = n2 >>> 6;
        long l2 = 0L;
        int n4 = lArray.length;
        int n5 = n4 - 1;
        if ((n2 & 0x3F) == 0) {
            if (n3 > 0 && n3 <= n4) {
                l2 = lArray[n3 - 1];
            }
            for (n4 = n3; n4 <= n5; ++n4) {
                lArray2[n4 - n3] = lArray[n4];
            }
        } else {
            if (n3 < n4) {
                l2 = lArray[n3] >>> -n2;
            }
            for (n4 = n3; n4 < n5; ++n4) {
                lArray2[n4 - n3] = lArray[n4] << n2 | lArray[n4 + 1] >>> -n2;
            }
            if (n3 <= n5) {
                lArray2[n5 - n3] = lArray[n5] << n2;
            }
        }
        for (n4 = n5; n4 > n5 - n3 && n4 > 0; --n4) {
            lArray2[n4] = 0L;
        }
        return l2;
    }

    public static void shiftRight(long[] lArray, long l2, int n2, long[] lArray2) {
        int n3 = n2 >>> 6;
        int n4 = lArray.length;
        int n5 = n4 - 1;
        if ((n2 & 0x3F) == 0) {
            n5 -= n3;
            while (n5 >= 0) {
                lArray2[n5 + n3] = lArray[n5];
                --n5;
            }
            if (n3 > 0 && n3 <= n4) {
                lArray2[n3 - 1] = l2;
            }
        } else {
            n5 -= n3;
            while (n5 > 0) {
                lArray2[n5 + n3] = lArray[n5] >>> n2 | lArray[n5 - 1] << -n2;
                --n5;
            }
            if (n3 < n4) {
                lArray2[n3] = lArray[0] >>> n2 | l2 << -n2;
            }
            if (n3 > 0) {
                lArray2[n3 - 1] = l2 >>> n2;
            }
        }
        for (n5 = 0; n5 < n3 - 1 && n5 < n4; ++n5) {
            lArray2[n5] = 0L;
        }
    }

    public static int getBit(long[] lArray, int n2) {
        int n3 = n2 >>> 6;
        int n4 = lArray.length;
        if (n2 < 0 || n3 >= n4) {
            return 0;
        }
        return (int)(lArray[n4 - 1 - n3] >>> n2) & 1;
    }

    public static byte[] toByteArray(long[] lArray, int n2) {
        byte[] byArray = new byte[n2];
        LongIntUtils.toByteArray(lArray, byArray);
        return byArray;
    }

    public static void toByteArray(long[] lArray, byte[] byArray) {
        int n2 = byArray.length - 1;
        int n3 = lArray.length - 1;
        while (n3 > 0 && n2 >= 7) {
            long l2 = lArray[n3--];
            byArray[n2--] = (byte)l2;
            byArray[n2--] = (byte)(l2 >>> 8);
            byArray[n2--] = (byte)(l2 >>> 16);
            byArray[n2--] = (byte)(l2 >>> 24);
            byArray[n2--] = (byte)(l2 >>> 32);
            byArray[n2--] = (byte)(l2 >>> 40);
            byArray[n2--] = (byte)(l2 >>> 48);
            byArray[n2--] = (byte)(l2 >>> 56);
        }
        for (int i2 = 0; n2 >= 0 && i2 < 64; i2 += 8) {
            byArray[n2--] = (byte)(lArray[n3] >>> i2);
        }
        while (n2 >= 0) {
            byArray[n2] = 0;
            --n2;
        }
    }

    public static long[] fromByteArray(byte[] byArray, int n2) {
        int n3;
        int n4 = byArray.length;
        for (n3 = 0; n3 < n4 && byArray[n3] == 0; ++n3) {
        }
        long[] lArray = new long[n2 > (n3 = n4 - n3 + 7 >>> 3) ? n2 : n3];
        LongIntUtils.fromByteArray(byArray, lArray);
        return lArray;
    }

    public static void fromByteArray(byte[] byArray, long[] lArray) {
        int n2;
        int n3 = lArray.length - 1;
        for (n2 = byArray.length - 1; n2 >= 8 && n3 >= 0; n2 -= 8) {
            lArray[n3--] = (long)(byArray[n2] & 0xFF | (byArray[n2 - 1] & 0xFF) << 8 | (byArray[n2 - 2] & 0xFF) << 16) | ((long)byArray[n2 - 3] & 0xFFL) << 24 | ((long)byArray[n2 - 4] & 0xFFL) << 32 | ((long)byArray[n2 - 5] & 0xFFL) << 40 | ((long)byArray[n2 - 6] & 0xFFL) << 48 | ((long)byArray[n2 - 7] & 0xFFL) << 56;
        }
        if (n3 >= 0) {
            int n4;
            for (n4 = 0; n4 <= n3; ++n4) {
                lArray[n4] = 0L;
            }
            n4 = 0;
            while (n2 >= 0) {
                int n5 = n3;
                lArray[n5] = lArray[n5] | ((long)byArray[n2] & 0xFFL) << n4;
                --n2;
                n4 += 8;
            }
        }
    }

    public static void toIntArray(long[] lArray, int[] nArray) {
        int n2 = nArray.length - 1;
        int n3 = lArray.length - 1;
        while (n3 > 0 && n2 > 0) {
            long l2 = lArray[n3--];
            nArray[n2--] = (int)l2;
            nArray[n2--] = (int)(l2 >>> 32);
        }
        for (int i2 = 0; n2 >= 0 && i2 < 64; i2 += 32) {
            nArray[n2--] = (int)(lArray[n3] >>> i2);
        }
        while (n2 >= 0) {
            nArray[n2] = 0;
            --n2;
        }
    }

    public static void fromIntArray(int[] nArray, long[] lArray) {
        int n2;
        int n3 = lArray.length - 1;
        for (n2 = nArray.length - 1; n2 >= 2 && n3 >= 0; n2 -= 2) {
            lArray[n3--] = (long)nArray[n2] & 0xFFFFFFFFL | (long)nArray[n2 - 1] << 32;
        }
        if (n3 >= 0) {
            int n4;
            for (n4 = 0; n4 <= n3; ++n4) {
                lArray[n4] = 0L;
            }
            n4 = 0;
            while (n2 >= 0) {
                int n5 = n3;
                lArray[n5] = lArray[n5] | ((long)nArray[n2] & 0xFFFFFFFFL) << n4;
                --n2;
                n4 += 32;
            }
        }
    }

    public static int hashCode(long[] lArray) {
        int[] nArray = new int[lArray.length << 1];
        LongIntUtils.toIntArray(lArray, nArray);
        int n2 = 0;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            n2 = n2 * 31 + nArray[i2];
        }
        return n2;
    }

    public static void copy(long[] lArray, long[] lArray2) {
        int n2 = lArray.length;
        int n3 = lArray2.length;
        n3 -= n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray2[i2] = 0L;
        }
        System.arraycopy(lArray, 0, lArray2, n3, n2);
    }

    public static BigInteger createRandomInRange(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        int n2 = bigInteger.compareTo(bigInteger2);
        if (n2 >= 0) {
            if (n2 > 0) {
                throw new IllegalArgumentException("'min' may not be greater than 'max'");
            }
            return bigInteger;
        }
        if (bigInteger.bitLength() > bigInteger2.bitLength() / 2) {
            return LongIntUtils.createRandomInRange(a, bigInteger2.subtract(bigInteger), secureRandom).add(bigInteger);
        }
        for (n2 = 0; n2 < 1000; ++n2) {
            BigInteger bigInteger3 = new BigInteger(bigInteger2.bitLength(), secureRandom);
            if (bigInteger3.compareTo(bigInteger) < 0 || bigInteger3.compareTo(bigInteger2) > 0) continue;
            return bigInteger3;
        }
        return new BigInteger(bigInteger2.subtract(bigInteger).bitLength() - 1, secureRandom).add(bigInteger);
    }
}

