/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.Digest;
import com.bifit.security.core.DigestEngine;
import com.bifit.security.core.RSACipherNoPadding;
import com.bifit.security.core.RSAKey;
import com.bifit.security.core.Utils;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;

public final class RSACipherOAEPPadding {
    public static final int SHA1 = 0;
    public static final int SHA224 = 1;
    public static final int SHA256 = 2;
    public static final int SHA384 = 3;
    public static final int SHA512 = 4;
    public static final int MD2 = 5;
    public static final int MD5 = 6;
    private final Digest a;
    private final byte[] b;
    public static final int ENCRYPT = 0;
    public static final int DECRYPT = 1;
    private int c;
    private final ByteArrayOutputStream d = new ByteArrayOutputStream();
    private final RSACipherNoPadding e;
    private SecureRandom f;
    private boolean g = false;

    public RSACipherOAEPPadding() {
        this(0);
    }

    public RSACipherOAEPPadding(int n2) {
        if (n2 < 0 && n2 > 6) {
            throw new IllegalArgumentException("invalid type digest");
        }
        this.a = new DigestEngine(n2);
        this.a.init();
        this.a.update(new byte[0], 0, 0);
        this.b = this.a.doFinal();
        this.e = new RSACipherNoPadding();
    }

    public final void init(int n2, RSAKey rSAKey, SecureRandom secureRandom) {
        this.e.init(n2, rSAKey, secureRandom);
        this.f = secureRandom;
        this.g = true;
        this.c = n2;
    }

    public final void update(byte[] byArray, int n2, int n3) {
        if (!this.g) {
            throw new IllegalStateException("cipher was not initialized");
        }
        this.d.write(byArray, n2, n3);
        if (this.d.size() > this.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
    }

    public final byte[] doFinalEncrypt() {
        if (!this.g) {
            throw new IllegalStateException("cipher was not initialized");
        }
        byte[] byArray = this.d.toByteArray();
        this.d.reset();
        int n2 = byArray.length;
        boolean bl = false;
        byte[] byArray2 = byArray;
        RSACipherOAEPPadding rSACipherOAEPPadding = this;
        if (rSACipherOAEPPadding.c == 0) {
            return rSACipherOAEPPadding.a(byArray2, 0, n2);
        }
        return rSACipherOAEPPadding.b(byArray2, 0, n2);
    }

    public final int getInputBlockSize() {
        int n2 = this.e.getInputBlockSize();
        if (this.c == 0) {
            return n2 - 1 - 2 * this.b.length;
        }
        return n2;
    }

    private byte[] a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[this.getInputBlockSize() + 1 + 2 * this.b.length];
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        byArray2[byArray2.length - n3 - 1] = 1;
        System.arraycopy(this.b, 0, byArray2, this.b.length, this.b.length);
        byArray = new byte[this.b.length];
        this.f.nextBytes(byArray);
        byte[] byArray3 = this.a(byArray, 0, byArray.length, byArray2.length - this.b.length);
        for (n3 = this.b.length; n3 != byArray2.length; ++n3) {
            int n4 = n3;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray3[n3 - this.b.length]);
        }
        System.arraycopy(byArray, 0, byArray2, 0, this.b.length);
        byArray3 = this.a(byArray2, this.b.length, byArray2.length - this.b.length, this.b.length);
        for (n3 = 0; n3 != this.b.length; ++n3) {
            int n5 = n3;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray3[n3]);
        }
        return this.e.a(byArray2, 0, byArray2.length);
    }

    private byte[] b(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        if ((byArray = this.e.a(byArray, n2, n3)).length < this.e.a()) {
            byArray2 = new byte[this.e.a()];
            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        if (byArray2.length < 2 * this.b.length + 1) {
            throw new IllegalStateException("data too short");
        }
        byArray = this.a(byArray2, this.b.length, byArray2.length - this.b.length, this.b.length);
        for (n3 = 0; n3 != this.b.length; ++n3) {
            int n4 = n3;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray[n3]);
        }
        byArray = this.a(byArray2, 0, this.b.length, byArray2.length - this.b.length);
        for (n3 = this.b.length; n3 != byArray2.length; ++n3) {
            int n5 = n3;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray[n3 - this.b.length]);
        }
        for (n3 = 0; n3 != this.b.length; ++n3) {
            if (this.b[n3] == byArray2[this.b.length + n3]) continue;
            throw new IllegalStateException("data hash wrong");
        }
        for (n3 = 2 * this.b.length; n3 != byArray2.length && byArray2[n3] == 0; ++n3) {
        }
        if (n3 >= byArray2.length - 1 || byArray2[n3] != 1) {
            throw new IllegalStateException("data start wrong " + n3);
        }
        byArray = new byte[byArray2.length - ++n3];
        System.arraycopy(byArray2, n3, byArray, 0, byArray.length);
        return byArray;
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) {
        byte[] byArray2;
        int n5;
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[4];
        int n6 = this.b.length;
        this.a.init();
        for (n5 = 0; n5 < n4 / n6; ++n5) {
            Utils.intToBigEndian(n5, byArray4, 0);
            this.a.update(byArray, n2, n3);
            this.a.update(byArray4, 0, byArray4.length);
            byArray2 = this.a.doFinal();
            System.arraycopy(byArray2, 0, byArray3, n5 * byArray2.length, byArray2.length);
        }
        if (n5 * n6 < n4) {
            Utils.intToBigEndian(n5, byArray4, 0);
            this.a.update(byArray, n2, n3);
            this.a.update(byArray4, 0, byArray4.length);
            byArray2 = this.a.doFinal();
            System.arraycopy(byArray2, 0, byArray3, n5 * byArray2.length, byArray3.length - n5 * byArray2.length);
        }
        return byArray3;
    }
}

