/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.RSAKeyParams;
import com.bifit.security.core.RSAPrivateKey;
import com.bifit.security.core.RSAPublicKey;
import com.bifit.security.core.Utils;
import java.security.SecureRandom;
import java.util.Random;

public class RSAKeyPairGenerator {
    private RSAPrivateKey a = null;
    private RSAPublicKey b = null;
    private final RSAKeyParams c;
    private final GFp d;
    private final int[] e;
    private final int[] f;
    private final int[] g;
    private final int[] h;
    private final int[] i;
    private final int[] j;
    private final int[] k;
    private final int[] l;
    private final int[] m;
    private final int[] n;
    private final int[] o;
    private final int[] p;
    private final BigInt q;

    public RSAKeyPairGenerator(RSAKeyParams rSAKeyParams) {
        this.c = rSAKeyParams;
        this.e = rSAKeyParams.a();
        int n2 = rSAKeyParams.getStrength() >> 5;
        int n3 = n2 >> 1;
        this.f = new int[n3];
        this.i = new int[n3];
        this.m = new int[n3];
        this.g = new int[n3];
        this.h = new int[n3];
        this.n = new int[n3];
        this.o = new int[n3];
        this.k = new int[n2];
        this.j = new int[n2];
        this.l = new int[n2];
        this.d = new GFp(this.e);
        this.q = new BigInt(n3);
        this.p = this.q.getOne();
    }

    public RSAKeyPairGenerator(int n2, SecureRandom secureRandom) {
        this.c = new RSAKeyParams(n2, secureRandom);
        this.e = this.c.a();
        n2 = this.c.getStrength() >> 5;
        int n3 = n2 >> 1;
        this.f = new int[n3];
        this.i = new int[n3];
        this.m = new int[n3];
        this.g = new int[n3];
        this.h = new int[n3];
        this.n = new int[n3];
        this.o = new int[n3];
        this.k = new int[n2];
        this.j = new int[n2];
        this.l = new int[n2];
        this.d = new GFp(this.e);
        this.q = new BigInt(n3);
        this.p = this.q.getOne();
    }

    public void generate() {
        int n2 = this.c.getStrength();
        int n3 = (n2 + 1) / 2;
        int n4 = n2 - n3;
        n2 /= 3;
        while (true) {
            this.q.getRandomNumber((Random)this.c.getRandom(), n3, this.f);
            this.d.reduce(this.f, this.i);
            if (BigInt.equals(this.i, this.p) || !BigInt.isPrime(this.f)) continue;
            this.q.subtract(this.f, this.p, this.i);
            this.q.gcd(this.e, this.i, this.i);
            if (BigInt.equals(this.i, this.p)) break;
        }
        while (true) {
            this.q.getRandomNumber((Random)this.c.getRandom(), n4, this.g);
            if (BigInt.compare(this.g, this.f) > 0) {
                this.q.subtract(this.g, this.f, this.h);
            } else {
                this.q.subtract(this.f, this.g, this.h);
            }
            if (BigInt.bitLength(this.h) < n2) continue;
            this.d.reduce(this.g, this.h);
            if (BigInt.equals(this.h, this.p) || !BigInt.isPrime(this.g)) continue;
            this.q.subtract(this.g, this.p, this.h);
            this.q.gcd(this.e, this.h, this.h);
            if (!BigInt.equals(this.h, this.p)) continue;
            this.q.multiply(this.f, this.g, this.k);
            if (BigInt.bitLength(this.k) == this.c.getStrength()) break;
            if (BigInt.compare(this.g, this.f) <= 0) continue;
            Utils.copy(this.g, this.f);
        }
        if (BigInt.compare(this.g, this.f) > 0) {
            Utils.copy(this.g, this.h);
            Utils.copy(this.f, this.g);
            Utils.copy(this.h, this.f);
        }
        this.q.subtract(this.f, this.p, this.i);
        this.q.subtract(this.g, this.p, this.h);
        this.q.multiply(this.i, this.h, this.l);
        GFp gFp = new GFp(this.l);
        gFp.invert(this.e, this.j);
        this.q.divide(this.j, this.i, null, this.m);
        this.q.divide(this.j, this.h, null, this.n);
        gFp = new GFp(this.f);
        gFp.invert(this.g, this.o);
        this.a = new RSAPrivateKey(this.k, this.c.getStrength(), this.j, this.f, this.g, this.m, this.n, this.o);
        this.b = new RSAPublicKey(this.k, this.c.getStrength(), this.e);
    }

    public RSAPrivateKey getPrivate() {
        if (this.a == null) {
            throw new IllegalStateException("key pair were not generated");
        }
        return this.a;
    }

    public RSAPublicKey getPublic() {
        if (this.b == null) {
            throw new IllegalStateException("key pair were not generated");
        }
        return this.b;
    }
}

