/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.Utils;
import java.security.SecureRandom;

public class RSAKeyParams {
    private final SecureRandom a;
    private final int b;
    private final int[] c;
    private final int d;

    public RSAKeyParams() {
        this.b = 2048;
        this.d = 12;
        this.a = new SecureRandom();
        this.c = new int[this.b >>> 6];
        this.c[this.c.length - 1] = 65537;
    }

    public RSAKeyParams(byte[] byArray, SecureRandom secureRandom, int n2, int n3) {
        this.a = secureRandom;
        this.b = n2;
        if (n2 < 32 || n2 % 32 != 0) {
            throw new IllegalArgumentException("key strength value is incorrect");
        }
        this.c = Utils.fromByteArray(byArray, n2 >>> 6);
        if (BigInt.getBit(this.c, 0) != 1) {
            throw new IllegalArgumentException("public exponent cannot be even");
        }
        this.d = n3;
    }

    public RSAKeyParams(int n2, SecureRandom secureRandom) {
        if (n2 < 32 || n2 % 32 != 0) {
            throw new IllegalArgumentException("key strength value is incorrect");
        }
        this.a = secureRandom;
        this.b = n2;
        this.d = 12;
        this.c = new int[n2 >>>= 6];
        this.c[n2 - 1] = 65537;
    }

    public byte[] getPublicExponent() {
        return Utils.toByteArray(this.c, Utils.wordLength(this.c) << 2);
    }

    final int[] a() {
        return this.c;
    }

    public int getCertainty() {
        return this.d;
    }

    public SecureRandom getRandom() {
        return this.a;
    }

    public int getStrength() {
        return this.b;
    }
}

