/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.RSAKey;
import com.bifit.security.core.Utils;

public final class RSAPrivateKey
extends RSAKey {
    private final int[] a;
    private final int[] b;
    private final int[] c;
    private final int[] d;
    private final int[] e;
    private final int[] f;

    public RSAPrivateKey(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) {
        super(Utils.fromByteArray(byArray, byArray.length / 4), n2, true);
        int n3 = this.getSize() >>> 1;
        this.a = Utils.fromByteArray(byArray2, this.getSize());
        this.b = Utils.fromByteArray(byArray3, n3);
        this.c = Utils.fromByteArray(byArray4, n3);
        this.d = Utils.fromByteArray(byArray5, n3);
        this.e = Utils.fromByteArray(byArray6, n3);
        this.f = Utils.fromByteArray(byArray7, n3);
    }

    public RSAPrivateKey(byte[] byArray, int n2, byte[] objectArray, byte[] objectArray2, byte[] byArray2) {
        super(Utils.fromByteArray(byArray, byArray.length / 4), n2, true);
        int n3 = this.getSize() >>> 1;
        this.a = Utils.fromByteArray(objectArray, this.getSize());
        this.b = Utils.fromByteArray(objectArray2, n3);
        this.c = Utils.fromByteArray(byArray2, n3);
        this.d = new int[n3];
        this.e = new int[n3];
        this.f = new int[n3];
        int[] nArray = new int[this.getSize()];
        objectArray = new int[n3];
        objectArray2 = new int[n3];
        Object object = new BigInt(n3);
        ((BigInt)object).subtract(this.b, ((BigInt)object).getOne(), (int[])objectArray);
        ((BigInt)object).subtract(this.c, ((BigInt)object).getOne(), (int[])objectArray2);
        ((BigInt)object).multiply((int[])objectArray, (int[])objectArray2, nArray);
        ((BigInt)object).divide(this.a, (int[])objectArray, null, this.d);
        ((BigInt)object).divide(this.a, (int[])objectArray2, null, this.e);
        object = new GFp(this.b);
        ((GFp)object).invert(this.c, this.f);
    }

    RSAPrivateKey(int[] nArray, int n2, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        super(nArray, n2, true);
        this.a = Utils.copy(nArray2);
        this.b = Utils.copy(nArray3);
        this.c = Utils.copy(nArray4);
        this.d = Utils.copy(nArray5);
        this.e = Utils.copy(nArray6);
        this.f = Utils.copy(nArray7);
    }

    public final byte[] getPrivateExponent() {
        return Utils.toByteArray(this.a, Utils.wordLength(this.a) << 2);
    }

    public final byte[] getP() {
        return Utils.toByteArray(this.b, Utils.wordLength(this.b) << 2);
    }

    public final byte[] getQ() {
        return Utils.toByteArray(this.c, Utils.wordLength(this.c) << 2);
    }

    public final byte[] getDP() {
        return Utils.toByteArray(this.d, Utils.wordLength(this.b) << 2);
    }

    public final byte[] getDQ() {
        return Utils.toByteArray(this.e, Utils.wordLength(this.b) << 2);
    }

    public final byte[] getQInv() {
        return Utils.toByteArray(this.f, Utils.wordLength(this.f) << 2);
    }

    final int[] c() {
        return this.a;
    }
}

