/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app.ua_currency_payment;

import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ua.com.dbosoft.autoclient.app.validation.Date;

public class MandatoryReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MandatoryReport.class);
    private static final java.util.regex.Pattern KEY_PATTERN = java.util.regex.Pattern.compile("/(N\\d+)/(([^/]|/(?!N\\d+/))*)");
    @Size(min=2, max=2, message="{fieldLength} \"{desc.MANDATORY_REPORT} N10\" {mustBe} {min} {symbols3} (MANDATORY_REPORT)")
    @Pattern(regexp="[A-Z0-9]*", message="{incorrectFieldFormat} \"{desc.MANDATORY_REPORT} N10\" (MANDATORY_REPORT)")
    private @Size(min=2, max=2, message="{fieldLength} \"{desc.MANDATORY_REPORT} N10\" {mustBe} {min} {symbols3} (MANDATORY_REPORT)") @Pattern(regexp="[A-Z0-9]*", message="{incorrectFieldFormat} \"{desc.MANDATORY_REPORT} N10\" (MANDATORY_REPORT)") String n10;
    @Size(min=20, max=20, message="{fieldLength} \"{desc.MANDATORY_REPORT} N4\" {mustBe} {min} {symbols5} (MANDATORY_REPORT)")
    @Digits(integer=20, fraction=0, message="{field} \"{desc.MANDATORY_REPORT} N4\" {mustContainDigits} (MANDATORY_REPORT)")
    private @Size(min=20, max=20, message="{fieldLength} \"{desc.MANDATORY_REPORT} N4\" {mustBe} {min} {symbols5} (MANDATORY_REPORT)") @Digits(integer=20, fraction=0, message="{field} \"{desc.MANDATORY_REPORT} N4\" {mustContainDigits} (MANDATORY_REPORT)") String n4;
    @Size(min=8, max=8, message="{fieldLength} \"{desc.MANDATORY_REPORT} N5\" {mustBe} {min} {symbols5} (MANDATORY_REPORT)")
    @Digits(integer=8, fraction=0, message="{field} \"{desc.MANDATORY_REPORT} N5\" {mustContainDigits} (MANDATORY_REPORT)")
    private @Size(min=8, max=8, message="{fieldLength} \"{desc.MANDATORY_REPORT} N5\" {mustBe} {min} {symbols5} (MANDATORY_REPORT)") @Digits(integer=8, fraction=0, message="{field} \"{desc.MANDATORY_REPORT} N5\" {mustContainDigits} (MANDATORY_REPORT)") String n5;
    @Size(min=2, max=2, message="{fieldLength} \"{desc.MANDATORY_REPORT} N6\" {mustBe} {min} {symbols3} (MANDATORY_REPORT)")
    @Pattern(regexp="TR|RS|OT|RT|PR|VU|AP|AR|TP|ZD", message="{incorrectFieldFormat} \"{desc.MANDATORY_REPORT} N6\" (MANDATORY_REPORT)")
    private @Size(min=2, max=2, message="{fieldLength} \"{desc.MANDATORY_REPORT} N6\" {mustBe} {min} {symbols3} (MANDATORY_REPORT)") @Pattern(regexp="TR|RS|OT|RT|PR|VU|AP|AR|TP|ZD", message="{incorrectFieldFormat} \"{desc.MANDATORY_REPORT} N6\" (MANDATORY_REPORT)") String n6;
    @Size(min=10, max=10, message="{fieldLength} \"{desc.MANDATORY_REPORT} N7\" {mustBe} {min} {symbols5} (MANDATORY_REPORT)")
    @Pattern(regexp="[A-Z0-9]{2}\\.((0[0-9])|(1[0-2]))\\.((19)|(20)\\d\\d)", message="{incorrectFieldFormat} \"{desc.MANDATORY_REPORT} N7\" (MANDATORY_REPORT)")
    private @Size(min=10, max=10, message="{fieldLength} \"{desc.MANDATORY_REPORT} N7\" {mustBe} {min} {symbols5} (MANDATORY_REPORT)") @Pattern(regexp="[A-Z0-9]{2}\\.((0[0-9])|(1[0-2]))\\.((19)|(20)\\d\\d)", message="{incorrectFieldFormat} \"{desc.MANDATORY_REPORT} N7\" (MANDATORY_REPORT)") String n7;
    @Size(max=15, message="{fieldLength} \"{desc.MANDATORY_REPORT} N8\" {mustBeNotGreater} {max} {symbols5}")
    @Pattern(regexp="[\u2116%&\u2019a-zA-MO-Z\u0410-\u042f0-9/\\-?:().,'+ \\r\\n]{0,15}", message="{incorrectFieldFormat} \"{desc.MANDATORY_REPORT} N8\" (MANDATORY_REPORT)")
    private @Size(max=15, message="{fieldLength} \"{desc.MANDATORY_REPORT} N8\" {mustBeNotGreater} {max} {symbols5}") @Pattern(regexp="[\u2116%&\u2019a-zA-MO-Z\u0410-\u042f0-9/\\-?:().,'+ \\r\\n]{0,15}", message="{incorrectFieldFormat} \"{desc.MANDATORY_REPORT} N8\" (MANDATORY_REPORT)") String n8;
    @Date(message="{incorrectDateInField} \"{desc.MANDATORY_REPORT} N9\" (MANDATORY_REPORT)")
    private String n9;

    public void parse(String object) {
        LOGGER.debug("\u0420\u043e\u0437\u0431\u0456\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u043e\u043b\u044f '\u041e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0430 \u0437\u0432\u0456\u0442\u043d\u0456\u0441\u0442\u044c'. \u041f\u043e\u0447\u0430\u0442\u043e\u043a. mandatoryReport: \"{}\"", object);
        object = KEY_PATTERN.matcher((CharSequence)object);
        while (((Matcher)object).find()) {
            this.set(((Matcher)object).group(1), ((Matcher)object).group(2));
        }
        LOGGER.debug("\u0420\u043e\u0437\u0431\u0456\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u043e\u043b\u044f '\u041e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0430 \u0437\u0432\u0456\u0442\u043d\u0456\u0441\u0442\u044c'. \u041a\u0456\u043d\u0435\u0446\u044c");
    }

    private void set(String string, String string2) {
        LOGGER.debug("key: \"{}\", value: \"{}\"", (Object)string, (Object)string2);
        if (string2.isEmpty()) {
            string2 = null;
        }
        switch (string) {
            case "N10": {
                this.n10 = string2;
                return;
            }
            case "N4": {
                this.n4 = string2;
                return;
            }
            case "N5": {
                this.n5 = string2;
                return;
            }
            case "N6": {
                this.n6 = string2;
                return;
            }
            case "N7": {
                this.n7 = string2;
                return;
            }
            case "N8": {
                this.n8 = string2;
                return;
            }
            case "N9": {
                this.n9 = string2;
                return;
            }
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0456\u0434\u043e\u043c\u0438\u0439 \u043a\u043b\u044e\u0447 \u0443 \u043f\u043e\u043b\u0456 '\u041e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0430 \u0437\u0432\u0456\u0442\u043d\u0456\u0441\u0442\u044c': " + string);
    }

    public String getN10() {
        return this.n10;
    }

    public String getN4() {
        return this.n4;
    }

    public String getN5() {
        return this.n5;
    }

    public String getN6() {
        return this.n6;
    }

    public String getN7() {
        return this.n7;
    }

    public String getN8() {
        return this.n8;
    }

    public String getN9() {
        return this.n9;
    }
}

