/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app.ua_currency_payment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import ua.com.dbosoft.autoclient.app.account.Iban;
import ua.com.dbosoft.autoclient.app.c;
import ua.com.dbosoft.autoclient.app.validation.a;
import ua.com.dbosoft.autoclient.format.ibank2.d;
import ua.com.dbosoft.autoclient.format.json.BigDecimalSerializer;
import ua.com.dbosoft.autoclient.format.json.BooleanSerializer;
import ua.com.dbosoft.autoclient.format.json.LocalDateSerializer;

public class UaCurrencyPayment
implements c {
    private static final ua.com.dbosoft.autoclient.format.ibank2.c<UaCurrencyPayment> UA_CURRENCY_PAYMENT_WRITER = new ua.com.dbosoft.autoclient.format.ibank2.c<UaCurrencyPayment>(UaCurrencyPayment.class);
    private long id;
    private Integer statusCode;
    @JsonProperty(value="DATE_DOC")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate date;
    @JsonProperty(value="NUM_DOC")
    private String number;
    @JsonProperty(value="CLN_BNK_NAME")
    private String clientBankName;
    @JsonProperty(value="CLN_BNK_BIC_TYPE")
    private String clientBankBicType;
    @JsonProperty(value="CLN_BNK_BIC")
    private String clientBankBic;
    @JsonProperty(value="CLN_BNK_COUNTRY")
    private String clientBankCountry;
    @JsonProperty(value="CLN_BNK_CITY")
    private String clientBankCity;
    @JsonProperty(value="CLN_BNK_ADDR")
    private String clientBankAddress;
    @JsonProperty(value="CLN_NAME")
    private String clientName;
    @JsonProperty(value="CLN_COUNTRY")
    private String clientCountry;
    @JsonProperty(value="CLN_CITY")
    private String clientCity;
    @JsonProperty(value="CLN_ADDR")
    private String clientAddress;
    @JsonProperty(value="CLN_EMPLOYEE_FIO")
    private String clientEmployeeFullName;
    @JsonProperty(value="CLN_EMPLOYEE_PHONE")
    private String clientEmployeePhone;
    @JsonProperty(value="CLN_ACCOUNT")
    private String clientAccount;
    @JsonProperty(value="AMOUNT")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal amount;
    @JsonProperty(value="AMOUNT_CURRENCY")
    private String currency;
    @JsonProperty(value="AMOUNT_CURRENCY_CODE")
    private String currencyCode;
    @JsonProperty(value="CURRENCY_DATE")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate currencyDate;
    @JsonProperty(value="INTERMED_BNK_NAME")
    private String intermediaryBankName;
    @JsonProperty(value="INTERMED_BNK_BIC_TYPE")
    private String intermediaryBankBicType;
    @JsonProperty(value="INTERMED_BNK_BIC")
    private String intermediaryBankBic;
    @JsonProperty(value="INTERMED_BNK_COUNTRY")
    private String intermediaryBankCountry;
    @JsonProperty(value="INTERMED_BNK_CITY")
    private String intermediaryBankCity;
    @JsonProperty(value="INTERMED_BNK_ADDR")
    private String intermediaryBankAddress;
    @JsonProperty(value="RCPT_BNK_NAME")
    private String recipientBankName;
    @JsonProperty(value="RCPT_BNK_BIC_TYPE")
    private String recipientBankBicType;
    @JsonProperty(value="RCPT_BNK_BIC")
    private String recipientBankBic;
    @JsonProperty(value="RCPT_BNK_ACCOUNT")
    private String recipientBankAccount;
    @JsonProperty(value="RCPT_BNK_COUNTRY")
    private String recipientBankCountry;
    @JsonProperty(value="RCPT_BNK_CITY")
    private String recipientBankCity;
    @JsonProperty(value="RCPT_BNK_ADDR")
    private String recipientBankAddress;
    @JsonProperty(value="RCPT_NAME")
    private String recipientName;
    @JsonProperty(value="RCPT_ACCOUNT")
    private String recipientAccount;
    @JsonProperty(value="RCPT_COUNTRY")
    private String recipientCountry;
    @JsonProperty(value="RCPT_CITY")
    private String recipientCity;
    @JsonProperty(value="RCPT_ADDR")
    private String recipientAddress;
    @JsonProperty(value="PAYMENT_DETAILS")
    private String paymentDetails;
    @JsonProperty(value="EXPENSE_TYPE")
    private String expenseType;
    @JsonProperty(value="EXPENSE_ACCOUNT")
    private String expenseAccount;
    @JsonProperty(value="PAYMENT_SPEED")
    private String paymentSpeed;
    @JsonProperty(value="PAYMENT_ADDED_INFO")
    private String paymentAdditionalInfo;
    @JsonProperty(value="CLN_OKPO")
    private String clientCode;
    @JsonProperty(value="RCPT_BNK_IBAN")
    private String recipientBankIban;
    @JsonProperty(value="INTERMED_BNK_COUNTRY_CODE")
    private String intermediaryBankCountryCode;
    @JsonProperty(value="RCPT_BNK_COUNTRY_CODE")
    private String recipientBankCountryCode;
    @JsonProperty(value="RCPT_COUNTRY_CODE")
    private String recipientCountryCode;
    @JsonProperty(value="INTERMED_BNK_ACCOUNT")
    private String intermediaryBankAccount;
    @JsonProperty(value="CLN_BNK_MFO")
    private String clientBankCode;
    @JsonProperty(value="OPCODE")
    private String operationCode;
    @JsonProperty(value="CLN_RESIDENT")
    @JsonSerialize(using=BooleanSerializer.class)
    private Boolean clientResident;
    @JsonProperty(value="RCPT_RESIDENT")
    @JsonSerialize(using=BooleanSerializer.class)
    private Boolean recipientResident;
    @JsonProperty(value="CLN_NAME_UKR")
    private String clientNameUkrainian;
    @JsonProperty(value="CLN_ADDR_UKR")
    private String clientAddressUkrainian;
    @JsonProperty(value="CLN_BNK_NAME_UKR")
    private String clientBankNameUkrainian;
    @JsonProperty(value="CLN_BNK_ADDR_UKR")
    private String clientBankAddressUkrainian;
    @JsonProperty(value="COMMISSION_BNK_NAME")
    private String commissionBankName;
    @JsonProperty(value="COMMISSION_BNK_MFO")
    private String commissionBankCode;
    @JsonProperty(value="RCPT_ITN")
    private String recipientItn;
    @JsonProperty(value="ATT_CNT")
    private Integer attachmentsCount;
    @JsonProperty(value="MONEY_SOURCE")
    private Integer moneySource;
    @JsonProperty(value="PURPOSE_CODE")
    private String purposeCode;
    @JsonProperty(value="OPER_TYPE_CODE")
    private String operationTypeCode;
    @JsonProperty(value="MANDATORY_REPORT")
    private String mandatoryReport;
    @JsonProperty(value="CLN_POSTCODE")
    private String clientPostcode;

    @Override
    @d(a="DATE_DOC", b=0, c=false)
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate localDate) {
        this.date = localDate;
    }

    @Override
    @d(a="NUM_DOC", b=1, c=false)
    @Size(max=35, message="{fieldLength} \"{desc.NUM_DOC}\" {mustBeNotGreater} {max} {symbols5} (NUM_DOC)")
    public @Size(max=35, message="{fieldLength} \"{desc.NUM_DOC}\" {mustBeNotGreater} {max} {symbols5} (NUM_DOC)") String getNumber() {
        return this.number;
    }

    public void setNumber(String string) {
        this.number = string;
    }

    @d(a="CLN_BNK_NAME", b=2, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_BNK_NAME}\" (CLN_BNK_NAME)", groups={a.class})
    @Size(max=140, message="{fieldLength} \"{desc.CLN_BNK_NAME}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_NAME)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_BNK_NAME}\" (CLN_BNK_NAME)", groups={a.class}) @Size(max=140, message="{fieldLength} \"{desc.CLN_BNK_NAME}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_NAME)", groups={a.class}) String getClientBankName() {
        return this.clientBankName;
    }

    public void setClientBankName(String string) {
        this.clientBankName = string;
    }

    @d(a="CLN_BNK_BIC_TYPE", b=3, c=false)
    public String getClientBankBicType() {
        return this.clientBankBicType;
    }

    public void setClientBankBicType(String string) {
        this.clientBankBicType = string;
    }

    @d(a="CLN_BNK_BIC", b=4, c=false)
    @Size(max=15, message="{fieldLength} \"{desc.CLN_BNK_BIC}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_BIC)")
    public @Size(max=15, message="{fieldLength} \"{desc.CLN_BNK_BIC}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_BIC)") String getClientBankBic() {
        return this.clientBankBic;
    }

    public void setClientBankBic(String string) {
        this.clientBankBic = string;
    }

    @d(a="CLN_BNK_COUNTRY", b=5, c=false)
    public String getClientBankCountry() {
        return this.clientBankCountry;
    }

    public void setClientBankCountry(String string) {
        this.clientBankCountry = string;
    }

    @d(a="CLN_BNK_CITY", b=6, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_BNK_CITY}\" (CLN_BNK_CITY)", groups={a.class})
    @Size(max=70, message="{fieldLength} \"{desc.CLN_BNK_CITY}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_CITY)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_BNK_CITY}\" (CLN_BNK_CITY)", groups={a.class}) @Size(max=70, message="{fieldLength} \"{desc.CLN_BNK_CITY}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_CITY)", groups={a.class}) String getClientBankCity() {
        return this.clientBankCity;
    }

    public void setClientBankCity(String string) {
        this.clientBankCity = string;
    }

    @d(a="CLN_BNK_ADDR", b=7, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_BNK_ADDR}\" (CLN_BNK_ADDR)", groups={a.class})
    @Size(max=140, message="{fieldLength} \"{desc.CLN_BNK_ADDR}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_ADDR)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_BNK_ADDR}\" (CLN_BNK_ADDR)", groups={a.class}) @Size(max=140, message="{fieldLength} \"{desc.CLN_BNK_ADDR}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_ADDR)", groups={a.class}) String getClientBankAddress() {
        return this.clientBankAddress;
    }

    public void setClientBankAddress(String string) {
        this.clientBankAddress = string;
    }

    @d(a="CLN_NAME", b=8, c=false)
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String string) {
        this.clientName = string;
    }

    @d(a="CLN_COUNTRY", b=9, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_COUNTRY}\" (CLN_COUNTRY)", groups={a.class})
    @Size(max=70, message="{fieldLength} \"{desc.CLN_COUNTRY}\" {mustBeNotGreater} {max} {symbols5} (CLN_COUNTRY)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_COUNTRY}\" (CLN_COUNTRY)", groups={a.class}) @Size(max=70, message="{fieldLength} \"{desc.CLN_COUNTRY}\" {mustBeNotGreater} {max} {symbols5} (CLN_COUNTRY)", groups={a.class}) String getClientCountry() {
        return this.clientCountry;
    }

    public void setClientCountry(String string) {
        this.clientCountry = string;
    }

    @d(a="CLN_CITY", b=10, c=false)
    public String getClientCity() {
        return this.clientCity;
    }

    public void setClientCity(String string) {
        this.clientCity = string;
    }

    @d(a="CLN_ADDR", b=11, c=false)
    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(String string) {
        this.clientAddress = string;
    }

    @d(a="CLN_EMPLOYEE_FIO", b=12, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_EMPLOYEE_FIO}\" (CLN_EMPLOYEE_FIO)", groups={a.class})
    @Size(max=40, message="{fieldLength} \"{desc.CLN_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_FIO)")
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_EMPLOYEE_FIO}\" (CLN_EMPLOYEE_FIO)", groups={a.class}) @Size(max=40, message="{fieldLength} \"{desc.CLN_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_FIO)") String getClientEmployeeFullName() {
        return this.clientEmployeeFullName;
    }

    public void setClientEmployeeFullName(String string) {
        this.clientEmployeeFullName = string;
    }

    @d(a="CLN_EMPLOYEE_PHONE", b=13, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_EMPLOYEE_PHONE}\" (CLN_EMPLOYEE_PHONE)", groups={a.class})
    @Size(max=20, message="{fieldLength} \"{desc.CLN_EMPLOYEE_PHONE}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_PHONE)")
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_EMPLOYEE_PHONE}\" (CLN_EMPLOYEE_PHONE)", groups={a.class}) @Size(max=20, message="{fieldLength} \"{desc.CLN_EMPLOYEE_PHONE}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_PHONE)") String getClientEmployeePhone() {
        return this.clientEmployeePhone;
    }

    public void setClientEmployeePhone(String string) {
        this.clientEmployeePhone = string;
    }

    @d(a="CLN_ACCOUNT", b=14, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_ACCOUNT}\" (CLN_ACCOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_ACCOUNT}\" (CLN_ACCOUNT)") String getClientAccount() {
        return this.clientAccount;
    }

    public void setClientAccount(String string) {
        this.clientAccount = string;
    }

    @d(a="AMOUNT", b=15, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.AMOUNT}\" (AMOUNT)")
    @Digits(integer=10, fraction=6, message="{incorrectAmount} (AMOUNT)", groups={a.class})
    @Positive(message="{docAmountMustBePositive} (AMOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.AMOUNT}\" (AMOUNT)") @Digits(integer=10, fraction=6, message="{incorrectAmount} (AMOUNT)", groups={a.class}) @Positive(message="{docAmountMustBePositive} (AMOUNT)") BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal bigDecimal) {
        this.amount = bigDecimal;
    }

    @d(a="AMOUNT_CURRENCY", b=16, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.AMOUNT_CURRENCY}\" (AMOUNT_CURRENCY)")
    @Size(min=3, max=3, message="{fieldLength} \"{desc.AMOUNT_CURRENCY}\" {mustEqual} {max} {symbols_dative} (AMOUNT_CURRENCY)")
    public @NotNull(message="{emptyRequiredField} \"{desc.AMOUNT_CURRENCY}\" (AMOUNT_CURRENCY)") @Size(min=3, max=3, message="{fieldLength} \"{desc.AMOUNT_CURRENCY}\" {mustEqual} {max} {symbols_dative} (AMOUNT_CURRENCY)") String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String string) {
        this.currency = string;
    }

    @d(a="AMOUNT_CURRENCY_CODE", b=17, c=false)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String string) {
        this.currencyCode = string;
    }

    @d(a="CURRENCY_DATE", b=18, c=false)
    public LocalDate getCurrencyDate() {
        return this.currencyDate;
    }

    public void setCurrencyDate(LocalDate localDate) {
        this.currencyDate = localDate;
    }

    @d(a="INTERMED_BNK_NAME", b=19, c=false)
    @Size(max=140, message="{fieldLength} \"{desc.INTERMED_BNK_NAME}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_NAME)")
    public @Size(max=140, message="{fieldLength} \"{desc.INTERMED_BNK_NAME}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_NAME)") String getIntermediaryBankName() {
        return this.intermediaryBankName;
    }

    public void setIntermediaryBankName(String string) {
        this.intermediaryBankName = string;
    }

    @d(a="INTERMED_BNK_BIC_TYPE", b=20, c=false)
    @Pattern(regexp="CLEAR_CODE|SWIFT", message="{fieldFillingError} \"{desc.INTERMED_BNK_BIC_TYPE}\" (INTERMED_BNK_BIC_TYPE)")
    public @Pattern(regexp="CLEAR_CODE|SWIFT", message="{fieldFillingError} \"{desc.INTERMED_BNK_BIC_TYPE}\" (INTERMED_BNK_BIC_TYPE)") String getIntermediaryBankBicType() {
        return this.intermediaryBankBicType;
    }

    public void setIntermediaryBankBicType(String string) {
        this.intermediaryBankBicType = string;
    }

    @d(a="INTERMED_BNK_BIC", b=21, c=false)
    @Size(max=15, message="{fieldLength} \"{desc.INTERMED_BNK_BIC}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_BIC)")
    public @Size(max=15, message="{fieldLength} \"{desc.INTERMED_BNK_BIC}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_BIC)") String getIntermediaryBankBic() {
        return this.intermediaryBankBic;
    }

    public void setIntermediaryBankBic(String string) {
        this.intermediaryBankBic = string;
    }

    @d(a="INTERMED_BNK_COUNTRY", b=22, c=false)
    @Size(max=70, message="{fieldLength} \"{desc.INTERMED_BNK_COUNTRY}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_COUNTRY)", groups={a.class})
    public @Size(max=70, message="{fieldLength} \"{desc.INTERMED_BNK_COUNTRY}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_COUNTRY)", groups={a.class}) String getIntermediaryBankCountry() {
        return this.intermediaryBankCountry;
    }

    public void setIntermediaryBankCountry(String string) {
        this.intermediaryBankCountry = string;
    }

    @d(a="INTERMED_BNK_CITY", b=23, c=false)
    @Size(max=70, message="{fieldLength} \"{desc.INTERMED_BNK_CITY}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_CITY)")
    public @Size(max=70, message="{fieldLength} \"{desc.INTERMED_BNK_CITY}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_CITY)") String getIntermediaryBankCity() {
        return this.intermediaryBankCity;
    }

    public void setIntermediaryBankCity(String string) {
        this.intermediaryBankCity = string;
    }

    @d(a="INTERMED_BNK_ADDR", b=24, c=false)
    @Size(max=140, message="{fieldLength} \"{desc.INTERMED_BNK_ADDR}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_ADDR)")
    public @Size(max=140, message="{fieldLength} \"{desc.INTERMED_BNK_ADDR}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_ADDR)") String getIntermediaryBankAddress() {
        return this.intermediaryBankAddress;
    }

    public void setIntermediaryBankAddress(String string) {
        this.intermediaryBankAddress = string;
    }

    @d(a="RCPT_BNK_NAME", b=25, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_NAME}\" (RCPT_BNK_NAME)")
    @Size(max=140, message="{fieldLength} \"{desc.RCPT_BNK_NAME}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_NAME)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_NAME}\" (RCPT_BNK_NAME)") @Size(max=140, message="{fieldLength} \"{desc.RCPT_BNK_NAME}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_NAME)") String getRecipientBankName() {
        return this.recipientBankName;
    }

    public void setRecipientBankName(String string) {
        this.recipientBankName = string;
    }

    @d(a="RCPT_BNK_BIC_TYPE", b=26, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_BIC_TYPE}\" (RCPT_BNK_BIC_TYPE)")
    @Pattern(regexp="CLEAR_CODE|SWIFT", message="{fieldFillingError} \"{desc.RCPT_BNK_BIC_TYPE}\": {oneOfTheValuesMustBeSpecified}: CLEAR_CODE, SWIFT (RCPT_BNK_BIC_TYPE)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_BIC_TYPE}\" (RCPT_BNK_BIC_TYPE)") @Pattern(regexp="CLEAR_CODE|SWIFT", message="{fieldFillingError} \"{desc.RCPT_BNK_BIC_TYPE}\": {oneOfTheValuesMustBeSpecified}: CLEAR_CODE, SWIFT (RCPT_BNK_BIC_TYPE)") String getRecipientBankBicType() {
        return this.recipientBankBicType;
    }

    public void setRecipientBankBicType(String string) {
        this.recipientBankBicType = string;
    }

    @d(a="RCPT_BNK_BIC", b=27, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_BIC}\" (RCPT_BNK_BIC)")
    @Size(max=15, message="{fieldLength} \"{desc.RCPT_BNK_BIC}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_BIC)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_BIC}\" (RCPT_BNK_BIC)") @Size(max=15, message="{fieldLength} \"{desc.RCPT_BNK_BIC}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_BIC)") String getRecipientBankBic() {
        return this.recipientBankBic;
    }

    public void setRecipientBankBic(String string) {
        this.recipientBankBic = string;
    }

    @d(a="RCPT_BNK_ACCOUNT", b=28, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_ACCOUNT}\" (RCPT_BNK_ACCOUNT)", groups={a.class})
    @Size(max=35, message="{fieldLength} \"{desc.RCPT_BNK_ACCOUNT}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_ACCOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_ACCOUNT}\" (RCPT_BNK_ACCOUNT)", groups={a.class}) @Size(max=35, message="{fieldLength} \"{desc.RCPT_BNK_ACCOUNT}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_ACCOUNT)") String getRecipientBankAccount() {
        return this.recipientBankAccount;
    }

    public void setRecipientBankAccount(String string) {
        this.recipientBankAccount = string;
    }

    @d(a="RCPT_BNK_COUNTRY", b=29, c=false)
    public String getRecipientBankCountry() {
        return this.recipientBankCountry;
    }

    public void setRecipientBankCountry(String string) {
        this.recipientBankCountry = string;
    }

    @d(a="RCPT_BNK_CITY", b=30, c=false)
    @Size(max=70, message="{fieldLength} \"{desc.RCPT_BNK_CITY}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_CITY)")
    public @Size(max=70, message="{fieldLength} \"{desc.RCPT_BNK_CITY}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_CITY)") String getRecipientBankCity() {
        return this.recipientBankCity;
    }

    public void setRecipientBankCity(String string) {
        this.recipientBankCity = string;
    }

    @d(a="RCPT_BNK_ADDR", b=31, c=false)
    @Size(max=140, message="{fieldLength} \"{desc.RCPT_BNK_ADDR}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_ADDR)")
    public @Size(max=140, message="{fieldLength} \"{desc.RCPT_BNK_ADDR}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_ADDR)") String getRecipientBankAddress() {
        return this.recipientBankAddress;
    }

    public void setRecipientBankAddress(String string) {
        this.recipientBankAddress = string;
    }

    @d(a="RCPT_NAME", b=32, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_NAME}\" (RCPT_NAME)")
    @Size(max=140, message="{fieldLength} \"{desc.RCPT_NAME}\" {mustBeNotGreater} {max} {symbols5} (RCPT_NAME)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_NAME}\" (RCPT_NAME)") @Size(max=140, message="{fieldLength} \"{desc.RCPT_NAME}\" {mustBeNotGreater} {max} {symbols5} (RCPT_NAME)") String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String string) {
        this.recipientName = string;
    }

    @d(a="RCPT_ACCOUNT", b=33, c=false)
    @Size(max=34, message="{fieldLength} \"{desc.RCPT_ACCOUNT}\" {mustBeNotGreater} {max} {symbols3} (RCPT_ACCOUNT)")
    public @Size(max=34, message="{fieldLength} \"{desc.RCPT_ACCOUNT}\" {mustBeNotGreater} {max} {symbols3} (RCPT_ACCOUNT)") String getRecipientAccount() {
        return this.recipientAccount;
    }

    public void setRecipientAccount(String string) {
        this.recipientAccount = string;
    }

    @d(a="RCPT_COUNTRY", b=34, c=false)
    public String getRecipientCountry() {
        return this.recipientCountry;
    }

    public void setRecipientCountry(String string) {
        this.recipientCountry = string;
    }

    @d(a="RCPT_CITY", b=35, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_CITY}\" (RCPT_CITY)")
    @Size(max=70, message="{fieldLength} \"{desc.RCPT_CITY}\" {mustBeNotGreater} {max} {symbols5} (RCPT_CITY)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_CITY}\" (RCPT_CITY)") @Size(max=70, message="{fieldLength} \"{desc.RCPT_CITY}\" {mustBeNotGreater} {max} {symbols5} (RCPT_CITY)") String getRecipientCity() {
        return this.recipientCity;
    }

    public void setRecipientCity(String string) {
        this.recipientCity = string;
    }

    @d(a="RCPT_ADDR", b=36, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_ADDR}\" (RCPT_ADDR)")
    @Size(max=140, message="{fieldLength} \"{desc.RCPT_ADDR}\" {mustBeNotGreater} {max} {symbols5} (RCPT_ADDR)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_ADDR}\" (RCPT_ADDR)") @Size(max=140, message="{fieldLength} \"{desc.RCPT_ADDR}\" {mustBeNotGreater} {max} {symbols5} (RCPT_ADDR)") String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String string) {
        this.recipientAddress = string;
    }

    @d(a="PAYMENT_DETAILS", b=37, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.PAYMENT_DETAILS}\" (PAYMENT_DETAILS)")
    @Size(max=140, message="{fieldLength} \"{desc.PAYMENT_DETAILS}\" {mustBeNotGreater} {max} {symbols5} (PAYMENT_DETAILS)")
    public @NotNull(message="{emptyRequiredField} \"{desc.PAYMENT_DETAILS}\" (PAYMENT_DETAILS)") @Size(max=140, message="{fieldLength} \"{desc.PAYMENT_DETAILS}\" {mustBeNotGreater} {max} {symbols5} (PAYMENT_DETAILS)") String getPaymentDetails() {
        return this.paymentDetails;
    }

    public void setPaymentDetails(String string) {
        this.paymentDetails = string;
    }

    @d(a="EXPENSE_TYPE", b=38, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.EXPENSE_TYPE}\" (EXPENSE_TYPE)")
    public @NotNull(message="{emptyRequiredField} \"{desc.EXPENSE_TYPE}\" (EXPENSE_TYPE)") String getExpenseType() {
        return this.expenseType;
    }

    public void setExpenseType(String string) {
        this.expenseType = string;
    }

    @d(a="EXPENSE_ACCOUNT", b=39, c=false)
    @Iban(fieldName="EXPENSE_ACCOUNT", groups={a.class})
    public String getExpenseAccount() {
        return this.expenseAccount;
    }

    public void setExpenseAccount(String string) {
        this.expenseAccount = string;
    }

    @d(a="PAYMENT_SPEED", b=40, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.PAYMENT_SPEED}\" (PAYMENT_SPEED)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.PAYMENT_SPEED}\" (PAYMENT_SPEED)", groups={a.class}) String getPaymentSpeed() {
        return this.paymentSpeed;
    }

    public void setPaymentSpeed(String string) {
        this.paymentSpeed = string;
    }

    @d(a="PAYMENT_ADDED_INFO", b=41, c=false)
    @Size(max=140, message="{fieldLength} \"{desc.PAYMENT_ADDED_INFO}\" {mustBeNotGreater} {max} {symbols5} (PAYMENT_ADDED_INFO)")
    public @Size(max=140, message="{fieldLength} \"{desc.PAYMENT_ADDED_INFO}\" {mustBeNotGreater} {max} {symbols5} (PAYMENT_ADDED_INFO)") String getPaymentAdditionalInfo() {
        return this.paymentAdditionalInfo;
    }

    public void setPaymentAdditionalInfo(String string) {
        this.paymentAdditionalInfo = string;
    }

    @d(a="CLN_OKPO", b=42, c=false)
    public String getClientCode() {
        return this.clientCode;
    }

    public void setClientCode(String string) {
        this.clientCode = string;
    }

    @d(a="RCPT_BNK_IBAN", b=43, c=false)
    @Size(max=35, message="{fieldLength} \"{desc.RCPT_BNK_IBAN}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_IBAN)")
    public @Size(max=35, message="{fieldLength} \"{desc.RCPT_BNK_IBAN}\" {mustBeNotGreater} {max} {symbols5} (RCPT_BNK_IBAN)") String getRecipientBankIban() {
        return this.recipientBankIban;
    }

    public void setRecipientBankIban(String string) {
        this.recipientBankIban = string;
    }

    @d(a="INTERMED_BNK_COUNTRY_CODE", b=44, c=false)
    public String getIntermediaryBankCountryCode() {
        return this.intermediaryBankCountryCode;
    }

    public void setIntermediaryBankCountryCode(String string) {
        this.intermediaryBankCountryCode = string;
    }

    @d(a="RCPT_BNK_COUNTRY_CODE", b=45, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_COUNTRY_CODE}\" (RCPT_BNK_COUNTRY_CODE)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_BNK_COUNTRY_CODE}\" (RCPT_BNK_COUNTRY_CODE)", groups={a.class}) String getRecipientBankCountryCode() {
        return this.recipientBankCountryCode;
    }

    public void setRecipientBankCountryCode(String string) {
        this.recipientBankCountryCode = string;
    }

    @d(a="RCPT_COUNTRY_CODE", b=46, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_COUNTRY_CODE}\" (RCPT_COUNTRY_CODE)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_COUNTRY_CODE}\" (RCPT_COUNTRY_CODE)") String getRecipientCountryCode() {
        return this.recipientCountryCode;
    }

    public void setRecipientCountryCode(String string) {
        this.recipientCountryCode = string;
    }

    @d(a="INTERMED_BNK_ACCOUNT", b=47, c=false)
    @Size(max=50, message="{fieldLength} \"{desc.INTERMED_BNK_ACCOUNT}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_ACCOUNT)")
    public @Size(max=50, message="{fieldLength} \"{desc.INTERMED_BNK_ACCOUNT}\" {mustBeNotGreater} {max} {symbols5} (INTERMED_BNK_ACCOUNT)") String getIntermediaryBankAccount() {
        return this.intermediaryBankAccount;
    }

    public void setIntermediaryBankAccount(String string) {
        this.intermediaryBankAccount = string;
    }

    @d(a="CLN_BNK_MFO", b=48, c=false)
    public String getClientBankCode() {
        return this.clientBankCode;
    }

    public void setClientBankCode(String string) {
        this.clientBankCode = string;
    }

    @d(a="OPCODE", b=49)
    @NotNull(message="{emptyRequiredField} \"{desc.OPCODE}\" (OPCODE)", groups={a.class})
    @Size(max=4, message="{fieldLength} \"{desc.OPCODE}\" {mustBeNotGreater} {max} {symbols3} (OPCODE)")
    public @NotNull(message="{emptyRequiredField} \"{desc.OPCODE}\" (OPCODE)", groups={a.class}) @Size(max=4, message="{fieldLength} \"{desc.OPCODE}\" {mustBeNotGreater} {max} {symbols3} (OPCODE)") String getOperationCode() {
        return this.operationCode;
    }

    public void setOperationCode(String string) {
        this.operationCode = string;
    }

    @d(a="CLN_RESIDENT", b=50)
    public Boolean getClientResident() {
        return this.clientResident;
    }

    public void setClientResident(Boolean bl) {
        this.clientResident = bl;
    }

    @d(a="RCPT_RESIDENT", b=51)
    public Boolean getRecipientResident() {
        return this.recipientResident;
    }

    public void setRecipientResident(Boolean bl) {
        this.recipientResident = bl;
    }

    @d(a="CLN_NAME_UKR", b=52)
    public String getClientNameUkrainian() {
        return this.clientNameUkrainian;
    }

    public void setClientNameUkrainian(String string) {
        this.clientNameUkrainian = string;
    }

    @d(a="CLN_ADDR_UKR", b=53)
    public String getClientAddressUkrainian() {
        return this.clientAddressUkrainian;
    }

    public void setClientAddressUkrainian(String string) {
        this.clientAddressUkrainian = string;
    }

    @d(a="CLN_BNK_NAME_UKR", b=54)
    @Size(max=140, message="{fieldLength} \"{desc.CLN_BNK_NAME_UKR}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_NAME_UKR)")
    public @Size(max=140, message="{fieldLength} \"{desc.CLN_BNK_NAME_UKR}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_NAME_UKR)") String getClientBankNameUkrainian() {
        return this.clientBankNameUkrainian;
    }

    public void setClientBankNameUkrainian(String string) {
        this.clientBankNameUkrainian = string;
    }

    @d(a="CLN_BNK_ADDR_UKR", b=55)
    @Size(max=140, message="{fieldLength} \"{desc.CLN_BNK_ADDR_UKR}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_ADDR_UKR)")
    public @Size(max=140, message="{fieldLength} \"{desc.CLN_BNK_ADDR_UKR}\" {mustBeNotGreater} {max} {symbols5} (CLN_BNK_ADDR_UKR)") String getClientBankAddressUkrainian() {
        return this.clientBankAddressUkrainian;
    }

    public void setClientBankAddressUkrainian(String string) {
        this.clientBankAddressUkrainian = string;
    }

    @d(a="COMMISSION_BNK_NAME", b=56)
    public String getCommissionBankName() {
        return this.commissionBankName;
    }

    public void setCommissionBankName(String string) {
        this.commissionBankName = string;
    }

    @d(a="COMMISSION_BNK_MFO", b=57)
    public String getCommissionBankCode() {
        return this.commissionBankCode;
    }

    public void setCommissionBankCode(String string) {
        this.commissionBankCode = string;
    }

    @d(a="RCPT_ITN", b=58)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_ITN}\" (RCPT_ITN)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_ITN}\" (RCPT_ITN)", groups={a.class}) String getRecipientItn() {
        return this.recipientItn;
    }

    public void setRecipientItn(String string) {
        this.recipientItn = string;
    }

    @d(a="ATT_CNT", b=59)
    public Integer getAttachmentsCount() {
        return this.attachmentsCount;
    }

    public void setAttachmentsCount(Integer n2) {
        this.attachmentsCount = n2;
    }

    @d(a="MONEY_SOURCE", b=60)
    @NotNull(message="{emptyRequiredField} \"{desc.MONEY_SOURCE}\" (MONEY_SOURCE)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.MONEY_SOURCE}\" (MONEY_SOURCE)", groups={a.class}) Integer getMoneySource() {
        return this.moneySource;
    }

    public void setMoneySource(Integer n2) {
        this.moneySource = n2;
    }

    @d(a="PURPOSE_CODE", b=61)
    @NotNull(message="{emptyRequiredField} \"{desc.PURPOSE_CODE}\" (PURPOSE_CODE)", groups={a.class})
    @Size(max=105, message="{fieldLength} \"{desc.PURPOSE_CODE}\" {mustBeNotGreater} {max} {symbols5} (PURPOSE_CODE)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.PURPOSE_CODE}\" (PURPOSE_CODE)", groups={a.class}) @Size(max=105, message="{fieldLength} \"{desc.PURPOSE_CODE}\" {mustBeNotGreater} {max} {symbols5} (PURPOSE_CODE)", groups={a.class}) String getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurposeCode(String string) {
        this.purposeCode = string;
    }

    @d(a="OPER_TYPE_CODE", b=62)
    @Pattern(regexp="S(0[1-9]|1[0-9]|20)", message="{fieldFillingError} \"{desc.OPER_TYPE_CODE}\" (OPER_TYPE_CODE)")
    public @Pattern(regexp="S(0[1-9]|1[0-9]|20)", message="{fieldFillingError} \"{desc.OPER_TYPE_CODE}\" (OPER_TYPE_CODE)") String getOperationTypeCode() {
        return this.operationTypeCode;
    }

    public void setOperationTypeCode(String string) {
        this.operationTypeCode = string;
    }

    @d(a="MANDATORY_REPORT", b=63)
    public String getMandatoryReport() {
        return this.mandatoryReport;
    }

    public void setMandatoryReport(String string) {
        this.mandatoryReport = string;
    }

    @d(a="CLN_POSTCODE", b=64)
    public String getClientPostcode() {
        return this.clientPostcode;
    }

    public void setClientPostcode(String string) {
        this.clientPostcode = string;
    }

    @Override
    @JsonIgnore
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l2) {
        this.id = l2;
    }

    @Override
    public String toIBank2(boolean bl) {
        return UA_CURRENCY_PAYMENT_WRITER.a(this, bl);
    }

    @Override
    @JsonIgnore
    public String getType() {
        return "ua_currency_payment";
    }

    @Override
    @JsonIgnore
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void setStatusCode(Integer n2) {
        this.statusCode = n2;
    }
}

