/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app.ua_currency_payment;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.AggregateResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ua.com.dbosoft.autoclient.app.K;
import ua.com.dbosoft.autoclient.app.RequestSender;
import ua.com.dbosoft.autoclient.app.ValidatorFactoryRegistry;
import ua.com.dbosoft.autoclient.app.account.Account;
import ua.com.dbosoft.autoclient.app.account.b;
import ua.com.dbosoft.autoclient.app.bank.swift.Swift;
import ua.com.dbosoft.autoclient.app.bank.ua_swift.UaSwift;
import ua.com.dbosoft.autoclient.app.branch.BankBranch;
import ua.com.dbosoft.autoclient.app.client.Client;
import ua.com.dbosoft.autoclient.app.country.Country;
import ua.com.dbosoft.autoclient.app.currency.Currency;
import ua.com.dbosoft.autoclient.app.dao.RepositoryManager;
import ua.com.dbosoft.autoclient.app.dto.DocumentTemplate;
import ua.com.dbosoft.autoclient.app.ua_currency_payment.MandatoryReport;
import ua.com.dbosoft.autoclient.app.ua_currency_payment.OperationCode;
import ua.com.dbosoft.autoclient.app.ua_currency_payment.UaCurrencyPayment;
import ua.com.dbosoft.autoclient.app.ua_currency_payment.c;
import ua.com.dbosoft.autoclient.app.ua_currency_payment.f;
import ua.com.dbosoft.autoclient.app.ua_currency_payment.g;
import ua.com.dbosoft.autoclient.app.ua_currency_payment.h;
import ua.com.dbosoft.autoclient.app.validation.a;

public class UaCurrencyPaymentImporter {
    private static final Logger a = LoggerFactory.getLogger(UaCurrencyPaymentImporter.class);
    private static final Pattern b = Pattern.compile("[^A-Z\\d\\s\\r\\n/\\-?:().,'+]", 66);
    private static final Pattern c = Pattern.compile("[^A-Z\u0410-\u042f\u0401\\d\\s\\r\\n/\\-?:().,'\"+]", 66);
    private static final Pattern d = Pattern.compile("^\\d+$");
    private static final Pattern e = Pattern.compile("^\\(VO\\d{5}\\).*");
    private final RepositoryManager f;
    private final RequestSender g;
    private final Validator h;

    public UaCurrencyPaymentImporter(RepositoryManager object, RequestSender object2, ValidatorFactoryRegistry validatorFactoryRegistry) {
        this.f = object;
        this.g = object2;
        object = validatorFactoryRegistry;
        object2 = UaCurrencyPaymentImporter.class.getCanonicalName();
        validatorFactoryRegistry = ((ValidatorFactoryRegistry)object).a((String)object2);
        if (validatorFactoryRegistry == null) {
            validatorFactoryRegistry = new AggregateResourceBundleLocator(Arrays.asList("ua/com/dbosoft/autoclient/app/account/account", "ua/com/dbosoft/autoclient/app/ua_currency_payment/fieldDescription", "ua/com/dbosoft/autoclient/app/ua_currency_payment/validationMessages"));
            validatorFactoryRegistry = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)validatorFactoryRegistry)).buildValidatorFactory();
            ((ValidatorFactoryRegistry)object).a((String)object2, (ValidatorFactory)validatorFactoryRegistry);
        }
        this.h = validatorFactoryRegistry.getValidator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importDocument(UaCurrencyPayment object) {
        Object object2;
        Object object3;
        Object object4 = object;
        Object object5 = this;
        Object object6 = object4;
        Object object7 = object5;
        Object object8 = ((UaCurrencyPayment)object6).getDate();
        if (object8 != null) {
            int n2;
            object3 = ((UaCurrencyPaymentImporter)object7).f.m().a().toLocalDate();
            object6 = ((LocalDate)object3).minusDays(n2 = ((UaCurrencyPaymentImporter)object7).a("documents.work.backdate", 0).intValue());
            if (((LocalDate)object8).isBefore((ChronoLocalDate)object6)) {
                throw new RuntimeException(String.format(UaCurrencyPaymentImporter.e("docDateIsLessThanAllowed"), object6, "DATE_DOC"));
            }
            n2 = ((UaCurrencyPaymentImporter)object7).a("documents.work.futuredate", 0);
            object2 = ((LocalDate)object3).plusDays(n2);
            if (((LocalDate)object8).isAfter((ChronoLocalDate)object2)) {
                throw new RuntimeException(String.format(UaCurrencyPaymentImporter.e("docDateIsMoreThanAllowed"), object6, "DATE_DOC"));
            }
        }
        if (((UaCurrencyPayment)object4).getNumber() == null || ((UaCurrencyPayment)object4).getDate() == null) {
            object2 = ((UaCurrencyPaymentImporter)object5).g.a("ua_currency_payment");
            if (((UaCurrencyPayment)object4).getNumber() == null) {
                if (((DocumentTemplate)object2).getNumber().isEmpty()) {
                    throw new RuntimeException(UaCurrencyPaymentImporter.e("docNumCannotBeGeneratedAutomatically"));
                }
                ((UaCurrencyPayment)object4).setNumber(((DocumentTemplate)object2).getNumber());
            }
            if (((UaCurrencyPayment)object4).getDate() == null) {
                ((UaCurrencyPayment)object4).setDate(((DocumentTemplate)object2).getDate());
            }
        }
        UaCurrencyPaymentImporter.a(this.h.validate(object, new Class[0]));
        object4 = object;
        object5 = this;
        object2 = UaCurrencyPaymentImporter.a((UaCurrencyPayment)object4);
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getIntermediaryBankAddress(), (Pattern)object2, "INTERMED_BNK_ADDR");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getIntermediaryBankCity(), (Pattern)object2, "INTERMED_BNK_CITY");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getIntermediaryBankName(), (Pattern)object2, "INTERMED_BNK_NAME");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getPaymentAdditionalInfo(), (Pattern)object2, "PAYMENT_ADDED_INFO");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getPaymentDetails(), (Pattern)object2, "PAYMENT_DETAILS");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getRecipientBankAddress(), (Pattern)object2, "RCPT_BNK_ADDR");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getRecipientBankCity(), (Pattern)object2, "RCPT_BNK_CITY");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getRecipientBankName(), (Pattern)object2, "RCPT_BNK_NAME");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getRecipientAddress(), (Pattern)object2, "RCPT_ADDR");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getRecipientCity(), (Pattern)object2, "RCPT_CITY");
        ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getRecipientName(), (Pattern)object2, "RCPT_NAME");
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPaymentImporter)object5).f.g().a(((UaCurrencyPayment)object4).getCurrency());
        if (object2 == null) {
            throw new RuntimeException(String.format(UaCurrencyPaymentImporter.e("currencyNotFound"), ((UaCurrencyPayment)object4).getCurrency(), "AMOUNT_CURRENCY"));
        }
        ((UaCurrencyPayment)object4).setCurrencyCode(((Currency)object2).getThreeDigitCode());
        List<Account> list = object;
        ((UaCurrencyPayment)((Object)list)).setAmount(((UaCurrencyPayment)((Object)list)).getAmount().setScale(6, RoundingMode.HALF_UP));
        this.a((UaCurrencyPayment)object, "amount");
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPayment)object4).getClientAccount();
        object6 = ((UaCurrencyPayment)object4).getCurrency();
        if (((String)object2).length() == 29) {
            object7 = ((UaCurrencyPaymentImporter)object5).f.a().a((String)object2).stream().filter(arg_0 -> UaCurrencyPaymentImporter.b((String)object6, arg_0)).findAny().orElseThrow(() -> this.b("acc_not_belong_to_the_client"));
            ((UaCurrencyPaymentImporter)object5).a(((Account)object7).getPermission(), "CLN_ACCOUNT");
            ((UaCurrencyPaymentImporter)object5).a(((Account)object7).getType(), "CLN_ACCOUNT");
        } else {
            object7 = ((UaCurrencyPaymentImporter)object5).d((String)object2, (String)object6).orElseThrow(() -> this.b("wrong_iban_length"));
            ((UaCurrencyPayment)object4).setClientAccount(((Account)object7).getIban());
        }
        ((UaCurrencyPaymentImporter)object5).a(((Account)object7).getStatus(), "CLN_ACCOUNT");
        List<Account> list2 = object;
        ((UaCurrencyPayment)((Object)list2)).setClientBankCode(((UaCurrencyPayment)((Object)list2)).getClientAccount().substring(4, 10));
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPaymentImporter)object5).f.e().a();
        ((UaCurrencyPayment)object4).setClientPostcode(((Client)object2).getPostcode());
        ((UaCurrencyPayment)object4).setClientAddressUkrainian(UaCurrencyPaymentImporter.a(((Client)object2).getAddress(), 140));
        ((UaCurrencyPayment)object4).setClientAddress(((Client)object2).getAddressLatin());
        object8 = object4;
        object6 = object5;
        if (((UaCurrencyPayment)object8).getClientBankBicType() == null) {
            ((UaCurrencyPayment)object8).setClientBankBicType("SWIFT");
        } else if (!((UaCurrencyPayment)object8).getClientBankBicType().equals("SWIFT")) {
            object4 = "CLN_BNK_BIC_TYPE";
            object5 = "fieldFillingError";
            object = object6;
            throw super.a((String)object5, (String)object4, false);
        }
        ((UaCurrencyPayment)object4).setClientCity("RUB".equals(((UaCurrencyPayment)object4).getCurrency()) ? null : ((Client)object2).getCityEng());
        ((UaCurrencyPayment)object4).setClientName(((Client)object2).getNameEng());
        ((UaCurrencyPayment)object4).setClientNameUkrainian(((Client)object2).getName());
        ((UaCurrencyPayment)object4).setClientCode(((Client)object2).getCode());
        ((UaCurrencyPayment)object4).setClientBankCountry("UKRAINE");
        if ("RUB".equals(((UaCurrencyPayment)object4).getCurrency())) {
            object8 = ((UaCurrencyPayment)object4).getClientBankCode();
            object6 = object5;
            object3 = new g();
            object7 = ((g)object3).a(((UaCurrencyPaymentImporter)object6).f.c(), (String)object8) && ((g)object3).a(((UaCurrencyPaymentImporter)object6).f.e().a()) ? object3 : null;
            if (object7 != null) {
                ((UaCurrencyPayment)object4).setClientName(((g)object7).f());
                ((UaCurrencyPayment)object4).setClientAddress(((g)object7).d());
                ((UaCurrencyPayment)object4).setClientCity(((g)object7).e());
                ((UaCurrencyPayment)object4).setClientBankName(((g)object7).c());
                ((UaCurrencyPayment)object4).setClientBankAddress(((g)object7).a());
                ((UaCurrencyPayment)object4).setClientBankCity(((g)object7).b());
                ((UaCurrencyPayment)object4).setClientBankCountry("\u0423\u041a\u0420\u0410\u0418\u041d\u0410");
            }
        } else {
            object7 = ((UaCurrencyPaymentImporter)object5).f.b().a(((UaCurrencyPayment)object4).getClientBankCode());
            if (object7 != null) {
                object3 = object7;
                object8 = object4;
                object6 = object5;
                ((UaCurrencyPayment)object8).setClientBankAddress(((BankBranch)object3).getAddressLatin());
                ((UaCurrencyPayment)object8).setClientBankCity(((BankBranch)object3).getCityLatin());
                ((UaCurrencyPayment)object8).setClientBankName(((BankBranch)object3).getEngName());
                ((UaCurrencyPayment)object8).setClientBankNameUkrainian(((BankBranch)object3).getName());
                ((UaCurrencyPayment)object8).setClientBankAddressUkrainian(UaCurrencyPaymentImporter.a(((BankBranch)object3).getAddress(), 140));
                ((UaCurrencyPayment)object4).setRecipientItn(null);
            }
        }
        super.a((UaCurrencyPayment)object4, "clientBankAddress", "clientBankCity", "clientBankName");
        object3 = object2;
        object8 = object4;
        object6 = object5;
        object2 = ((UaCurrencyPaymentImporter)object6).f.f().a(((Client)object3).getCountryCode());
        if (object2 != null) {
            if (((UaCurrencyPayment)object8).getCurrency().equals("RUB")) {
                ((UaCurrencyPayment)object8).setClientCountry(((Country)object2).getRuName());
            } else {
                ((UaCurrencyPayment)object8).setClientCountry(((Country)object2).getEngName());
            }
        }
        super.a((UaCurrencyPayment)object8, "clientCountry");
        object4 = object;
        object5 = this;
        object2 = UaCurrencyPaymentImporter.c(((UaCurrencyPayment)object4).getExpenseType());
        if (object2 == null || ua.com.dbosoft.autoclient.app.ua_currency_payment.c.b.equals(object2) && super.a("documents.ua_currency_payment.guaranteed_our_hide", true)) {
            Object object9 = object5;
            object4 = "EXPENSE_TYPE";
            object5 = "fieldFillingError";
            object = object9;
            throw super.a((String)object5, (String)object4, false);
        }
        object7 = object2;
        ((UaCurrencyPayment)object4).setExpenseType(ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_payment/expenseType").getString(((Enum)object7).name() + ".dbValue"));
        object2 = object5 = object2;
        object4 = object;
        object5 = this;
        object7 = ((UaCurrencyPayment)object4).getExpenseAccount();
        if (ua.com.dbosoft.autoclient.app.ua_currency_payment.c.a.equals(object2)) {
            if (object7 != null) {
                throw super.a("fieldMustBeEmpty", "EXPENSE_ACCOUNT", true);
            }
        } else {
            if (object7 == null) {
                Object object10 = object5;
                object4 = "EXPENSE_ACCOUNT";
                object5 = "emptyRequiredField";
                object = object10;
                throw super.a((String)object5, (String)object4, false);
            }
            if (((String)object7).length() != 29 && (object6 = (Account)super.d((String)object7, "UAH").orElse(null)) != null) {
                super.a(((Account)object6).getStatus(), "EXPENSE_ACCOUNT");
                ((UaCurrencyPayment)object4).setExpenseAccount(((Account)object6).getIban());
            } else {
                object2 = ((UaCurrencyPayment)object4).getExpenseAccount();
                object3 = object5;
                object6 = ((UaCurrencyPaymentImporter)object3).f.a();
                object6 = ((String)object2).length() == 29 ? object6.a((String)object2) : object6.b((String)object2);
                if (object6.isEmpty()) {
                    super.a((UaCurrencyPayment)object4, "expenseAccount");
                } else {
                    object8 = object6.stream().filter(account -> account.getCurrency().equals("UAH")).findAny().orElseThrow(() -> this.a("foreignAccCurrencyForbidden", "EXPENSE_ACCOUNT", true));
                    super.a(((Account)object8).getPermission(), "EXPENSE_ACCOUNT");
                    super.a(((Account)object8).getType(), "EXPENSE_ACCOUNT");
                    super.a(((Account)object8).getStatus(), "EXPENSE_ACCOUNT");
                }
            }
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPayment)object4).getExpenseAccount() == null) {
            ((UaCurrencyPayment)object4).setCommissionBankCode(null);
            ((UaCurrencyPayment)object4).setCommissionBankName(null);
        } else {
            List<Account> list3 = object4;
            ((UaCurrencyPayment)((Object)list3)).setCommissionBankCode(((UaCurrencyPayment)((Object)list3)).getExpenseAccount().substring(4, 10));
            object2 = ((UaCurrencyPaymentImporter)object5).f.p().a(((UaCurrencyPayment)object4).getCommissionBankCode());
            if (object2 == null) {
                throw super.h("bankCodeNotFound", "EXPENSE_ACCOUNT");
            }
            ((UaCurrencyPayment)object4).setCommissionBankName(((UaSwift)object2).getName());
        }
        object4 = object;
        object5 = this;
        if ("off".equals(super.g("documents.ua_currency_payment.payment_urgency_choice.hide", null))) {
            ((UaCurrencyPayment)object4).setPaymentSpeed(null);
        } else {
            super.a((UaCurrencyPayment)object4, "paymentSpeed");
            object2 = UaCurrencyPaymentImporter.d(((UaCurrencyPayment)object4).getPaymentSpeed());
            if (object2 == null) {
                Object object11 = object5;
                object4 = "PAYMENT_SPEED";
                object5 = "fieldFillingError";
                object = object11;
                throw super.a((String)object5, (String)object4, false);
            }
            object7 = object2;
            ((UaCurrencyPayment)object4).setPaymentSpeed(ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_payment/paymentSpeed").getString(((Enum)object7).name() + ".dbValue"));
        }
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPaymentImporter)object5).a(((UaCurrencyPayment)object4).getRecipientCountryCode(), "RCPT_COUNTRY_CODE");
        if (((UaCurrencyPayment)object4).getCurrency().equals("RUB")) {
            ((UaCurrencyPayment)object4).setRecipientCountry(((Country)object2).getRuName());
        } else {
            ((UaCurrencyPayment)object4).setRecipientCountry(((Country)object2).getEngName());
        }
        object4 = object;
        object5 = this;
        if (!((UaCurrencyPaymentImporter)object5).a("documents.ua_currency_payment.money_source.option", false)) {
            ((UaCurrencyPayment)object4).setMoneySource(null);
        } else {
            super.a((UaCurrencyPayment)object4, "moneySource");
            object2 = ((UaCurrencyPaymentImporter)object5).f.i().a();
            int n3 = ((UaCurrencyPayment)object4).getMoneySource();
            object2.stream().filter(moneySource -> moneySource.getCode() != null && moneySource.getCode() == n3).findAny().orElseThrow(() -> {
                String string = "MONEY_SOURCE";
                String string2 = "fieldFillingError";
                UaCurrencyPaymentImporter uaCurrencyPaymentImporter = this;
                return uaCurrencyPaymentImporter.a(string2, string, false);
            });
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPayment)object4).getCurrency().equals("RUB")) {
            if (((UaCurrencyPayment)object4).getOperationTypeCode() == null) {
                ((UaCurrencyPayment)object4).setMandatoryReport(null);
            } else if (((UaCurrencyPayment)object4).getMandatoryReport() != null) {
                object2 = new MandatoryReport();
                ((MandatoryReport)object2).parse(((UaCurrencyPayment)object4).getMandatoryReport());
                UaCurrencyPaymentImporter.a(((UaCurrencyPaymentImporter)object5).h.validate(object2, new Class[0]));
            }
        } else {
            ((UaCurrencyPayment)object4).setOperationTypeCode(null);
            ((UaCurrencyPayment)object4).setMandatoryReport(null);
        }
        object4 = object;
        object5 = this;
        if ("CLEAR_CODE".equals(((UaCurrencyPayment)object4).getRecipientBankBicType())) {
            if (((UaCurrencyPayment)object4).getCurrency().equals("RUB") || ((UaCurrencyPayment)object4).getCurrency().equals("RUR")) {
                super.c(((UaCurrencyPayment)object4).getRecipientBankBic(), "RCPT_BNK_BIC");
            }
            super.a((UaCurrencyPayment)object4, "recipientBankCountryCode");
            object2 = super.a(((UaCurrencyPayment)object4).getRecipientBankCountryCode(), "RCPT_BNK_COUNTRY_CODE");
            UaCurrencyPaymentImporter.a((UaCurrencyPayment)object4, (Country)object2);
        } else if ("SWIFT".equals(((UaCurrencyPayment)object4).getRecipientBankBicType())) {
            Object object12 = object5;
            object6 = object4;
            object8 = ((UaCurrencyPayment)object6).getRecipientBankBic();
            object3 = super.b((String)object8, "RCPT_BNK_BIC");
            if (((Swift)object3).getCountryCode() != null) {
                object2 = super.a(((Swift)object3).getCountryCode(), "RCPT_BNK_COUNTRY_CODE");
                ((UaCurrencyPayment)object6).setRecipientBankCountryCode(((Swift)object3).getCountryCode());
            } else {
                object2 = ((UaCurrencyPaymentImporter)object12).f.f().b(((String)object8).substring(4, 6));
                if (object2 != null) {
                    ((UaCurrencyPayment)object6).setRecipientBankCountryCode(((Country)object2).getNumeric3Code());
                } else {
                    super.a((UaCurrencyPayment)object6, "recipientBankCountryCode");
                    super.a(((UaCurrencyPayment)object6).getRecipientBankCountryCode(), "RCPT_BNK_COUNTRY_CODE");
                }
            }
            UaCurrencyPaymentImporter.a((UaCurrencyPayment)object6, (Country)object2);
        }
        object4 = object;
        object5 = this;
        if ("784".equals(((UaCurrencyPayment)object4).getRecipientCountryCode()) || "784".equals(((UaCurrencyPayment)object4).getRecipientBankCountryCode())) {
            super.a((UaCurrencyPayment)object4, "purposeCode");
        } else {
            ((UaCurrencyPayment)object4).setPurposeCode(null);
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPayment)object4).getIntermediaryBankBic() == null || ((UaCurrencyPayment)object4).getIntermediaryBankBicType() == null || "CLEAR_CODE".equals(((UaCurrencyPayment)object4).getIntermediaryBankBicType())) {
            if (((UaCurrencyPayment)object4).getIntermediaryBankBic() != null && (((UaCurrencyPayment)object4).getCurrency().equals("RUB") || ((UaCurrencyPayment)object4).getCurrency().equals("RUR"))) {
                super.c(((UaCurrencyPayment)object4).getIntermediaryBankBic(), "INTERMED_BNK_BIC");
            }
            if (((UaCurrencyPayment)object4).getIntermediaryBankCountryCode() != null) {
                object2 = super.a(((UaCurrencyPayment)object4).getIntermediaryBankCountryCode(), "INTERMED_BNK_COUNTRY_CODE");
                UaCurrencyPaymentImporter.b((UaCurrencyPayment)object4, (Country)object2);
            } else if (((UaCurrencyPayment)object4).getIntermediaryBankCountry() != null) {
                object6 = object4;
                Object object13 = object5;
                super.a((UaCurrencyPayment)object6, "intermediaryBankCountry");
                super.a(((UaCurrencyPayment)object6).getIntermediaryBankCountry(), UaCurrencyPaymentImporter.a((UaCurrencyPayment)object6), "INTERMED_BNK_COUNTRY");
                object8 = ((UaCurrencyPayment)object6).getIntermediaryBankCountry();
                object3 = ((String)object8).toUpperCase();
                object2 = ((UaCurrencyPaymentImporter)object13).f.f().a().stream().filter(arg_0 -> UaCurrencyPaymentImporter.a((String)object3, arg_0)).findAny();
                if (!((Optional)object2).isPresent()) throw new RuntimeException(String.format(UaCurrencyPaymentImporter.e("countryNameNotFound"), object8, "INTERMED_BNK_COUNTRY"));
                ((UaCurrencyPayment)object6).setIntermediaryBankCountryCode(((Country)((Optional)object2).get()).getNumeric3Code());
                ((UaCurrencyPayment)object6).setIntermediaryBankCountry((String)object3);
            }
        } else if ("SWIFT".equals(((UaCurrencyPayment)object4).getIntermediaryBankBicType())) {
            Object object14 = object5;
            object6 = object4;
            object8 = ((UaCurrencyPayment)object6).getIntermediaryBankBic();
            object3 = super.b((String)object8, "INTERMED_BNK_BIC");
            if (((Swift)object3).getCountryCode() != null) {
                ((UaCurrencyPayment)object6).setIntermediaryBankCountryCode(((Swift)object3).getCountryCode());
                object2 = super.a(((Swift)object3).getCountryCode(), "INTERMED_BNK_COUNTRY_CODE");
            } else {
                object2 = ((UaCurrencyPaymentImporter)object14).f.f().b(((String)object8).substring(4, 6));
                if (object2 != null) {
                    ((UaCurrencyPayment)object6).setIntermediaryBankCountryCode(((Country)object2).getNumeric3Code());
                } else {
                    ((UaCurrencyPayment)object6).setIntermediaryBankCountryCode(null);
                }
            }
            UaCurrencyPaymentImporter.b((UaCurrencyPayment)object6, (Country)object2);
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPaymentImporter)object5).f.o().a("documents.ua_currency_payment.empl_name_phone.option", true)) {
            super.a((UaCurrencyPayment)object4, "clientEmployeeFullName");
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPaymentImporter)object5).f.o().a("documents.ua_currency_payment.empl_name_phone.option", true)) {
            super.a((UaCurrencyPayment)object4, "clientEmployeePhone");
        }
        if (((UaCurrencyPayment)object4).getClientEmployeePhone() != null) {
            object2 = ((UaCurrencyPaymentImporter)object5).f.f().a();
            K k2 = new K();
            k2.a(((UaCurrencyPayment)object4).getClientEmployeePhone(), (List<Country>)object2);
            if (k2.b()) {
                throw super.a("phoneCodeNotFound", "CLN_EMPLOYEE_PHONE", true);
            }
            if (!k2.a()) {
                Object object15 = object5;
                object4 = "CLN_EMPLOYEE_PHONE";
                object5 = "fieldFillingError";
                object = object15;
                throw super.a((String)object5, (String)object4, false);
            }
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPayment)object4).getCurrencyDate() != null) {
            object2 = ((UaCurrencyPayment)object4).getDate();
            if (((UaCurrencyPayment)object4).getCurrencyDate().isBefore((ChronoLocalDate)object2)) {
                ((UaCurrencyPayment)object4).setCurrencyDate(null);
            } else {
                Integer n4 = super.f(((UaCurrencyPayment)object4).getClientBankCode(), "ua_currency_payment.value_date.limit");
                if (n4 != null && ((UaCurrencyPayment)object4).getCurrencyDate().isAfter(((LocalDate)object2).plusDays(n4.intValue()))) {
                    throw new RuntimeException(String.format(UaCurrencyPaymentImporter.e("currencyDateUpperLimitExceeded"), n4, "CURRENCY_DATE"));
                }
            }
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPayment)object4).getRecipientAccount() == null == (((UaCurrencyPayment)object4).getRecipientBankIban() == null)) {
            throw super.a("mustBeFilledOnlyRcptAccOrIBAN", "RCPT_ACCOUNT", true);
        }
        object2 = ((UaCurrencyPayment)object4).getRecipientAccount();
        if (object2 != null && "RUB".equals(((UaCurrencyPayment)object4).getCurrency()) && !"SWIFT".equals(((UaCurrencyPayment)object4).getRecipientBankBicType())) {
            super.e((String)object2, "RCPT_ACCOUNT");
            if (((String)object2).length() != 20) {
                throw new RuntimeException(String.format(UaCurrencyPaymentImporter.e("fieldLengthMustBe"), UaCurrencyPaymentImporter.g("RCPT_ACCOUNT"), "20", "RCPT_ACCOUNT"));
            }
        }
        object4 = object;
        object5 = this;
        if ("RUB".equals(((UaCurrencyPayment)object4).getCurrency())) {
            object2 = ((UaCurrencyPayment)object4).getPaymentDetails();
            if (!e.matcher((CharSequence)object2).matches()) {
                throw super.a("rubOperationCodeError", "PAYMENT_DETAILS", true);
            }
            if (!((String)object2).endsWith("\u041d\u0414\u0421")) {
                throw super.a("vatInfoError", "PAYMENT_DETAILS", true);
            }
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPaymentImporter)object5).f.o().a("documents.ua_currency_payment.opcode.option", false)) {
            super.a((UaCurrencyPayment)object4, "operationCode");
            object2 = ((UaCurrencyPayment)object4).getOperationCode();
            ((UaCurrencyPaymentImporter)object5).f.j().a().stream().filter(arg_0 -> UaCurrencyPaymentImporter.a((String)object2, arg_0)).findAny().orElseThrow(() -> {
                String string = "OPCODE";
                String string2 = "fieldFillingError";
                UaCurrencyPaymentImporter uaCurrencyPaymentImporter = this;
                return uaCurrencyPaymentImporter.a(string2, string, false);
            });
        }
        object4 = object;
        object5 = this;
        if ("643".equals(((UaCurrencyPayment)object4).getCurrencyCode())) {
            super.a((UaCurrencyPayment)object4, "recipientItn");
        }
        if ((object2 = ((UaCurrencyPayment)object4).getRecipientItn()) != null) {
            super.e((String)object2, "RCPT_ITN");
            if (((String)object2).length() != 10 && ((String)object2).length() != 12) {
                Object object16 = object5;
                object4 = "RCPT_ITN";
                object5 = "fieldFillingError";
                object = object16;
                throw super.a((String)object5, (String)object4, false);
            }
        }
        object4 = object;
        object5 = this;
        if ("643".equals(((UaCurrencyPayment)object4).getCurrencyCode())) {
            super.a((UaCurrencyPayment)object4, "recipientBankAccount");
        }
        ((UaCurrencyPayment)object).setAttachmentsCount(0);
        this.g.a((ua.com.dbosoft.autoclient.app.c)object);
    }

    private Country a(String string, String string2) {
        Object object = this.f.f().a(string);
        if (object == null) {
            object = UaCurrencyPaymentImporter.e("countryCodeNotFound");
            throw new RuntimeException(String.format((String)object, string, string2));
        }
        return object;
    }

    private static void a(UaCurrencyPayment uaCurrencyPayment, Country country) {
        if (country == null) {
            uaCurrencyPayment.setRecipientBankCountry(null);
            return;
        }
        if (uaCurrencyPayment.getCurrency().equals("RUB")) {
            uaCurrencyPayment.setRecipientBankCountry(country.getRuName());
            return;
        }
        uaCurrencyPayment.setRecipientBankCountry(country.getEngName());
    }

    private static void b(UaCurrencyPayment uaCurrencyPayment, Country country) {
        if (country == null) {
            uaCurrencyPayment.setIntermediaryBankCountry(null);
            return;
        }
        if (uaCurrencyPayment.getCurrency().equals("RUB")) {
            uaCurrencyPayment.setIntermediaryBankCountry(country.getRuName());
            return;
        }
        uaCurrencyPayment.setIntermediaryBankCountry(country.getEngName());
    }

    private Swift b(String object, String string) {
        String string2 = object;
        if (((String)object).length() >= 6) {
            if (((String)object).length() == 8) {
                object = (String)object + "XXX";
            }
            if ((object = this.f.n().a((String)object)) != null) {
                return object;
            }
        }
        object = UaCurrencyPaymentImporter.e("swiftNotFound");
        throw new RuntimeException(String.format((String)object, string2, string));
    }

    private void c(String string, String string2) {
        Object object = this.f.l().a(string);
        if (object == null) {
            object = UaCurrencyPaymentImporter.e("ruSwiftNotFound");
            throw new RuntimeException(String.format((String)object, string, string2));
        }
    }

    private Predicate<Account> a(String object) {
        Predicate<Account> predicate = account -> account.getPermission() != null && !account.getPermission().equals((Object)ua.com.dbosoft.autoclient.app.account.f.a);
        boolean bl = this.a();
        Predicate<Account> predicate2 = account -> account.getType().equals((Object)ua.com.dbosoft.autoclient.app.account.c.a) || bl && account.getType().equals((Object)ua.com.dbosoft.autoclient.app.account.c.b);
        Predicate<Account> predicate3 = account -> account.getStatus().equals((Object)ua.com.dbosoft.autoclient.app.account.b.a) || account.getStatus().equals((Object)ua.com.dbosoft.autoclient.app.account.b.c);
        object = arg_0 -> UaCurrencyPaymentImporter.a((String)object, arg_0);
        return object.and(predicate).and(predicate2).and(predicate3);
    }

    private Optional<Account> d(String string, String string2) {
        return this.f.a().b(string).stream().filter(this.a(string2)).findAny();
    }

    private void a(ua.com.dbosoft.autoclient.app.account.f f2, String string) {
        if (f2 == null || f2.equals((Object)ua.com.dbosoft.autoclient.app.account.f.a)) {
            throw this.h("no_permission_for_account_saving", string);
        }
    }

    private void a(ua.com.dbosoft.autoclient.app.account.c object, String string) {
        switch (ua.com.dbosoft.autoclient.app.ua_currency_payment.h.a[object.ordinal()]) {
            case 1: {
                if (!this.a()) {
                    throw this.h("acc_type_must_be_current", string);
                }
            }
            case 2: {
                return;
            }
            case 3: {
                throw this.h("cash_coverage_accs_prohibited_from_writing_off_funds", string);
            }
        }
        object = this.a() ? "acc_type_must_be_current_or_corp" : "acc_type_must_be_current";
        throw this.h((String)object, string);
    }

    private void a(b b2, String string) {
        if (ua.com.dbosoft.autoclient.app.account.b.a.equals((Object)b2) || ua.com.dbosoft.autoclient.app.account.b.b.equals((Object)b2)) {
            throw this.h("acc_is_closed_or_to_read_only", string);
        }
    }

    private RuntimeException b(String string) {
        return new RuntimeException(String.format("%s (%s)", UaCurrencyPaymentImporter.f(string), "CLN_ACCOUNT"));
    }

    private static c c(String string) {
        for (c c2 : ua.com.dbosoft.autoclient.app.ua_currency_payment.c.a()) {
            if (!c2.b().contains(string)) continue;
            return c2;
        }
        return null;
    }

    private static f d(String string) {
        for (f f2 : ua.com.dbosoft.autoclient.app.ua_currency_payment.f.a()) {
            if (!f2.b().contains(string)) continue;
            return f2;
        }
        return null;
    }

    private boolean a() {
        return this.a("documents.currency_documents.enable_corp_accounts", false) && this.a("license.service.corp.cards", false);
    }

    private void e(String string, String string2) {
        if (!d.matcher(string).matches()) {
            throw new RuntimeException(String.format(UaCurrencyPaymentImporter.e("onlyDigitsAllowed"), UaCurrencyPaymentImporter.g(string2), string2));
        }
    }

    private Integer f(String string, String string2) {
        String string3 = this.f.c().a(string, string2);
        if (string3 != null) {
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0431\u0430\u043d\u043a\u0443 \"%s\" \u043c\u0430\u0454 \u0434\u043e\u0440\u0456\u0432\u043d\u044e\u0432\u0430\u0442\u0438 \u0446\u0456\u043b\u043e\u043c\u0443 \u0447\u0438\u0441\u043b\u0443";
                a.debug(String.format(string4, string2, string), (Throwable)numberFormatException);
            }
        }
        return null;
    }

    private boolean a(String string, boolean bl) {
        if ((string = this.g(string, null)) == null) {
            return bl;
        }
        return Boolean.parseBoolean(string);
    }

    private String g(String string, String string2) {
        Object object = this.f.e().a();
        if ((object = ((Client)object).getSpecificProperty(string)) != null) {
            return object;
        }
        return this.f.o().a(string, string2);
    }

    private Integer a(String string, Integer n2) {
        String string2 = this.g(string, null);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = String.format("\u041d\u0435\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"%s\": %s", string, string2);
            a.debug(string, (Throwable)numberFormatException);
            return n2;
        }
    }

    private static Pattern a(UaCurrencyPayment uaCurrencyPayment) {
        if ("RUB".equals(uaCurrencyPayment.getCurrency())) {
            return c;
        }
        return b;
    }

    private void a(String object, Pattern pattern, String string) {
        if (object == null) {
            return;
        }
        if (((Matcher)(object = pattern.matcher((CharSequence)object))).find()) {
            object = String.format(UaCurrencyPaymentImporter.e("fieldContainsInvalidCharacter"), UaCurrencyPaymentImporter.g(string), ((Matcher)object).group(), string);
            throw new RuntimeException((String)object);
        }
    }

    private void a(UaCurrencyPayment uaCurrencyPayment, String ... stringArray) {
        for (String string : stringArray) {
            UaCurrencyPaymentImporter.a(this.h.validateProperty((Object)uaCurrencyPayment, string, new Class[]{a.class}));
        }
    }

    private static <T> void a(Iterable<ConstraintViolation<T>> object) {
        if ((object = object.iterator()).hasNext()) {
            throw new RuntimeException(((ConstraintViolation)object.next()).getMessage());
        }
    }

    private static String e(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_payment/validationMessages").getString(string);
    }

    private RuntimeException a(String string, String string2, boolean bl) {
        if (bl) {
            return new RuntimeException(String.format("%s (%s)", UaCurrencyPaymentImporter.e(string), string2));
        }
        return new RuntimeException(String.format("%s \"%s\" (%s)", UaCurrencyPaymentImporter.e(string), UaCurrencyPaymentImporter.g(string2), string2));
    }

    private RuntimeException h(String string, String string2) {
        return new RuntimeException(String.format("%s (%s)", UaCurrencyPaymentImporter.f(string), string2));
    }

    private static String f(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/account/account").getString(string);
    }

    private static String g(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_payment/fieldDescription").getString("desc." + string);
    }

    private static String a(String string, int n2) {
        if (string.length() > 140) {
            return string.substring(0, 140);
        }
        return string;
    }

    private static /* synthetic */ boolean a(String string, OperationCode operationCode) {
        return string.equals(operationCode.getCode());
    }

    private static /* synthetic */ boolean a(String string, Account account) {
        return account.getIban() != null && string.equals(account.getCurrency());
    }

    private static /* synthetic */ boolean b(String string, Account account) {
        return string.equals(account.getCurrency());
    }

    private static /* synthetic */ boolean a(String string, Country country) {
        return string.equals(country.getRuName()) || string.equals(country.getEngName());
    }
}

