/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app.ua_currency_purchase;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.AggregateResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ua.com.dbosoft.autoclient.app.K;
import ua.com.dbosoft.autoclient.app.RequestSender;
import ua.com.dbosoft.autoclient.app.ValidatorFactoryRegistry;
import ua.com.dbosoft.autoclient.app.account.Account;
import ua.com.dbosoft.autoclient.app.account.f;
import ua.com.dbosoft.autoclient.app.bank.ua_swift.UaSwift;
import ua.com.dbosoft.autoclient.app.branch.BankBranch;
import ua.com.dbosoft.autoclient.app.client.Client;
import ua.com.dbosoft.autoclient.app.country.Country;
import ua.com.dbosoft.autoclient.app.dao.RepositoryManager;
import ua.com.dbosoft.autoclient.app.dto.DocumentTemplate;
import ua.com.dbosoft.autoclient.app.ua_currency_purchase.UaCurrencyPurchase;
import ua.com.dbosoft.autoclient.app.ua_currency_purchase.a;
import ua.com.dbosoft.autoclient.app.ua_currency_purchase.b;
import ua.com.dbosoft.autoclient.app.ua_currency_purchase.c;
import ua.com.dbosoft.autoclient.app.ua_currency_purchase.d;

public class UaCurrencyPurchaseImporter {
    private static final Logger a = LoggerFactory.getLogger(UaCurrencyPurchaseImporter.class);
    private final RepositoryManager b;
    private final RequestSender c;
    private final Validator d;

    public UaCurrencyPurchaseImporter(RepositoryManager object, RequestSender object2, ValidatorFactoryRegistry validatorFactoryRegistry) {
        this.b = object;
        this.c = object2;
        object = validatorFactoryRegistry;
        object2 = UaCurrencyPurchaseImporter.class.getCanonicalName();
        validatorFactoryRegistry = ((ValidatorFactoryRegistry)object).a((String)object2);
        if (validatorFactoryRegistry == null) {
            validatorFactoryRegistry = new AggregateResourceBundleLocator(Arrays.asList("ua/com/dbosoft/autoclient/app/account/account", "ua/com/dbosoft/autoclient/app/ua_currency_purchase/fieldDescription", "ua/com/dbosoft/autoclient/app/ua_currency_purchase/validationMessages"));
            validatorFactoryRegistry = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)validatorFactoryRegistry)).buildValidatorFactory();
            ((ValidatorFactoryRegistry)object).a((String)object2, (ValidatorFactory)validatorFactoryRegistry);
        }
        this.d = validatorFactoryRegistry.getValidator();
    }

    public void importDocument(UaCurrencyPurchase object) {
        List<Account> list;
        Object object2;
        Object object3;
        Object object4 = object;
        Object object5 = this;
        Object object6 = object4;
        Object object7 = object5;
        Object object8 = object6.getDate();
        if (object8 != null) {
            int n2;
            object3 = ((UaCurrencyPurchaseImporter)object7).b.m().a().toLocalDate();
            LocalDate localDate = ((LocalDate)object3).minusDays(n2 = ((UaCurrencyPurchaseImporter)object7).a("documents.work.backdate", 0).intValue());
            if (((LocalDate)object8).isBefore(localDate)) {
                throw new RuntimeException(String.format(UaCurrencyPurchaseImporter.f("docDateIsLessThanAllowed"), localDate, "DATE_DOC"));
            }
            int n3 = ((UaCurrencyPurchaseImporter)object7).a("documents.work.futuredate", 0);
            if (((LocalDate)object8).isAfter((ChronoLocalDate)(object3 = ((LocalDate)object3).plusDays(n3)))) {
                throw new RuntimeException(String.format(UaCurrencyPurchaseImporter.f("docDateIsMoreThanAllowed"), object3, "DATE_DOC"));
            }
        }
        if (((UaCurrencyPurchase)object4).getNumber() == null || ((UaCurrencyPurchase)object4).getDate() == null) {
            object2 = ((UaCurrencyPurchaseImporter)object5).c.a("ua_currency_purchase");
            if (((UaCurrencyPurchase)object4).getNumber() == null) {
                if (((DocumentTemplate)object2).getNumber().isEmpty()) {
                    throw new RuntimeException(UaCurrencyPurchaseImporter.f("docNumCannotBeGeneratedAutomatically"));
                }
                ((UaCurrencyPurchase)object4).setNumber(((DocumentTemplate)object2).getNumber());
            }
            if (((UaCurrencyPurchase)object4).getDate() == null) {
                ((UaCurrencyPurchase)object4).setDate(((DocumentTemplate)object2).getDate());
            }
        }
        UaCurrencyPurchaseImporter.a(this.d.validate(object, new Class[0]));
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPurchaseImporter)object5).b.e().a();
        ((UaCurrencyPurchase)object4).setClientName(((Client)object2).getName());
        ((UaCurrencyPurchase)object4).setClientAddress(((Client)object2).getAddress());
        ((UaCurrencyPurchase)object4).setClientPhone(((Client)object2).getPhone());
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPurchaseImporter)object5).b.o().a("documents.ua_currency_purchase.enum_hryvnia", "all");
        object7 = ((UaCurrencyPurchase)object4).getTransferKind();
        if (object7 == null) {
            object6 = "charge".equals(object2) ? ua.com.dbosoft.autoclient.app.ua_currency_purchase.c.b : ua.com.dbosoft.autoclient.app.ua_currency_purchase.c.a;
        } else {
            object6 = UaCurrencyPurchaseImporter.a((String)object7);
            if (object6 == null || ((Enum)object6).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.c.b) && "undertake".equals(object2) || ((Enum)object6).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.c.a) && "charge".equals(object2)) {
                object6 = "TRANSFER_KIND";
                object3 = "invalidValueOfField";
                object = object5;
                throw ((UaCurrencyPurchaseImporter)object).a((String)object3, (String)object6, false);
            }
        }
        object8 = object6;
        ((UaCurrencyPurchase)object4).setTransferKind(ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_purchase/transferKind").getString(((Enum)object8).name() + ".dbValue"));
        object3 = object6;
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPurchase)object4).getCurrencyDate();
        if (object2 != null) {
            if (((UaCurrencyPurchase)object4).getExperienceDate() != null) {
                throw ((UaCurrencyPurchaseImporter)object5).a("onlyOneDocValidityPeriodRequired", "CURRENCY_DATE", true);
            }
            object7 = ((UaCurrencyPurchase)object4).getDate();
            if (((LocalDate)object2).isBefore((ChronoLocalDate)object7)) {
                ((UaCurrencyPurchase)object4).setCurrencyDate(null);
            } else {
                object6 = ((UaCurrencyPurchaseImporter)object5).d(((UaCurrencyPurchase)object4).getBankCode(), "ua_currency_purchase.value_date.limit");
                if (object6 != null && ((LocalDate)object2).isAfter(((LocalDate)object7).plusDays(((Integer)object6).intValue()))) {
                    ((UaCurrencyPurchase)object4).setCurrencyDate(null);
                }
            }
        }
        object4 = object;
        object5 = this;
        object7 = object4;
        object2 = object5;
        object6 = ((UaCurrencyPurchase)object7).getCurrencyDate();
        if (object6 == null || ((LocalDate)object6).isBefore(((UaCurrencyPurchase)object7).getDate().plusDays(3L)) ? false : super.a("ua_currency_purchase.forward", false)) {
            ((UaCurrencyPurchase)object4).setForward(1);
            ((UaCurrencyPurchaseImporter)object5).a((UaCurrencyPurchase)object4, "forwardCondition", "forwardCoverageAmount");
            Object object9 = object4;
            ((UaCurrencyPurchase)object9).setForwardCoverageAmount(((UaCurrencyPurchase)object9).getForwardCoverageAmount().setScale(6, RoundingMode.HALF_UP));
        } else {
            ((UaCurrencyPurchase)object4).setForward(0);
            ((UaCurrencyPurchase)object4).setForwardCondition(null);
            ((UaCurrencyPurchase)object4).setForwardCoverageAmount(null);
        }
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPurchase)object4).getExperienceDate();
        if (object2 == null) {
            if (((UaCurrencyPurchase)object4).getCurrencyDate() == null) {
                Object object10 = object4;
                ((UaCurrencyPurchase)object10).setExperienceDate(((UaCurrencyPurchase)object10).getDate().plusDays(30L));
            }
        } else {
            object7 = ((UaCurrencyPurchase)object4).getDate();
            if (((LocalDate)object2).isBefore((ChronoLocalDate)object7)) {
                throw ((UaCurrencyPurchaseImporter)object5).a("expDateIsLessThanDocDate", "EXPERIENCE_DATE", true);
            }
            if (((LocalDate)object2).isAfter(((LocalDate)object7).plusDays(30L))) {
                throw ((UaCurrencyPurchaseImporter)object5).a("expDateIsTooLate", "EXPERIENCE_DATE", true);
            }
        }
        object4 = object;
        object5 = this;
        Object object11 = object2 = ((UaCurrencyPurchase)object4).getForward() == 1 ? "ua_currency_purchase.forward.commission_percent.can_edit" : "ua_currency_purchase.commission_percent.can_edit";
        if (((UaCurrencyPurchaseImporter)object5).a((String)object2, true)) {
            object7 = ((UaCurrencyPurchase)object4).getCommission();
        } else {
            object6 = ((UaCurrencyPurchase)object4).getForward() == 1 ? "ua_currency_purchase.forward.commission_percent" : "ua_currency_purchase.commission_percent";
            object7 = ((UaCurrencyPurchaseImporter)object5).a((String)object6, (BigDecimal)null);
            ((UaCurrencyPurchase)object4).setCommission((BigDecimal)object7);
        }
        if (object7 != null) {
            ((UaCurrencyPurchase)object4).setCommission(((BigDecimal)object7).setScale(3, RoundingMode.HALF_UP));
        }
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPurchase)object4).getPurchaseAccount();
        object6 = ((UaCurrencyPurchase)object4).getPurchaseCurrency();
        if (((String)object2).length() == 29) {
            object7 = ((UaCurrencyPurchaseImporter)object5).b.a().a((String)object2).stream().filter(arg_0 -> UaCurrencyPurchaseImporter.a((String)object6, arg_0)).findAny().orElseThrow(() -> this.c("acc_not_belong_to_the_client", "PURCHASE_ACCOUNT"));
            ((UaCurrencyPurchaseImporter)object5).a(((Account)object7).getPermission(), "PURCHASE_ACCOUNT");
            if (!ua.com.dbosoft.autoclient.app.account.c.a.equals((Object)((Account)object7).getType()) && !ua.com.dbosoft.autoclient.app.account.c.c.equals((Object)((Account)object7).getType())) {
                throw ((UaCurrencyPurchaseImporter)object5).c("acc_type_must_be_current", "PURCHASE_ACCOUNT");
            }
        } else {
            object7 = ((UaCurrencyPurchaseImporter)object5).a((String)object2, (String)object6).orElseThrow(() -> this.c("wrong_iban_length", "PURCHASE_ACCOUNT"));
            ((UaCurrencyPurchase)object4).setPurchaseAccount(((Account)object7).getIban());
        }
        ((UaCurrencyPurchaseImporter)object5).a(((Account)object7).getStatus(), "PURCHASE_ACCOUNT");
        object4 = object;
        object5 = this;
        object7 = ((UaCurrencyPurchase)object4).getPurchaseRateKind();
        object6 = ((UaCurrencyPurchaseImporter)object5).e("ua_currency_purchase.rate_choice.show", null);
        if (object7 == null) {
            object2 = "client".equals(object6) ? ua.com.dbosoft.autoclient.app.ua_currency_purchase.b.a : ua.com.dbosoft.autoclient.app.ua_currency_purchase.b.b;
        } else {
            object2 = UaCurrencyPurchaseImporter.c((String)object7);
            if (object2 == null) {
                object6 = "PURCHASE_RATE_KIND";
                object3 = "fieldFillingError";
                object = object5;
                throw ((UaCurrencyPurchaseImporter)object).a((String)object3, (String)object6, false);
            }
            if (((UaCurrencyPurchase)object4).getForward() != 1 && (((Enum)object2).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.b.a) && "bank".equals(object6) || ((Enum)object2).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.b.b) && "client".equals(object6))) {
                object6 = "PURCHASE_RATE_KIND";
                object3 = "incorrectValueInField";
                object = object5;
                throw ((UaCurrencyPurchaseImporter)object).a((String)object3, (String)object6, false);
            }
            if (((Enum)object2).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.b.c) && ((UaCurrencyPurchaseImporter)object5).a("documents.ua_currency_purchase.nbu_rate_choice.hide", false)) {
                object6 = "PURCHASE_RATE_KIND";
                object3 = "incorrectValueInField";
                object = object5;
                throw ((UaCurrencyPurchaseImporter)object).a((String)object3, (String)object6, false);
            }
        }
        object8 = object2;
        ((UaCurrencyPurchase)object4).setPurchaseRateKind(ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_purchase/purchaseRateKind").getString(((Enum)object8).name() + ".dbValue"));
        object6 = object2;
        object4 = object;
        object5 = this;
        object2 = UaCurrencyPurchaseImporter.d(((UaCurrencyPurchase)object4).getAmountKind());
        if (object2 == null || ua.com.dbosoft.autoclient.app.ua_currency_purchase.a.b.equals(object2) && !((UaCurrencyPurchaseImporter)object5).b.o().a("documents.ua_currency_purchase.amount_choice.show", false)) {
            object6 = "AMOUNT_KIND";
            object3 = "incorrectValueInField";
            object = object5;
            throw ((UaCurrencyPurchaseImporter)object).a((String)object3, (String)object6, false);
        }
        object7 = object2;
        ((UaCurrencyPurchase)object4).setAmountKind(ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_purchase/amountKind").getString(((Enum)object7).name() + ".dbValue"));
        object2 = object8 = object2;
        object4 = object;
        object5 = this;
        if (((Enum)object2).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.a.a)) {
            object7 = ((UaCurrencyPurchase)object4).getPurchaseSum();
            if (object7 != null) {
                ((UaCurrencyPurchase)object4).setPurchaseSum(((BigDecimal)object7).setScale(6, RoundingMode.HALF_UP));
            }
            ((UaCurrencyPurchaseImporter)object5).a((UaCurrencyPurchase)object4, new String[]{"purchaseSum"});
        } else if (((UaCurrencyPurchase)object4).getPurchaseSum() != null) {
            throw new RuntimeException(String.format(UaCurrencyPurchaseImporter.f("fieldMustBeEmpty"), UaCurrencyPurchaseImporter.g("PURCHASE_SUM"), "PURCHASE_SUM"));
        }
        object2 = object6;
        object4 = object;
        object5 = this;
        if (((Enum)object2).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.b.a)) {
            object7 = ((UaCurrencyPurchase)object4).getPurchaseRate();
            if (object7 != null) {
                ((UaCurrencyPurchase)object4).setPurchaseRate(((BigDecimal)object7).setScale(10, RoundingMode.HALF_UP));
            }
            ((UaCurrencyPurchaseImporter)object5).a((UaCurrencyPurchase)object4, new String[]{"purchaseRate"});
        } else if (((UaCurrencyPurchase)object4).getPurchaseRate() != null) {
            throw new RuntimeException(String.format(UaCurrencyPurchaseImporter.f("fieldMustBeEmpty"), UaCurrencyPurchaseImporter.g("PURCHASE_RATE"), "PURCHASE_RATE"));
        }
        object2 = object8;
        object4 = object;
        object5 = this;
        if (((Enum)object2).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.a.a)) {
            object7 = ((UaCurrencyPurchase)object4).getPurchaseRate();
            if (object7 != null) {
                Object object12 = object4;
                ((UaCurrencyPurchase)object12).setSaleSum(((UaCurrencyPurchase)object12).getPurchaseSum().multiply((BigDecimal)object7).setScale(2, RoundingMode.HALF_UP));
                ((UaCurrencyPurchaseImporter)object5).a((UaCurrencyPurchase)object4, new String[]{"saleSum"});
            } else if (((UaCurrencyPurchase)object4).getSaleSumString() != null) {
                throw new RuntimeException(String.format(UaCurrencyPurchaseImporter.f("fieldMustBeEmpty"), UaCurrencyPurchaseImporter.g("PURCHASE_RATE"), "PURCHASE_RATE"));
            }
        } else if (((UaCurrencyPurchase)object4).getSaleSumString() != null) {
            try {
                ((UaCurrencyPurchase)object4).setSaleSum(new BigDecimal(((UaCurrencyPurchase)object4).getSaleSumString()).setScale(2, RoundingMode.HALF_UP));
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException(UaCurrencyPurchaseImporter.f("incorrectAmount") + " (SALE_SUM)");
            }
            ((UaCurrencyPurchaseImporter)object5).a((UaCurrencyPurchase)object4, new String[]{"saleSum"});
        } else {
            throw new RuntimeException(UaCurrencyPurchaseImporter.f("emptyRequiredField") + " (SALE_SUM)");
        }
        if (((UaCurrencyPurchase)object4).getSaleSum() != null) {
            Object object13 = object4;
            ((UaCurrencyPurchase)object13).setSaleSumString(((UaCurrencyPurchase)object13).getSaleSum().toString());
        }
        if (((UaCurrencyPurchase)object4).getSaleSum() != null && ((UaCurrencyPurchase)object4).getSaleSum().compareTo(BigDecimal.ZERO) <= 0) {
            throw new RuntimeException(UaCurrencyPurchaseImporter.f("sumInFieldMustBePositive") + " (SALE_SUM)");
        }
        object5 = object;
        ((UaCurrencyPurchase)object5).setPensionTax(new BigDecimal("0.00"));
        ((UaCurrencyPurchase)object5).setFundAccount(null);
        ((UaCurrencyPurchase)object5).setFundBankCode(null);
        ((UaCurrencyPurchase)object5).setFundBankName(null);
        object2 = object3;
        object4 = object;
        object5 = this;
        if (((Enum)object2).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.c.b)) {
            object7 = super.a((UaCurrencyPurchase)object4, "ua_currency_purchase.order_write-off.bnk_account");
            if (object7 == null) {
                object7 = super.a((UaCurrencyPurchase)object4, "ua_currency_purchase.purchase_bnk_account");
            }
            ((UaCurrencyPurchase)object4).setSaleAccount((String)object7);
        }
        if (((UaCurrencyPurchase)object4).getSaleAccount() != null) {
            super.a((UaCurrencyPurchase)object4, new String[]{"saleAccount"});
        } else if (((Enum)object2).equals((Object)ua.com.dbosoft.autoclient.app.ua_currency_purchase.c.a)) {
            throw super.a("transferAccountNotDefined", "SALE_ACCOUNT", true);
        }
        object4 = object;
        object5 = this;
        object8 = object4;
        object6 = object5;
        object3 = ((UaCurrencyPurchaseImporter)object5).b.p().a(((UaCurrencyPurchase)object8).getBankCode());
        if (object3 == null) {
            throw super.c("bankCodeNotFound", "BNK_MFO");
        }
        ((UaCurrencyPurchase)object8).setBankName(((UaSwift)object3).getName());
        if (!((UaCurrencyPurchase)object4).getBankCode().equals(((UaCurrencyPurchase)object4).getPurchaseBankCode())) {
            throw super.a("accsMustBeOpenedInTheSameMFO", "BNK_MFO", true);
        }
        Object object14 = object4;
        ((UaCurrencyPurchase)object14).setSaleBankCode(((UaCurrencyPurchase)object14).getBankCode());
        Object object15 = object4;
        ((UaCurrencyPurchase)object15).setSaleBankName(((UaCurrencyPurchase)object15).getBankName());
        object2 = ((UaCurrencyPurchaseImporter)object5).b.b().a(((UaCurrencyPurchase)object4).getBankCode());
        if (object2 != null && ((BankBranch)object2).getAddress() != null) {
            int n4 = Math.min(((BankBranch)object2).getAddress().length(), 80);
            ((UaCurrencyPurchase)object4).setBankAddress(((BankBranch)object2).getAddress().substring(0, n4));
        } else {
            super.a((UaCurrencyPurchase)object4, new String[]{"bankAddress"});
        }
        Object object16 = object;
        ((UaCurrencyPurchase)object16).setPurchaseBankName(((UaCurrencyPurchase)object16).getBankName());
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPurchase)object4).getCurrentAccount();
        if (((String)object2).length() != 29) {
            list = super.a((String)object2, "UAH").orElseThrow(() -> this.c("wrong_iban_length", "CURRENT_ACCOUNT"));
            ((UaCurrencyPurchase)object4).setCurrentAccount(((Account)((Object)list)).getIban());
        } else {
            list = ((UaCurrencyPurchaseImporter)object5).b.a().a((String)object2).stream().filter(account -> "UAH".equals(account.getCurrency())).findAny().orElseThrow(() -> this.c("acc_not_belong_to_the_client", "CURRENT_ACCOUNT"));
            super.a(((Account)((Object)list)).getPermission(), "CURRENT_ACCOUNT");
        }
        super.a(((Account)((Object)list)).getType(), "CURRENT_ACCOUNT", true);
        super.a(((Account)((Object)list)).getStatus(), "CURRENT_ACCOUNT");
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPurchase)object4).getReturnAccount();
        if (object2 == null) {
            object6 = "RETURN_ACCOUNT";
            object3 = "emptyRequiredField";
            object = object5;
            throw super.a((String)object3, (String)object6, false);
        }
        if (((String)object2).length() != 29) {
            list = super.a((String)object2, "UAH").orElseThrow(() -> this.c("wrong_iban_length", "RETURN_ACCOUNT"));
            super.a(((Account)((Object)list)).getStatus(), "RETURN_ACCOUNT");
            ((UaCurrencyPurchase)object4).setReturnAccount(((Account)((Object)list)).getIban());
        } else {
            list = ((UaCurrencyPurchaseImporter)object5).b.a().a((String)object2);
            if (list.isEmpty()) {
                super.a((UaCurrencyPurchase)object4, new String[]{"returnAccount"});
            } else {
                object6 = list.stream().filter(account -> account.getCurrency().equals("UAH")).findAny();
                if (((Optional)object6).isPresent()) {
                    object8 = (Account)((Optional)object6).get();
                    super.a(((Account)object8).getType(), "RETURN_ACCOUNT", false);
                    super.a(((Account)object8).getStatus(), "RETURN_ACCOUNT");
                } else {
                    throw super.a("foreignAccCurrencyForbidden", "RETURN_ACCOUNT", true);
                }
            }
        }
        Object object17 = object;
        ((UaCurrencyPurchase)object17).setReturnBankCode(((UaCurrencyPurchase)object17).getReturnAccount().substring(4, 10));
        object4 = object;
        object5 = this;
        object2 = ((UaCurrencyPurchaseImporter)object5).b.p().a(((UaCurrencyPurchase)object4).getReturnBankCode());
        if (object2 == null) {
            throw super.c("bankCodeNotFound", "RETURN_ACCOUNT");
        }
        ((UaCurrencyPurchase)object4).setReturnBankName(((UaSwift)object2).getName());
        object4 = object;
        object5 = this;
        if (((UaCurrencyPurchaseImporter)object5).b.o().a("documents.ua_currency_purchase.empl_name_phone.option", true)) {
            super.a((UaCurrencyPurchase)object4, new String[]{"clientEmployeeFullName"});
        }
        object4 = object;
        object5 = this;
        if (((UaCurrencyPurchaseImporter)object5).b.o().a("documents.ua_currency_purchase.empl_name_phone.option", true)) {
            super.a((UaCurrencyPurchase)object4, new String[]{"clientEmployeePhone"});
        }
        if (((UaCurrencyPurchase)object4).getClientEmployeePhone() != null) {
            object2 = ((UaCurrencyPurchaseImporter)object5).b.f().a();
            list = new K();
            ((K)((Object)list)).a(((UaCurrencyPurchase)object4).getClientEmployeePhone(), (List<Country>)object2);
            if (((K)((Object)list)).b()) {
                throw super.a("phoneCodeNotFound", "CLN_EMPLOYEE_PHONE", true);
            }
            if (!((K)((Object)list)).a()) {
                object6 = "CLN_EMPLOYEE_PHONE";
                object3 = "fieldFillingError";
                object = object5;
                throw super.a((String)object3, (String)object6, false);
            }
        }
        ((UaCurrencyPurchase)object).setAttachmentsCount(0);
        this.c.a((ua.com.dbosoft.autoclient.app.c)object);
    }

    private static c a(String string) {
        for (c c2 : ua.com.dbosoft.autoclient.app.ua_currency_purchase.c.a()) {
            if (!c2.b().contains(string)) continue;
            return c2;
        }
        return null;
    }

    private static Predicate<Account> b(String object) {
        Predicate<Account> predicate = account -> account.getPermission() != null && !account.getPermission().equals((Object)f.a);
        Predicate<Account> predicate2 = account -> account.getType().equals((Object)ua.com.dbosoft.autoclient.app.account.c.a) || account.getType().equals((Object)ua.com.dbosoft.autoclient.app.account.c.c);
        Predicate<Account> predicate3 = account -> account.getStatus().equals((Object)ua.com.dbosoft.autoclient.app.account.b.a) || account.getStatus().equals((Object)ua.com.dbosoft.autoclient.app.account.b.c);
        object = arg_0 -> UaCurrencyPurchaseImporter.b((String)object, arg_0);
        return object.and(predicate).and(predicate2).and(predicate3);
    }

    private Optional<Account> a(String string, String string2) {
        return this.b.a().b(string).stream().filter(UaCurrencyPurchaseImporter.b(string2)).findAny();
    }

    private void a(f f2, String string) {
        if (f2 == null || f2.equals((Object)f.a)) {
            throw this.c("no_permission_for_account_saving", string);
        }
    }

    private void a(ua.com.dbosoft.autoclient.app.account.c object, String string, boolean bl) {
        switch (ua.com.dbosoft.autoclient.app.ua_currency_purchase.d.a[object.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                object = bl ? "cash_coverage_accs_prohibited_from_writing_off_funds" : "cash_coverage_accs_prohibited_from_deposit_funds";
                throw this.c((String)object, string);
            }
        }
        throw this.c("acc_type_must_be_current", string);
    }

    private void a(ua.com.dbosoft.autoclient.app.account.b b2, String string) {
        if (ua.com.dbosoft.autoclient.app.account.b.a.equals((Object)b2) || ua.com.dbosoft.autoclient.app.account.b.b.equals((Object)b2)) {
            throw this.c("acc_is_closed_or_to_read_only", string);
        }
    }

    private static b c(String string) {
        for (b b2 : ua.com.dbosoft.autoclient.app.ua_currency_purchase.b.a()) {
            if (!b2.b().contains(string)) continue;
            return b2;
        }
        return null;
    }

    private static a d(String string) {
        for (a a2 : ua.com.dbosoft.autoclient.app.ua_currency_purchase.a.a()) {
            if (!a2.b().contains(string)) continue;
            return a2;
        }
        return null;
    }

    private String a(UaCurrencyPurchase uaCurrencyPurchase, String string) {
        String string2 = string + "." + uaCurrencyPurchase.getPurchaseCurrency();
        string2 = this.b(uaCurrencyPurchase.getBankCode(), string2);
        if (string2 != null) {
            return string2;
        }
        return this.b(uaCurrencyPurchase.getBankCode(), string);
    }

    private String b(String string, String string2) {
        Object object = this.b.e().a();
        if ((object = ((Client)object).getSpecificProperty(string + "." + string2)) != null) {
            return object;
        }
        return this.b.c().a(string, string2);
    }

    private RuntimeException c(String string, String string2) {
        return new RuntimeException(String.format("%s (%s)", UaCurrencyPurchaseImporter.e(string), string2));
    }

    private static String e(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/account/account").getString(string);
    }

    private Integer d(String string, String string2) {
        String string3 = this.b.c().a(string, string2);
        if (string3 != null) {
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0431\u0430\u043d\u043a\u0443 \"%s\" \u043c\u0430\u0454 \u0434\u043e\u0440\u0456\u0432\u043d\u044e\u0432\u0430\u0442\u0438 \u0446\u0456\u043b\u043e\u043c\u0443 \u0447\u0438\u0441\u043b\u0443";
                a.debug(String.format(string4, string2, string), (Throwable)numberFormatException);
            }
        }
        return null;
    }

    private boolean a(String string, boolean bl) {
        if ((string = this.e(string, null)) == null) {
            return bl;
        }
        return Boolean.parseBoolean(string);
    }

    private String e(String string, String string2) {
        Object object = this.b.e().a();
        if ((object = ((Client)object).getSpecificProperty(string)) != null) {
            return object;
        }
        return this.b.o().a(string, string2);
    }

    private Integer a(String string, Integer n2) {
        String string2 = this.e(string, null);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = String.format("\u041d\u0435\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"%s\": %s", string, string2);
            a.debug(string, (Throwable)numberFormatException);
            return n2;
        }
    }

    private BigDecimal a(String string, BigDecimal bigDecimal) {
        String string2 = this.e(string, null);
        if (string2 == null) {
            return bigDecimal;
        }
        try {
            return new BigDecimal(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = String.format("\u041d\u0435\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"%s\": %s", string, string2);
            a.debug(string, (Throwable)numberFormatException);
            return bigDecimal;
        }
    }

    private void a(UaCurrencyPurchase uaCurrencyPurchase, String ... stringArray) {
        for (String string : stringArray) {
            UaCurrencyPurchaseImporter.a(this.d.validateProperty((Object)uaCurrencyPurchase, string, new Class[]{ua.com.dbosoft.autoclient.app.validation.a.class}));
        }
    }

    private static <T> void a(Iterable<ConstraintViolation<T>> object) {
        if ((object = object.iterator()).hasNext()) {
            throw new RuntimeException(((ConstraintViolation)object.next()).getMessage());
        }
    }

    private static String f(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_purchase/validationMessages").getString(string);
    }

    private RuntimeException a(String string, String string2, boolean bl) {
        if (bl) {
            return new RuntimeException(String.format("%s (%s)", UaCurrencyPurchaseImporter.f(string), string2));
        }
        return new RuntimeException(String.format("%s \"%s\" (%s)", UaCurrencyPurchaseImporter.f(string), UaCurrencyPurchaseImporter.g(string2), string2));
    }

    private static String g(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_currency_purchase/fieldDescription").getString("desc." + string);
    }

    private static /* synthetic */ boolean a(String string, Account account) {
        return string.equals(account.getCurrency());
    }

    private static /* synthetic */ boolean b(String string, Account account) {
        return account.getIban() != null && string.equals(account.getCurrency());
    }
}

