/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.ContentInfo;
import com.bifit.security.pkix.cms.EncapsulatedContentInfo;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DigestedData
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final AlgorithmIdentifier b;
    private final EncapsulatedContentInfo c;
    private final ASN1OctetString d;
    public static final ASN1Template TEMPLATE = new a();

    public DigestedData(ASN1Integer aSN1Integer, AlgorithmIdentifier algorithmIdentifier, EncapsulatedContentInfo encapsulatedContentInfo, ASN1OctetString aSN1OctetString) {
        super(DigestedData.class);
        PKIXUtils.verifyNotNull(aSN1Integer, algorithmIdentifier, encapsulatedContentInfo, aSN1OctetString);
        this.a = aSN1Integer;
        this.b = algorithmIdentifier;
        this.c = encapsulatedContentInfo;
        this.d = aSN1OctetString;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.b;
    }

    public EncapsulatedContentInfo getContentInfo() {
        return this.c;
    }

    public ASN1OctetString getDigest() {
        return this.d;
    }

    public static DigestedData getInstance(byte[] byArray) throws PKIXException {
        try {
            return (DigestedData)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ContentInfo.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new DigestedData((ASN1Integer)aSN1Tag.elementAt(0), (AlgorithmIdentifier)aSN1Tag.elementAt(1), (EncapsulatedContentInfo)aSN1Tag.elementAt(2), (ASN1OctetString)aSN1Tag.elementAt(3));
        }
    }
}

