/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Certificate;
import com.bifit.security.pkix.x509.Name;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IssuerAndSerialNumber
extends AbstractASN1Sequence {
    private Name a;
    private ASN1Integer b;
    public static final ASN1Template TEMPLATE = new a();

    public IssuerAndSerialNumber(Name name, ASN1Integer aSN1Integer) {
        super(IssuerAndSerialNumber.class);
        this.debug("issuer = " + name + ", serialNumber = " + aSN1Integer);
        PKIXUtils.verifyNotNull(name, aSN1Integer);
        this.a = name;
        this.b = aSN1Integer;
    }

    public IssuerAndSerialNumber(Certificate certificate) {
        super(IssuerAndSerialNumber.class);
        this.debug("cert = " + certificate);
        PKIXUtils.verifyNotNull(certificate);
        this.a = certificate.getInfo().getIssuer();
        this.b = certificate.getInfo().getSerialNumber();
    }

    public Name getIssuer() {
        return this.a;
    }

    public void setIssuer(Name name) {
        PKIXUtils.verifyNotNull(name);
        this.a = name;
    }

    public ASN1Integer getSerialNumber() {
        return this.b;
    }

    public void setSerialNumber(ASN1Integer aSN1Integer) {
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.b = aSN1Integer;
    }

    public static IssuerAndSerialNumber getInstance(byte[] byArray) throws PKIXException {
        try {
            return (IssuerAndSerialNumber)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(Name.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            Assert.debugAssert(((aSN1Tag = this.getSequence(aSN1Tag, inputStream)).size() == 2 ? 1 : 0) != 0);
            return new IssuerAndSerialNumber((Name)aSN1Tag.elementAt(0), (ASN1Integer)aSN1Tag.elementAt(1));
        }
    }
}

