/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.RecipientIdentifier;
import com.bifit.security.pkix.cms.RecipientInfo;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KeyTransRecipientInfo
extends AbstractASN1Sequence {
    private ASN1Integer a;
    private RecipientIdentifier b;
    private AlgorithmIdentifier c;
    private ASN1OctetString d;
    public static final ASN1Template TEMPLATE = new a();

    public KeyTransRecipientInfo(ASN1Integer aSN1Integer, RecipientIdentifier recipientIdentifier, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        super(KeyTransRecipientInfo.class);
        PKIXUtils.verifyNotNull(aSN1Integer, recipientIdentifier, algorithmIdentifier, aSN1OctetString);
        this.a = aSN1Integer;
        this.b = recipientIdentifier;
        this.c = algorithmIdentifier;
        this.d = aSN1OctetString;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public void setVersion(ASN1Integer aSN1Integer) {
        this.a = aSN1Integer;
    }

    public RecipientIdentifier getRid() {
        return this.b;
    }

    public void setRid(RecipientIdentifier recipientIdentifier) {
        this.b = recipientIdentifier;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.c;
    }

    public void setKeyEncryptionAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.c = algorithmIdentifier;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.d;
    }

    public void setEncryptedKey(ASN1OctetString aSN1OctetString) {
        this.d = aSN1OctetString;
    }

    public static RecipientInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (RecipientInfo)ASN1Util.decode((ASN1Template)RecipientInfo.TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(RecipientIdentifier.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new KeyTransRecipientInfo((ASN1Integer)aSN1Tag.elementAt(0), (RecipientIdentifier)aSN1Tag.elementAt(1), (AlgorithmIdentifier)aSN1Tag.elementAt(2), (ASN1OctetString)aSN1Tag.elementAt(3));
        }
    }
}

