/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.IssuerAndSerialNumber;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;

public class RecipientIdentifier
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    RecipientIdentifier(Type type, ASN1Value aSN1Value) {
        super(RecipientIdentifier.class, aSN1Value);
        this.a = type;
    }

    public static RecipientIdentifier getInstanceIssuerAndSerialNum(IssuerAndSerialNumber issuerAndSerialNumber) {
        return new RecipientIdentifier(Type.ISSUER_AND_SERIAL_NUMBER, (ASN1Value)issuerAndSerialNumber);
    }

    public static RecipientIdentifier getInstanceSubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        return new RecipientIdentifier(Type.SUBJECT_KEY_IDENTIFIER, (ASN1Value)aSN1OctetString);
    }

    public static RecipientIdentifier getInstance(byte[] byArray) throws PKIXException {
        try {
            return (RecipientIdentifier)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public Type getType() {
        return this.a;
    }

    @Override
    public ASN1Tag getTag() {
        ASN1Tag aSN1Tag;
        if (this.a == Type.ISSUER_AND_SERIAL_NUMBER) {
            aSN1Tag = IssuerAndSerialNumber.TAG;
        } else {
            Assert.debugAssert((this.a == Type.SUBJECT_KEY_IDENTIFIER ? 1 : 0) != 0);
            aSN1Tag = ASN1Tag.get((long)0L);
        }
        return aSN1Tag;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (this.a == Type.ISSUER_AND_SERIAL_NUMBER) {
            return (IssuerAndSerialNumber)this.value;
        }
        return null;
    }

    public ASN1OctetString getSubjectKeyIdentifier() {
        if (this.a == Type.SUBJECT_KEY_IDENTIFIER) {
            return (ASN1OctetString)this.value;
        }
        return null;
    }

    public boolean isIssuerAndSerialNumber() {
        return this.a == Type.ISSUER_AND_SERIAL_NUMBER;
    }

    public boolean isSubjectKeyIdentifier() {
        return this.a == Type.SUBJECT_KEY_IDENTIFIER;
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(IssuerAndSerialNumber.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)0L), ASN1OctetString.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            inputStream = (ASN1Choice)this.choicet.decode(inputStream);
            Type type = object = inputStream.getTag().getNum() == 0L ? Type.SUBJECT_KEY_IDENTIFIER : Type.ISSUER_AND_SERIAL_NUMBER;
            inputStream = inputStream.getValue();
            return new RecipientIdentifier(type, (ASN1Value)inputStream);
        }
    }

    public static enum Type {
        ISSUER_AND_SERIAL_NUMBER,
        SUBJECT_KEY_IDENTIFIER;

    }
}

