/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.AlgorithmIdentifiers;
import com.bifit.security.pkix.cms.CertificateLists;
import com.bifit.security.pkix.cms.CertificateSet;
import com.bifit.security.pkix.cms.EncapsulatedContentInfo;
import com.bifit.security.pkix.cms.OidCms;
import com.bifit.security.pkix.cms.SignerInfo;
import com.bifit.security.pkix.cms.SignerInfos;
import com.bifit.security.pkix.crypto.DigestAdapter;
import com.bifit.security.pkix.crypto.VerifyAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.Attribute;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Certificate;
import com.bifit.security.pkix.x509.CertificateList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SignedData
extends AbstractASN1Sequence {
    private ASN1Integer a;
    private AlgorithmIdentifiers b;
    private EncapsulatedContentInfo c;
    private CertificateSet d;
    private CertificateLists e;
    private SignerInfos f;
    public static final ASN1Template TEMPLATE = new a();
    public static final int CADES_BES_FORMAT = 1;
    public static final int CADES_EPES_FORMAT = 2;
    public static final int CADES_C_FORMAT = 4;
    public static final int CADES_X_FORMAT = 8;

    public SignedData(ASN1Integer aSN1Integer, AlgorithmIdentifiers algorithmIdentifiers, EncapsulatedContentInfo encapsulatedContentInfo, SignerInfos signerInfos) {
        super(SignedData.class);
        this.debug("version = " + aSN1Integer + ", digestAlgorithms = " + algorithmIdentifiers + ", contentInfo = " + encapsulatedContentInfo + ", signerInfos = " + signerInfos);
        PKIXUtils.verifyNotNull(aSN1Integer, algorithmIdentifiers, encapsulatedContentInfo, signerInfos);
        this.a = aSN1Integer;
        this.b = algorithmIdentifiers;
        this.c = encapsulatedContentInfo;
        this.f = signerInfos;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public void setVersion(ASN1Integer aSN1Integer) {
        this.debug("version = " + aSN1Integer);
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.a = aSN1Integer;
    }

    public AlgorithmIdentifiers getDigestAlgorithms() {
        return this.b;
    }

    public void setDigestAlgorithms(AlgorithmIdentifiers algorithmIdentifiers) {
        this.debug("digestAlgorithms = " + algorithmIdentifiers);
        PKIXUtils.verifyNotNull(algorithmIdentifiers);
        this.b = algorithmIdentifiers;
    }

    public EncapsulatedContentInfo getContentInfo() {
        return this.c;
    }

    public void setContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.debug("contentInfo = " + encapsulatedContentInfo);
        PKIXUtils.verifyNotNull(encapsulatedContentInfo);
        this.c = encapsulatedContentInfo;
    }

    public CertificateSet getCertificates() {
        return this.d;
    }

    public void setCertificates(CertificateSet certificateSet) {
        this.debug("certificates = " + certificateSet);
        this.d = certificateSet;
    }

    private List<Certificate> a() {
        ArrayList<Certificate> arrayList;
        if (this.d == null) {
            arrayList = new ArrayList<Certificate>(0);
        } else {
            arrayList = new ArrayList(this.d.size());
            for (int i = 0; i < this.d.size(); ++i) {
                arrayList.add((Certificate)this.d.elementAt(i));
            }
        }
        return arrayList;
    }

    public boolean hasCertificates() {
        return this.d != null;
    }

    public CertificateLists getCrls() {
        return this.e;
    }

    public void setCrls(CertificateLists certificateLists) {
        this.debug("crls = " + certificateLists);
        this.e = certificateLists;
    }

    public boolean hasCrls() {
        return this.e != null;
    }

    public SignerInfos getSignerInfos() {
        return this.f;
    }

    public void setSignerInfos(SignerInfos signerInfos) {
        this.debug("signerInfos = " + signerInfos);
        PKIXUtils.verifyNotNull(signerInfos);
        this.f = signerInfos;
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier(int n) {
        AlgorithmIdentifier algorithmIdentifier = null;
        try {
            algorithmIdentifier = (AlgorithmIdentifier)this.b.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return algorithmIdentifier;
    }

    public List<Certificate> getIssuersCertificates() {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>(this.f.size());
        List<Certificate> list = this.a();
        for (int i = 0; i < this.f.size(); ++i) {
            SignerInfo signerInfo = (SignerInfo)this.f.elementAt(i);
            arrayList.add(signerInfo.searchCertificate(list));
        }
        return arrayList;
    }

    public List<Certificate> getIssuersCertificates(List<Certificate> list) {
        List<Certificate> list2 = this.getIssuersCertificates();
        if (list == null || list.size() == 0) {
            return list2;
        }
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) != null) continue;
            list2.set(i, ((SignerInfo)this.f.elementAt(i)).searchCertificate(list));
        }
        return list2;
    }

    public Certificate getCertificate(int n) {
        Certificate certificate = null;
        if (this.d != null) {
            try {
                certificate = (Certificate)this.d.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        return certificate;
    }

    public CertificateList getCrl(int n) {
        CertificateList certificateList = null;
        if (this.e != null) {
            try {
                certificateList = (CertificateList)this.e.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        return certificateList;
    }

    public SignerInfo getSignerInfo(int n) {
        SignerInfo signerInfo = null;
        try {
            signerInfo = (SignerInfo)this.f.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return signerInfo;
    }

    private boolean a(DigestAdapter digestAdapter, VerifyAdapter verifyAdapter, byte[] byArray, int n) throws PKIXException, CryptoException {
        SignerInfo signerInfo = this.getSignerInfo(n);
        if (signerInfo == null) {
            throw new PKIXException("No signs found");
        }
        if (byArray == null) {
            throw new PKIXException("Data not found");
        }
        Attribute attribute = signerInfo.getSignedAttributeByOid(OidCms.CONTENT_TYPE);
        if (attribute == null) {
            throw new PKIXException("Incorrect signedAttrs.");
        }
        try {
            attribute = (ASN1Any)attribute.getValues().elementAt(0);
            attribute = (ASN1ObjectIdentifier)attribute.decodeWith(ASN1ObjectIdentifier.TEMPLATE);
            if (!attribute.equals(this.c.getContentType())) {
                throw new PKIXException("Incorrect data type. Expected " + this.c.getContentType().toString() + ", actual " + attribute.toString());
            }
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException("Incorrect signedAttrs.");
        }
        return signerInfo.verify(digestAdapter, verifyAdapter, byArray);
    }

    private boolean a(DigestAdapter digestAdapter, VerifyAdapter verifyAdapter, InputStream inputStream, int n) throws PKIXException, CryptoException {
        SignerInfo signerInfo = this.getSignerInfo(n);
        if (signerInfo == null) {
            throw new PKIXException("No signs found");
        }
        if (inputStream == null) {
            throw new PKIXException("Data not found");
        }
        Attribute attribute = signerInfo.getSignedAttributeByOid(OidCms.CONTENT_TYPE);
        if (attribute == null) {
            throw new PKIXException("Incorrect signedAttrs.");
        }
        try {
            attribute = (ASN1Any)attribute.getValues().elementAt(0);
            attribute = (ASN1ObjectIdentifier)attribute.decodeWith(ASN1ObjectIdentifier.TEMPLATE);
            if (!attribute.equals(this.c.getContentType())) {
                throw new PKIXException("Incorrect data type. Expected " + this.c.getContentType().toString() + ", actual " + attribute.toString());
            }
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException("Incorrect signedAttrs.");
        }
        return signerInfo.verify(digestAdapter, verifyAdapter, inputStream);
    }

    public boolean verifyExternalData(List<DigestAdapter> list, List<VerifyAdapter> list2, byte[] byArray) throws PKIXException, CryptoException {
        if (this.f.isEmpty()) {
            throw new PKIXException("No signs found");
        }
        if (byArray == null) {
            throw new PKIXException("Data not found");
        }
        boolean bl = true;
        for (int i = 0; i < this.f.size() && bl; bl &= this.a(list.get(i), list2.get(i), byArray, i), ++i) {
        }
        return bl;
    }

    public boolean verifyExternalData(List<DigestAdapter> list, List<VerifyAdapter> list2, InputStream inputStream) throws PKIXException, CryptoException {
        if (this.f.isEmpty()) {
            throw new PKIXException("No signs found");
        }
        if (inputStream == null) {
            throw new PKIXException("Data not found");
        }
        boolean bl = true;
        for (int i = 0; i < this.f.size() && bl; bl &= this.a(list.get(i), list2.get(i), inputStream, i), ++i) {
        }
        return bl;
    }

    private static void a(VerifyAdapter verifyAdapter, Date date) throws PKIXException {
        if (date == null) {
            return;
        }
        if (!verifyAdapter.hasCertificate()) {
            throw new PKIXException("User certificate not found");
        }
        if (date.compareTo(verifyAdapter.getCertificate().getNotAfter()) > 0) {
            throw new PKIXException("User certificate is out date");
        }
    }

    private void a(List<VerifyAdapter> object, Date date) throws PKIXException {
        object = object.iterator();
        while (object.hasNext()) {
            VerifyAdapter verifyAdapter = (VerifyAdapter)object.next();
            SignedData.a(verifyAdapter, date);
        }
    }

    public boolean verifyExternalData(List<DigestAdapter> list, List<VerifyAdapter> list2, byte[] byArray, Date date) throws PKIXException, CryptoException {
        this.a(list2, date);
        return this.verifyExternalData(list, list2, byArray);
    }

    public boolean verifyExternalData(List<DigestAdapter> list, List<VerifyAdapter> list2, InputStream inputStream, Date date) throws PKIXException, CryptoException {
        this.a(list2, date);
        return this.verifyExternalData(list, list2, inputStream);
    }

    public boolean verifyInternalData(DigestAdapter digestAdapter, VerifyAdapter verifyAdapter) throws PKIXException, CryptoException {
        if (this.c.getContent() == null) {
            throw new PKIXException("No internal data found.");
        }
        byte[] byArray = this.c.getContent().toByteArray();
        return this.a(digestAdapter, verifyAdapter, byArray, 0);
    }

    public boolean verifyInternalData(List<DigestAdapter> list, List<VerifyAdapter> list2) throws PKIXException, CryptoException {
        if (this.c.getContent() == null) {
            throw new PKIXException("No internal data found.");
        }
        byte[] byArray = this.c.getContent().toByteArray();
        boolean bl = true;
        for (int i = 0; i < this.f.size() && bl; bl &= this.a(list.get(i), list2.get(i), byArray, i), ++i) {
        }
        return bl;
    }

    public boolean verifyInternalData(DigestAdapter digestAdapter, VerifyAdapter verifyAdapter, Date date) throws PKIXException, CryptoException {
        SignedData.a(verifyAdapter, date);
        return this.verifyInternalData(digestAdapter, verifyAdapter);
    }

    public boolean verifyInternalData(List<DigestAdapter> list, List<VerifyAdapter> list2, Date date) throws PKIXException, CryptoException {
        this.a(list2, date);
        return this.verifyInternalData(list, list2);
    }

    public boolean verifySigningCertificateV2(DigestAdapter digestAdapter, Certificate certificate) throws PKIXException {
        return this.verifySigningCertificateV2(digestAdapter, certificate, 0);
    }

    public boolean verifySigningCertificateV2(DigestAdapter digestAdapter, Certificate certificate, int n) throws PKIXException {
        SignerInfo signerInfo = this.getSignerInfo(n);
        return signerInfo.verifySigningCertificateV2(digestAdapter, certificate);
    }

    public boolean verifySigningCertificateV2(List<DigestAdapter> list, List<Certificate> list2) throws PKIXException {
        boolean bl = true;
        for (int i = 0; i < this.f.size() && bl; bl &= this.verifySigningCertificateV2(list.get(i), list2.get(i), i), ++i) {
        }
        return bl;
    }

    public static SignedData getInstance(byte[] byArray) throws PKIXException {
        try {
            return (SignedData)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Value)this.d);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.e);
        aSN1Sequence.addElement((ASN1Value)this.f);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifiers.TEMPLATE);
            this.seqt.addElement(EncapsulatedContentInfo.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)0L), CertificateSet.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), CertificateLists.TEMPLATE);
            this.seqt.addElement(SignerInfos.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream inputStream) throws IOException, InvalidBERException {
            object = this.getSequence((ASN1Tag)object, inputStream);
            inputStream = (ASN1Integer)object.elementAt(0);
            AlgorithmIdentifiers algorithmIdentifiers = (AlgorithmIdentifiers)object.elementAt(1);
            EncapsulatedContentInfo encapsulatedContentInfo = (EncapsulatedContentInfo)object.elementAt(2);
            CertificateSet certificateSet = (CertificateSet)object.elementAt(3);
            CertificateLists certificateLists = (CertificateLists)object.elementAt(4);
            object = (SignerInfos)object.elementAt(5);
            object = new SignedData((ASN1Integer)inputStream, algorithmIdentifiers, encapsulatedContentInfo, (SignerInfos)object);
            ((SignedData)object).setCertificates(certificateSet);
            ((SignedData)object).setCrls(certificateLists);
            return object;
        }
    }
}

