/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.crypto;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.OidUA;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.util.Arrays;

public final class CryptoConverter {
    private CryptoConverter() {
    }

    public static ASN1BitString signBytes2BitString(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        if ((algorithmIdentifier = algorithmIdentifier.getAlgorithm()).checkParentBranch(OidUA.PKI_DSTU4145_WITH_GOST3411)) {
            if (algorithmIdentifier.equals(OidUA.PKI_DSTU4145_PB_BE) || algorithmIdentifier.equals(OidUA.PKI_DSTU4145_ONB_BE)) {
                return new ASN1BitString(new ASN1OctetString(PKIXUtils.swap(byArray)).encode(), 0);
            }
            return new ASN1BitString(new ASN1OctetString(byArray).encode(), 0);
        }
        if (algorithmIdentifier.equals(OidUA.PKI_GOST34310_WITH_GOST34311)) {
            algorithmIdentifier = new ASN1Sequence();
            algorithmIdentifier.addElement((ASN1Value)new ASN1Integer(Arrays.copyOfRange(byArray, 0, byArray.length / 2)));
            algorithmIdentifier.addElement((ASN1Value)new ASN1Integer(Arrays.copyOfRange(byArray, byArray.length / 2, byArray.length)));
            return new ASN1BitString(algorithmIdentifier.encode(), 0);
        }
        return new ASN1BitString(byArray, 0);
    }

    public static byte[] signBitString2Bytes(AlgorithmIdentifier object, ASN1BitString object2) throws CryptoException, InvalidBERException {
        if ((object = ((AlgorithmIdentifier)object).getAlgorithm()).checkParentBranch(OidUA.PKI_DSTU4145_WITH_GOST3411)) {
            if (object.equals((Object)OidUA.PKI_DSTU4145_PB_BE) || object.equals((Object)OidUA.PKI_DSTU4145_ONB_BE)) {
                return PKIXUtils.swap(ASN1OctetString.getInstance((byte[])object2.getBits()).toByteArray());
            }
            return ASN1OctetString.getInstance((byte[])object2.getBits()).toByteArray();
        }
        if (object.equals((Object)OidUA.PKI_GOST34310_WITH_GOST34311)) {
            object = ASN1Sequence.getSequenceTemplate();
            object.addElement(ASN1Integer.TEMPLATE);
            object.addElement(ASN1Integer.TEMPLATE);
            object = (ASN1Sequence)ASN1Util.decode((ASN1Template)object, (byte[])object2.getBits());
            object2 = ((ASN1Integer)object.elementAt(0)).toByteArray();
            object = ((ASN1Integer)object.elementAt(1)).toByteArray();
            if (((ASN1BitString)object2).length > 32 || ((Object)object).length > 32) {
                throw new CryptoException("Invalid sign size");
            }
            byte[] byArray = new byte[64];
            System.arraycopy(object2, 0, byArray, 32 - ((ASN1BitString)object2).length, ((ASN1BitString)object2).length);
            System.arraycopy(object, 0, byArray, 64 - ((Object)object).length, ((Object)object).length);
            return byArray;
        }
        return object2.getBits();
    }

    public static ASN1OctetString signBytes2OctetString(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        if ((algorithmIdentifier = algorithmIdentifier.getAlgorithm()).equals(OidUA.PKI_GOST34310_WITH_GOST34311)) {
            algorithmIdentifier = new ASN1Sequence();
            algorithmIdentifier.addElement((ASN1Value)new ASN1Integer(Arrays.copyOfRange(byArray, 0, byArray.length / 2)));
            algorithmIdentifier.addElement((ASN1Value)new ASN1Integer(Arrays.copyOfRange(byArray, byArray.length / 2, byArray.length)));
            return new ASN1OctetString(algorithmIdentifier.encode());
        }
        return new ASN1OctetString(byArray);
    }

    public static byte[] signOctetString2Bytes(AlgorithmIdentifier object, ASN1OctetString object2) throws CryptoException {
        if ((object = ((AlgorithmIdentifier)object).getAlgorithm()).equals((Object)OidUA.PKI_GOST34310_WITH_GOST34311)) {
            object = ASN1Sequence.getSequenceTemplate();
            object.addElement(ASN1Integer.TEMPLATE);
            object.addElement(ASN1Integer.TEMPLATE);
            try {
                object = (ASN1Sequence)ASN1Util.decode((ASN1Template)object, (byte[])object2.toByteArray());
            }
            catch (InvalidBERException invalidBERException) {
                throw new CryptoException(invalidBERException);
            }
            object2 = ((ASN1Integer)object.elementAt(0)).toByteArray();
            object = ((ASN1Integer)object.elementAt(1)).toByteArray();
            if (((ASN1OctetString)object2).length > 32 || ((Object)object).length > 32) {
                throw new CryptoException("Invalid sign size");
            }
            byte[] byArray = new byte[64];
            System.arraycopy(object2, 0, byArray, 32 - ((ASN1OctetString)object2).length, ((ASN1OctetString)object2).length);
            System.arraycopy(object, 0, byArray, 64 - ((Object)object).length, ((Object)object).length);
            return byArray;
        }
        return object2.toByteArray();
    }
}

