/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.esf;

import com.bifit.security.asn1.ASN1GeneralizedTime;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.ocsp.ResponderID;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OcspIdentifier
extends AbstractASN1Sequence {
    private ResponderID a;
    private ASN1GeneralizedTime b;
    public static final ASN1Template TEMPLATE = new a();

    public OcspIdentifier(ResponderID responderID, ASN1GeneralizedTime aSN1GeneralizedTime) {
        super(OcspIdentifier.class);
        PKIXUtils.verifyNotNull(new Object[]{responderID, aSN1GeneralizedTime});
        this.a = responderID;
        this.b = aSN1GeneralizedTime;
    }

    public ResponderID getOcspResponderID() {
        return this.a;
    }

    public void setOcspResponderID(ResponderID responderID) {
        PKIXUtils.verifyNotNull(new Object[]{responderID});
        this.a = responderID;
    }

    public ASN1GeneralizedTime getProducedAt() {
        return this.b;
    }

    public void setProducedAt(ASN1GeneralizedTime aSN1GeneralizedTime) {
        PKIXUtils.verifyNotNull(aSN1GeneralizedTime);
        this.b = aSN1GeneralizedTime;
    }

    public static OcspIdentifier getInstance(byte[] byArray) throws PKIXException {
        try {
            return (OcspIdentifier)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ResponderID.TEMPLATE);
            this.seqt.addElement(ASN1GeneralizedTime.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new OcspIdentifier((ResponderID)aSN1Tag.elementAt(0), (ASN1GeneralizedTime)aSN1Tag.elementAt(1));
        }
    }
}

