/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.esf;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.esf.OtherHashAlgAndValue;
import com.bifit.security.pkix.esf.SigPolicyQualifierInfos;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SignaturePolicyId
extends AbstractASN1Sequence {
    private ASN1ObjectIdentifier a;
    private OtherHashAlgAndValue b;
    private SigPolicyQualifierInfos c;
    public static final ASN1Template TEMPLATE = new a();

    public SignaturePolicyId(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(SignaturePolicyId.class);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public ASN1ObjectIdentifier getSigPolicyId() {
        return this.a;
    }

    public void setSigPolicyId(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public OtherHashAlgAndValue getSigPolicyHash() {
        return this.b;
    }

    public void setSigPolicyHash(OtherHashAlgAndValue otherHashAlgAndValue) {
        this.b = otherHashAlgAndValue;
    }

    public SigPolicyQualifierInfos getSigPolicyQualifiers() {
        return this.c;
    }

    public void setSigPolicyQualifiers(SigPolicyQualifierInfos sigPolicyQualifierInfos) {
        this.c = sigPolicyQualifierInfos;
    }

    public static SignaturePolicyId getInstance(byte[] byArray) throws PKIXException {
        try {
            return (SignaturePolicyId)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addOptionalElement(OtherHashAlgAndValue.TEMPLATE);
            this.seqt.addOptionalElement(SigPolicyQualifierInfos.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream object2) throws IOException, InvalidBERException {
            try {
                object = (ASN1Sequence)this.seqt.decode(object, (InputStream)object2);
                Assert.debugAssert((object.size() == 3 ? 1 : 0) != 0);
                object2 = new SignaturePolicyId((ASN1ObjectIdentifier)object.elementAt(0));
                ((SignaturePolicyId)object2).setSigPolicyHash((OtherHashAlgAndValue)object.elementAt(1));
                ((SignaturePolicyId)object2).setSigPolicyQualifiers((SigPolicyQualifierInfos)object.elementAt(2));
                return object2;
            }
            catch (InvalidBERException invalidBERException) {
                object = invalidBERException;
                invalidBERException.append("SignaturePolicyId()");
                throw object;
            }
        }
    }
}

