/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.ocsp.OCSPSignature;
import com.bifit.security.pkix.ocsp.TBSRequest;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.ext.Nonce;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OCSPRequest
extends AbstractASN1Sequence {
    private TBSRequest a;
    private OCSPSignature b;
    public static final ASN1Template TEMPLATE = new a();

    public OCSPRequest(TBSRequest tBSRequest) {
        super(OCSPRequest.class);
        this.debug("tbsReq = " + tBSRequest);
        PKIXUtils.verifyNotNull(tBSRequest);
        this.a = tBSRequest;
    }

    public TBSRequest getTbsReq() {
        return this.a;
    }

    public void setTbsReq(TBSRequest tBSRequest) {
        this.debug("tbsReq = " + tBSRequest);
        PKIXUtils.verifyNotNull(tBSRequest);
        this.a = tBSRequest;
    }

    public OCSPSignature getSignature() {
        return this.b;
    }

    public void setSignature(OCSPSignature oCSPSignature) {
        this.debug("signature = " + oCSPSignature);
        this.b = oCSPSignature;
    }

    public boolean hasSignature() {
        return this.b != null;
    }

    public Extension getNonce() {
        Extensions extensions = this.a.getExts();
        if (extensions == null) {
            return null;
        }
        return extensions.getExtension(Nonce.OID);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static OCSPRequest getInstance(byte[] byArray) throws PKIXException {
        try {
            return (OCSPRequest)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public static OCSPRequest getInstance(File file) throws IOException {
        try {
            return OCSPRequest.getInstance(PKIXUtils.readFile(file));
        }
        catch (PKIXException pKIXException) {
            throw new IOException("Error reading OCSP request", pKIXException);
        }
    }

    public String toString() {
        return "OCSPRequest [tbsReq=" + this.a + ", signature=" + this.b + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(TBSRequest.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)OCSPSignature.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (TBSRequest)aSN1Tag.elementAt(0);
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(1);
            object = new OCSPRequest((TBSRequest)object);
            ((OCSPRequest)object).setSignature(aSN1Tag == null ? null : (OCSPSignature)aSN1Tag.getContent());
            return object;
        }
    }
}

