/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1GeneralizedTime;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.ocsp.ResponderID;
import com.bifit.security.pkix.ocsp.Responses;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class ResponseData
extends AbstractASN1Sequence {
    private Version a;
    private ResponderID b;
    private ASN1GeneralizedTime c;
    private Responses d;
    private Extensions e;
    public static final ASN1Template TEMPLATE = new a();

    public ResponseData(Version version, ResponderID responderID, ASN1GeneralizedTime aSN1GeneralizedTime, Responses responses) {
        super(ResponseData.class);
        this.debug("version = " + (Object)((Object)version) + ", respID = " + (Object)((Object)responderID) + ", prodAt = " + aSN1GeneralizedTime + ", responses = " + responses);
        PKIXUtils.verifyNotNull(new Object[]{responderID});
        this.a = version == null ? Version.v1 : version;
        this.b = responderID;
        this.c = aSN1GeneralizedTime == null ? new ASN1GeneralizedTime(new Date()) : aSN1GeneralizedTime;
        this.d = responses == null ? new Responses() : responses;
    }

    public Version getVersion() {
        return this.a;
    }

    public void setVersion(Version version) {
        this.debug("version = " + (Object)((Object)version));
        this.a = version == null ? Version.v1 : version;
    }

    public ResponderID getRespID() {
        return this.b;
    }

    public void setRespID(ResponderID responderID) {
        this.debug("respID = " + (Object)((Object)responderID));
        PKIXUtils.verifyNotNull(new Object[]{responderID});
        this.b = responderID;
    }

    public ASN1GeneralizedTime getProdAt() {
        return this.c;
    }

    public void setProdAt(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.debug("prodAt = " + aSN1GeneralizedTime);
        this.c = aSN1GeneralizedTime == null ? new ASN1GeneralizedTime(new Date()) : aSN1GeneralizedTime;
    }

    public Responses getResponses() {
        return this.d;
    }

    public void setResponses(Responses responses) {
        this.debug("responses = " + responses);
        this.d = responses == null ? new Responses() : responses;
    }

    public Extensions getRespExts() {
        return this.e;
    }

    public void setRespExts(Extensions extensions) {
        this.debug("respExts = " + extensions);
        this.e = extensions;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.a != null && this.a != Version.v1) {
            aSN1Sequence.addElement((ASN1Value)new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)this.a.getASNValue()));
        }
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)1L), (ASN1Value)this.e);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "ResponseData [version=" + (Object)((Object)this.a) + ", respID=" + (Object)((Object)this.b) + ", prodAt=" + this.c + ", responses=" + this.d + ", respExts=" + this.e + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            ASN1Explicit aSN1Explicit = new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)Version.v1.getASNValue());
            this.seqt.addElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)ASN1Integer.TEMPLATE), (ASN1Value)aSN1Explicit);
            this.seqt.addElement(ResponderID.TEMPLATE);
            this.seqt.addElement(ASN1GeneralizedTime.TEMPLATE);
            this.seqt.addElement(Responses.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)1L), (ASN1Template)Extensions.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (ASN1Explicit)aSN1Tag.elementAt(0);
            object = Version.fromASNInt((ASN1Integer)object.getContent());
            ResponderID responderID = (ResponderID)aSN1Tag.elementAt(1);
            ASN1GeneralizedTime aSN1GeneralizedTime = (ASN1GeneralizedTime)aSN1Tag.elementAt(2);
            Responses responses = (Responses)aSN1Tag.elementAt(3);
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(4);
            object = new ResponseData((Version)((Object)object), responderID, aSN1GeneralizedTime, responses);
            ((ResponseData)object).setRespExts(aSN1Tag == null ? null : (Extensions)aSN1Tag.getContent());
            return object;
        }
    }
}

