/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Pentanomial
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final ASN1Integer b;
    private final ASN1Integer c;
    public static final ASN1Template TEMPLATE = new a();

    public Pentanomial(ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2, ASN1Integer aSN1Integer3) {
        super(Pentanomial.class);
        this.debug("k = " + aSN1Integer + ", j = " + aSN1Integer2 + ", l = " + aSN1Integer3);
        PKIXUtils.verifyNotNull(aSN1Integer, aSN1Integer2, aSN1Integer3);
        this.a = aSN1Integer;
        this.b = aSN1Integer2;
        this.c = aSN1Integer3;
    }

    public ASN1Integer getK() {
        return this.a;
    }

    public ASN1Integer getJ() {
        return this.b;
    }

    public ASN1Integer getL() {
        return this.c;
    }

    public static Pentanomial getInstance(byte[] byArray) throws PKIXException {
        try {
            return (Pentanomial)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        aSN1Tag = new ASN1Sequence();
        aSN1Tag.addElement((ASN1Value)this.a);
        aSN1Tag.addElement((ASN1Value)this.b);
        aSN1Tag.addElement((ASN1Value)this.c);
        aSN1Tag.encode(TAG, outputStream);
    }

    public String toString() {
        return "Pentanomial [k=" + this.a + ", j=" + this.b + ", l=" + this.c + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            inputStream = (ASN1Integer)aSN1Tag.elementAt(0);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Tag.elementAt(1);
            aSN1Tag = (ASN1Integer)aSN1Tag.elementAt(2);
            return new Pentanomial((ASN1Integer)inputStream, aSN1Integer, (ASN1Integer)aSN1Tag);
        }
    }
}

