/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1UTF8String;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.DigestAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.Attribute;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TemplateIdentifier
extends AbstractASN1Sequence {
    private ASN1UTF8String a;
    private AlgorithmIdentifier b;
    private ASN1OctetString c;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.4.1.41892.1.2.1.1");
    public static final ASN1Template TEMPLATE = new a();

    public TemplateIdentifier(ASN1UTF8String aSN1UTF8String, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        super(TemplateIdentifier.class);
        this.debug("templateName = " + aSN1UTF8String + ", digestAlgorithm = " + algorithmIdentifier + ", templateDigest = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1UTF8String, aSN1OctetString);
        this.a = aSN1UTF8String;
        this.b = algorithmIdentifier;
        this.c = aSN1OctetString;
    }

    public TemplateIdentifier(ASN1UTF8String aSN1UTF8String, byte[] byArray, DigestAdapter digestAdapter) throws CryptoException {
        this(aSN1UTF8String, digestAdapter.getDigestAlgorithm(), new ASN1OctetString(digestAdapter.digest(byArray)));
    }

    public ASN1UTF8String getTemplateName() {
        return this.a;
    }

    public void setTemplateName(ASN1UTF8String aSN1UTF8String) {
        this.debug("templateName = " + aSN1UTF8String);
        PKIXUtils.verifyNotNull(aSN1UTF8String);
        this.a = aSN1UTF8String;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.b;
    }

    public void setDigestAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.debug("digestAlgorithm = " + algorithmIdentifier);
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.b = algorithmIdentifier;
    }

    public ASN1OctetString getTemplateDigest() {
        return this.c;
    }

    public Attribute toAttribute() throws PKIXException {
        return new Attribute(OID, this);
    }

    public void setTemplateDigest(ASN1OctetString aSN1OctetString) {
        this.debug("templateDigest = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.c = aSN1OctetString;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "TemplateIdentifier [templateName=" + this.a + ", digestAlgorithm=" + this.b + ", templateDigest=" + this.c + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1UTF8String.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            inputStream = (ASN1UTF8String)aSN1Tag.elementAt(0);
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)aSN1Tag.elementAt(1);
            aSN1Tag = (ASN1OctetString)aSN1Tag.elementAt(2);
            return new TemplateIdentifier((ASN1UTF8String)inputStream, algorithmIdentifier, (ASN1OctetString)aSN1Tag);
        }
    }
}

