/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1GeneralizedTime;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1UTCTime;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1TimeBase;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.primitive.AbstractASN1Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Time
extends AbstractASN1Value {
    private Type a;
    private AbstractASN1TimeBase b;
    public static final a TEMPLATE = new a();
    public static final int UTCTIME_CUTOFF_YEAR = 2049;

    public Time() {
        this(new Date());
    }

    public Time(Date date) {
        super(Time.class);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        if (calendar.get(1) <= 2049) {
            this.a = Type.UTC_TIME;
            this.b = new ASN1UTCTime(date);
            return;
        }
        this.a = Type.GENERALIZED_TIME;
        this.b = new ASN1GeneralizedTime(date);
    }

    Time(Type type, AbstractASN1TimeBase abstractASN1TimeBase) {
        super(Time.class);
        this.a = type;
        this.b = abstractASN1TimeBase;
    }

    public Type getType() {
        return this.a;
    }

    public ASN1UTCTime getUtcTime() {
        return (ASN1UTCTime)this.b;
    }

    public ASN1GeneralizedTime getGeneralTime() {
        return (ASN1GeneralizedTime)this.b;
    }

    public boolean after(Time time) {
        return this.toDate().after(time.toDate());
    }

    public boolean before(Time time) {
        return this.toDate().before(time.toDate());
    }

    public Date toDate() {
        return this.b.toDate();
    }

    @Override
    public ASN1Tag getTag() {
        if (this.a == Type.UTC_TIME) {
            return ASN1UTCTime.TAG;
        }
        return ASN1GeneralizedTime.TAG;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.b.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return this.b.toDate().toString();
    }

    private static final class a
    implements ASN1Template {
        private final ASN1Choice.Template a = new ASN1Choice.Template();

        public a() {
            this.a.addElement(ASN1UTCTime.TEMPLATE);
            this.a.addElement(ASN1GeneralizedTime.TEMPLATE);
        }

        public final boolean tagMatch(ASN1Tag aSN1Tag) {
            return this.a.tagMatch(aSN1Tag);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            if ((inputStream = (ASN1Choice)this.a.decode(inputStream)).getTag() == ASN1UTCTime.TAG) {
                return new Time(Type.UTC_TIME, (AbstractASN1TimeBase)inputStream.getValue());
            }
            return new Time(Type.GENERALIZED_TIME, (AbstractASN1TimeBase)inputStream.getValue());
        }

        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(inputStream);
        }
    }

    public static enum Type {
        UTC_TIME,
        GENERALIZED_TIME;

    }
}

