/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.CryptoConverter;
import com.bifit.security.pkix.crypto.SignatureAdapter;
import com.bifit.security.pkix.crypto.VerifyAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.exception.GeneratorException;
import com.bifit.security.pkix.exception.PKIXCertificateException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.log.PKIXLogger;
import com.bifit.security.pkix.log.PKIXLoggerFactory;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.TBSCertificate;
import com.bifit.security.pkix.x509.ext.AuthorityKeyIdentifier;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import com.bifit.security.pkix.x509.ext.BasicConstraints;
import com.bifit.security.pkix.x509.ext.ExtKeyUsage;
import com.bifit.security.pkix.x509.ext.KeyUsage;
import com.bifit.security.pkix.x509.ext.SubjectKeyIdentifier;
import com.bifit.security.pkix.x509.ext.UnsupportedExtension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class Certificate
extends X509Certificate
implements ASN1Value {
    private final TBSCertificate a;
    private final AlgorithmIdentifier b;
    private final ASN1BitString c;
    public static final ASN1Tag TAG = ASN1Sequence.TAG;
    public static final ASN1Template TEMPLATE = new a();
    private static final PKIXLogger d = PKIXLoggerFactory.getLogger(Certificate.class);

    public Certificate(TBSCertificate tBSCertificate, AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        d.debug("info = " + tBSCertificate + ", algId = " + algorithmIdentifier + ", signature = " + aSN1BitString);
        PKIXUtils.verifyNotNull(tBSCertificate, algorithmIdentifier, aSN1BitString);
        this.a = tBSCertificate;
        this.b = algorithmIdentifier;
        this.c = aSN1BitString;
    }

    public Certificate(TBSCertificate tBSCertificate, SignatureAdapter signatureAdapter) throws CryptoException {
        d.debug("info = " + tBSCertificate + ", adapter = " + signatureAdapter);
        PKIXUtils.verifyNotNull(tBSCertificate, signatureAdapter);
        this.a = tBSCertificate;
        this.b = signatureAdapter.getSignatureAlgorithm();
        this.c = CryptoConverter.signBytes2BitString(signatureAdapter.getSignatureAlgorithm(), signatureAdapter.sign(tBSCertificate.encode()));
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        try {
            Object object = this.a.getDecodedList();
            object = object.iterator();
            while (object.hasNext()) {
                BaseExtension baseExtension = (BaseExtension)object.next();
                if (!(baseExtension instanceof UnsupportedExtension) || !((UnsupportedExtension)baseExtension).getExtension().isCritical()) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return true;
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.a.getExtensionOIDs(true);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.a.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        d.debug("oid = " + string);
        PKIXUtils.verifyNotNull(string);
        string = new ASN1ObjectIdentifier(string);
        if (this.a.isExtensionPresent((ASN1ObjectIdentifier)string)) {
            return this.a.getExtension((ASN1ObjectIdentifier)string).getExtnValue().toByteArray();
        }
        return null;
    }

    public List<Certificate> getCertificateChain(List<Certificate> list) throws PKIXCertificateException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        arrayList.add(this);
        if (!this.a(list, arrayList)) {
            throw new PKIXCertificateException(7, this);
        }
        return arrayList;
    }

    private boolean a(List<Certificate> list, List<Certificate> list2) throws PKIXCertificateException {
        Object object;
        block0: while ((object = certificate2.a.getExtensions()) != null) {
            Object object2 = (AuthorityKeyIdentifier)((Extensions)object).getDecoded(AuthorityKeyIdentifier.OID);
            if (object2 != null) {
                object2 = ((AuthorityKeyIdentifier)object2).getKeyIdentifier().getIdentifier().toByteArray();
                for (Certificate certificate : list) {
                    Extensions extensions = certificate.a.getExtensions();
                    if (object != null) {
                        Object object3 = (SubjectKeyIdentifier)extensions.getDecoded(SubjectKeyIdentifier.OID);
                        if (!Arrays.equals((byte[])object2, (byte[])(object3 = (Object)((SubjectKeyIdentifier)object3).getKeyIdentifierBytes()))) continue;
                        if (!list2.contains(certificate)) {
                            list2.add(certificate);
                        }
                        object = (AuthorityKeyIdentifier)extensions.getDecoded(AuthorityKeyIdentifier.OID);
                        if (Arrays.equals((byte[])object3, (byte[])(object = (Object)((AuthorityKeyIdentifier)object).getKeyIdentifier().getIdentifier().toByteArray()))) {
                            return true;
                        }
                        Certificate certificate2 = certificate;
                        continue block0;
                    }
                    throw new PKIXCertificateException(6, certificate);
                }
                throw new PKIXCertificateException(3, certificate2);
            }
            throw new PKIXCertificateException(5, certificate2);
        }
        throw new PKIXCertificateException(6, certificate2);
    }

    private static void a(Certificate certificate, VerifyAdapter verifyAdapter) throws PKIXCertificateException, PKIXException {
        if (!verifyAdapter.hasCertificate()) {
            throw new PKIXException("VerifyAdapter does not have certificate");
        }
        if (!certificate.getInfo().getIssuer().equals(verifyAdapter.getCertificate().getInfo().getSubject())) {
            throw new PKIXCertificateException(3, certificate);
        }
        if (!certificate.verify(verifyAdapter)) {
            throw new PKIXCertificateException(4, certificate);
        }
    }

    public void verifyWithValidateCertsChain(List<VerifyAdapter> list, Date date) throws PKIXException, PKIXCertificateException {
        Serializable serializable;
        if (list == null || list.size() == 0) {
            throw new PKIXException("Empty certificates chain");
        }
        if (!list.get(0).hasCertificate() || !list.get(0).getCertificate().equals(this)) {
            throw new PKIXException("Invalid certificates chain");
        }
        if (date == null) {
            serializable = Calendar.getInstance();
            serializable.set(14, 0);
            date = serializable.getTime();
        }
        serializable = null;
        for (VerifyAdapter verifyAdapter : list) {
            if (!verifyAdapter.hasCertificate()) {
                throw new PKIXException("VerifyAdapter does not have certificate");
            }
            Certificate certificate = verifyAdapter.getCertificate();
            try {
                this.checkValidity(date);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                throw new PKIXCertificateException(1, this);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                throw new PKIXCertificateException(2, this);
            }
            if (serializable != null) {
                Certificate.a((Certificate)serializable, verifyAdapter);
            }
            serializable = certificate;
        }
        List<VerifyAdapter> list2 = list;
        Certificate.a((Certificate)serializable, list2.get(list2.size() - 1));
    }

    public void verifyCertsChain(List<VerifyAdapter> list) throws PKIXException, PKIXCertificateException {
        if (list == null || list.size() == 0) {
            throw new PKIXException("Empty certificates chain");
        }
        if (!list.get(0).hasCertificate() || !list.get(0).getCertificate().equals(this)) {
            throw new PKIXException("Invalid certificates chain");
        }
        Comparable<Calendar> comparable = Calendar.getInstance();
        comparable.set(14, 0);
        comparable = comparable.getTime();
        Certificate certificate = null;
        for (VerifyAdapter verifyAdapter : list) {
            if (!verifyAdapter.hasCertificate()) {
                throw new PKIXException("VerifyAdapter does not have certificate");
            }
            Certificate certificate2 = verifyAdapter.getCertificate();
            try {
                this.checkValidity((Date)comparable);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                throw new PKIXCertificateException(1, this);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                throw new PKIXCertificateException(2, this);
            }
            if (certificate != null) {
                Certificate.a(certificate, verifyAdapter);
            }
            certificate = certificate2;
        }
        List<VerifyAdapter> list2 = list;
        Certificate.a(certificate, list2.get(list2.size() - 1));
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        this.checkValidity(calendar.getTime());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        d.debug("date = " + date);
        PKIXUtils.verifyNotNull(date);
        this.a.getValidity().checkValidity(date);
    }

    @Override
    public int getVersion() {
        return this.a.getVersion().getIntNumber();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.a.getSerialNumber();
    }

    @Override
    public Principal getIssuerDN() {
        return this.a.getIssuer().getX500Principal();
    }

    @Override
    public Principal getSubjectDN() {
        return this.a.getSubject().getX500Principal();
    }

    @Override
    public Date getNotBefore() {
        return this.a.getValidity().getNotBefore().toDate();
    }

    @Override
    public Date getNotAfter() {
        return this.a.getValidity().getNotAfter().toDate();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.a.encode();
    }

    @Override
    public String getSigAlgName() {
        return this.b.getOID().toString();
    }

    @Override
    public String getSigAlgOID() {
        return this.b.getAlgorithm().toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        return ASN1Util.encode((ASN1Value)this.a.getSubjectPublicKeyInfo().getAlgorithmIdentifier().getParameters());
    }

    @Override
    public byte[] getSignature() {
        return this.c.getBits();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        if (this.a.hasIssuerUID()) {
            return this.a.getIssuerUID().toBooleanArray();
        }
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        if (this.a.hasSubjectUID()) {
            return this.a.getSubjectUID().toBooleanArray();
        }
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        Object object = this.getExtensionValue(KeyUsage.OID.toString());
        try {
            ASN1BitString aSN1BitString = ASN1BitString.getInstance((byte[])object);
            object = aSN1BitString;
            return aSN1BitString.toBooleanArray();
        }
        catch (InvalidBERException invalidBERException) {
            return null;
        }
    }

    @Override
    public int getBasicConstraints() {
        Extension extension = this.a.getExtension(BasicConstraints.OID);
        if (extension != null) {
            try {
                return new BasicConstraints(extension).getPathLenConstraint();
            }
            catch (GeneratorException generatorException) {
                d.warn("Gerring pathlenconstraint error", generatorException);
            }
        }
        return -1;
    }

    public String printSerialNumber() {
        return PKIXUtils.arrayToString(this.a.getSerialNumber().toByteArray());
    }

    public boolean isOCSPCertificate() {
        return this.a("1.3.6.1.5.5.7.3.9");
    }

    public boolean isTSPCertificate() {
        return this.a("1.3.6.1.5.5.7.3.8");
    }

    public void writeFile(File file) throws IOException {
        d.debug("PATH = " + file.getAbsoluteFile());
        PKIXUtils.writeFile(this.encode(), file);
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.encode();
    }

    public byte[] encode() {
        return ASN1Util.encode((ASN1Value)this);
    }

    public static Certificate getInstance(byte[] byArray) throws PKIXException {
        try {
            return (Certificate)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public static Certificate getInstance(File file) throws IOException {
        d.debug("certFile = " + file);
        try {
            return Certificate.getInstance(PKIXUtils.readFile(file));
        }
        catch (PKIXException pKIXException) {
            throw new IOException("Error reading certificate", pKIXException);
        }
    }

    @Override
    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new CertificateException("Unsupported method");
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new CertificateException("Unsupported method");
    }

    public boolean verify(VerifyAdapter verifyAdapter) throws CryptoException {
        try {
            return verifyAdapter.verify(this.a.encode(), CryptoConverter.signBitString2Bytes(verifyAdapter.getSignatureAlgorithm(), this.c));
        }
        catch (InvalidBERException invalidBERException) {
            throw new CryptoException(invalidBERException);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    public TBSCertificate getInfo() {
        return this.a;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.b;
    }

    public ASN1Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = n * 31 + (this.b == null ? 0 : this.b.hashCode());
        n = n * 31 + (this.a == null ? 0 : this.a.hashCode());
        n = n * 31 + (this.c == null ? 0 : this.c.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Certificate)object;
        if (this.b == null ? ((Certificate)object).b != null : !this.b.equals(((Certificate)object).b)) {
            return false;
        }
        if (this.a == null ? ((Certificate)object).a != null : !this.a.equals(((Certificate)object).a)) {
            return false;
        }
        return !(this.c == null ? ((Certificate)object).c != null : !this.c.equals((Object)((Certificate)object).c));
    }

    @Override
    public String toString() {
        return "Certificate [info=" + this.a + ", algId=" + this.b + ", signature=" + this.c + "]";
    }

    private boolean a(String string) {
        Object object = this.a.getExtensions();
        if (object != null) {
            try {
                object = ((Extensions)object).getDecoded(ExtKeyUsage.OID);
                if (object != null && ((ExtKeyUsage)(object = (ExtKeyUsage)object)).size() == 1) {
                    object = ((ExtKeyUsage)object).keyPurposeIdAt(0).toString();
                    return string.equals(object);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static final class a
    implements ASN1Template {
        private final ASN1Sequence.Template a = new ASN1Sequence.Template();

        public a() {
            this.a.addElement(TBSCertificate.TEMPLATE);
            this.a.addElement(AlgorithmIdentifier.TEMPLATE);
            this.a.addElement(ASN1BitString.TEMPLATE);
        }

        public final boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals((Object)aSN1Tag);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public final ASN1Value decode(ASN1Tag object, InputStream inputStream) throws InvalidBERException, IOException {
            if ((inputStream = (ASN1BitString)(object = (ASN1Sequence)this.a.decode(object, inputStream)).elementAt(2)).getPadCount() != 0) {
                throw new InvalidBERException("Signature does not fall into an integral number of bytes");
            }
            TBSCertificate tBSCertificate = (TBSCertificate)object.elementAt(0);
            object = (AlgorithmIdentifier)object.elementAt(1);
            return new Certificate(tBSCertificate, (AlgorithmIdentifier)object, (ASN1BitString)inputStream);
        }
    }
}

