/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1IA5String;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.SyntaxException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.x509.DistributionPointName;
import com.bifit.security.pkix.x509.GeneralName;
import com.bifit.security.pkix.x509.GeneralNameType;
import com.bifit.security.pkix.x509.GeneralNames;
import com.bifit.security.pkix.x509.ReasonFlags;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DistributionPoint
extends AbstractASN1Sequence {
    private final DistributionPointName a;
    private ReasonFlags b;
    private GeneralNames c;
    public static final ASN1Template TEMPLATE = new a();

    public DistributionPoint(DistributionPointName distributionPointName, ReasonFlags reasonFlags, GeneralNames generalNames) throws SyntaxException {
        super(DistributionPoint.class);
        this.debug("distrPoint = " + (Object)((Object)distributionPointName) + ", reasons = " + (Object)((Object)reasonFlags) + ", names = " + generalNames);
        if (reasonFlags != null && distributionPointName == null && generalNames == null) {
            throw new SyntaxException("DistributionPoint MUST NOT consist of only the reasons field");
        }
        this.a = distributionPointName;
        this.b = reasonFlags;
        this.c = generalNames;
    }

    public DistributionPoint(String object) throws CharConversionException {
        super(DistributionPoint.class);
        this.debug("pointUri = " + (String)object);
        object = new ASN1IA5String((String)object);
        object = new GeneralName(GeneralNameType.UNIFORM_RES_ID, (ASN1Value)object);
        object = new GeneralNames((GeneralName)object);
        this.a = new DistributionPointName((GeneralNames)object);
    }

    public DistributionPointName getDistributionPoint() {
        return this.a;
    }

    public ReasonFlags getReasons() {
        return this.b;
    }

    public GeneralNames getNames() {
        return this.c;
    }

    public ASN1IA5String getPoint() {
        GeneralName generalName;
        if (this.a != null && this.a.isFullName() && (generalName = (GeneralName)((GeneralNames)this.a.getValue().getValue()).elementAt(0)).getType() == GeneralNameType.UNIFORM_RES_ID) {
            return (ASN1IA5String)generalName.getValue();
        }
        return null;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.a);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.b);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)2L), (ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "DistributionPoint [distrPoint=" + (Object)((Object)this.a) + ", reasons=" + (Object)((Object)this.b) + ", names=" + this.c + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)DistributionPointName.TEMPLATE));
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), ReasonFlags.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)2L), GeneralNames.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream object2) throws IOException, InvalidBERException {
            object = this.getSequence((ASN1Tag)object, (InputStream)object2);
            object2 = (DistributionPointName)((ASN1Explicit)object.elementAt(0)).getContent();
            ReasonFlags reasonFlags = (ReasonFlags)object.elementAt(1);
            object = (GeneralNames)object.elementAt(2);
            try {
                object = new DistributionPoint((DistributionPointName)((Object)object2), reasonFlags, (GeneralNames)object);
            }
            catch (Exception exception) {
                throw new InvalidBERException(exception.getMessage());
            }
            return object;
        }
    }
}

