/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.GeneralNames;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IssuerSerial
extends AbstractASN1Sequence {
    private final GeneralNames a;
    private final ASN1Integer b;
    private final ASN1BitString c;
    public static final ASN1Template TEMPLATE = new a();

    public IssuerSerial(GeneralNames generalNames, ASN1Integer aSN1Integer, ASN1BitString aSN1BitString) {
        super(IssuerSerial.class);
        PKIXUtils.verifyNotNull(generalNames, aSN1Integer);
        this.a = generalNames;
        this.b = aSN1Integer;
        this.c = aSN1BitString;
    }

    public GeneralNames getIssuer() {
        return this.a;
    }

    public ASN1Integer getSerialNumber() {
        return this.b;
    }

    public ASN1BitString getIssuerUID() {
        return this.c;
    }

    public static IssuerSerial getInstance(byte[] byArray) throws PKIXException {
        try {
            return (IssuerSerial)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(GeneralNames.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addOptionalElement(ASN1BitString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new IssuerSerial((GeneralNames)aSN1Tag.elementAt(0), (ASN1Integer)aSN1Tag.elementAt(1), (ASN1BitString)aSN1Tag.elementAt(2));
        }
    }
}

