/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1PrintableString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.GeneratorException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MonetaryValue
extends AbstractASN1Sequence {
    private ASN1PrintableString a;
    private ASN1Integer b;
    private ASN1Integer c;
    public static final ASN1Template TEMPLATE = new a();

    public MonetaryValue(ASN1PrintableString aSN1PrintableString, ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2) throws GeneratorException {
        super(MonetaryValue.class);
        PKIXUtils.verifyNotNull(aSN1PrintableString, aSN1Integer, aSN1Integer2);
        if (aSN1PrintableString.toCharArray().length != 3) {
            throw new GeneratorException("Currency must be 3 characters long");
        }
        this.a = aSN1PrintableString;
        this.b = aSN1Integer;
        this.c = aSN1Integer2;
    }

    public ASN1PrintableString getCurrency() {
        return this.a;
    }

    public void setCurrency(ASN1PrintableString aSN1PrintableString) throws GeneratorException {
        this.debug("currency = " + aSN1PrintableString);
        PKIXUtils.verifyNotNull(aSN1PrintableString);
        if (aSN1PrintableString.toCharArray().length != 3) {
            throw new GeneratorException("Currency must be 3 characters long");
        }
        this.a = aSN1PrintableString;
    }

    public ASN1Integer getAmount() {
        return this.b;
    }

    public void setAmount(ASN1Integer aSN1Integer) {
        this.debug("amount = " + aSN1Integer);
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.b = aSN1Integer;
    }

    public ASN1Integer getExpontent() {
        return this.c;
    }

    public void setExpontent(ASN1Integer aSN1Integer) {
        this.debug("exponent = " + aSN1Integer);
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.c = aSN1Integer;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "MonetaryValue [currency=" + this.a + ", amount=" + this.b + ", expontent=" + this.c + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1PrintableString.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            inputStream = (ASN1PrintableString)aSN1Tag.elementAt(0);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Tag.elementAt(1);
            aSN1Tag = (ASN1Integer)aSN1Tag.elementAt(2);
            try {
                return new MonetaryValue((ASN1PrintableString)inputStream, aSN1Integer, (ASN1Integer)aSN1Tag);
            }
            catch (GeneratorException generatorException) {
                throw new InvalidBERException("Error decoding MonetaryValue");
            }
        }
    }
}

