/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.DigestedObjectType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ObjectDigestInfo
extends AbstractASN1Sequence {
    private final DigestedObjectType a;
    private final ASN1ObjectIdentifier b;
    private final AlgorithmIdentifier c;
    private final ASN1BitString d;
    public static final ASN1Template TEMPLATE = new a();

    public ObjectDigestInfo(DigestedObjectType digestedObjectType, ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        super(ObjectDigestInfo.class);
        PKIXUtils.verifyNotNull(new Object[]{digestedObjectType, algorithmIdentifier, aSN1BitString});
        this.a = digestedObjectType;
        this.c = algorithmIdentifier;
        this.d = aSN1BitString;
        this.b = aSN1ObjectIdentifier;
    }

    public DigestedObjectType getDigestedObjectType() {
        return this.a;
    }

    public ASN1ObjectIdentifier getOtherObjectTypeID() {
        return this.b;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.c;
    }

    public ASN1BitString getObjectDigest() {
        return this.d;
    }

    public static ObjectDigestInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (ObjectDigestInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(DigestedObjectType.TEMPLATE);
            this.seqt.addOptionalElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new ObjectDigestInfo((DigestedObjectType)aSN1Tag.elementAt(0), (ASN1ObjectIdentifier)aSN1Tag.elementAt(1), (AlgorithmIdentifier)aSN1Tag.elementAt(2), (ASN1BitString)aSN1Tag.elementAt(3));
        }
    }
}

