/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.primitive.AbstractGenericASN1Sequence;
import com.bifit.security.pkix.x509.RevokedCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class RevokedCertificates
extends AbstractGenericASN1Sequence<RevokedCertificate> {
    public static final ASN1Template TEMPLATE = new a();

    public RevokedCertificates() {
        super(RevokedCertificates.class);
    }

    RevokedCertificates(ASN1Sequence aSN1Sequence) {
        super(aSN1Sequence, RevokedCertificates.class);
    }

    public RevokedCertificates(RevokedCertificates ... revokedCertificatesArray) {
        super(RevokedCertificates.class);
        for (RevokedCertificates revokedCertificates : revokedCertificatesArray) {
            if (revokedCertificates == null) continue;
            for (int i = 0; i < revokedCertificates.size(); ++i) {
                this.sequence.addElement(revokedCertificates.elementAt(i));
            }
        }
    }

    public RevokedCertificates(Collection<RevokedCertificate> object) {
        super(RevokedCertificates.class);
        object = object.iterator();
        while (object.hasNext()) {
            RevokedCertificate revokedCertificate = (RevokedCertificate)object.next();
            this.sequence.addElement((ASN1Value)revokedCertificate);
        }
    }

    public boolean contains(RevokedCertificate revokedCertificate) {
        this.debug("expected = " + revokedCertificate);
        for (int i = 0; i < this.sequence.size(); ++i) {
            RevokedCertificate revokedCertificate2 = (RevokedCertificate)this.sequence.elementAt(i);
            if (!revokedCertificate2.equals(revokedCertificate)) continue;
            return true;
        }
        return false;
    }

    public RevokedCertificate getRevokedCertificate(ASN1Integer aSN1Integer) {
        this.debug("certSN = " + aSN1Integer);
        RevokedCertificate revokedCertificate = null;
        for (int i = 0; i < this.sequence.size(); ++i) {
            RevokedCertificate revokedCertificate2 = (RevokedCertificate)this.elementAt(i);
            if (!revokedCertificate2.getCertSN().equals((Object)aSN1Integer)) continue;
            if (revokedCertificate == null) {
                revokedCertificate = revokedCertificate2;
                continue;
            }
            if (!revokedCertificate2.getRevocationDate().after(revokedCertificate.getRevocationDate())) continue;
            revokedCertificate = revokedCertificate2;
        }
        return revokedCertificate;
    }

    public boolean hasExtensions() {
        for (int i = 0; i < this.sequence.size(); ++i) {
            if (((RevokedCertificate)this.elementAt(i)).getExtensions() == null) continue;
            return true;
        }
        return false;
    }

    public static RevokedCertificates getInstance(byte[] byArray) throws InvalidBERException {
        return (RevokedCertificates)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
    }

    public String toString() {
        return "RevokedCertificates [size=" + this.sequence.size() + "]";
    }

    private static final class a
    extends AbstractGenericASN1Sequence.AbstractGenericTemplate {
        public a() {
            super(RevokedCertificate.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            return new RevokedCertificates((ASN1Sequence)this.seqt.decode(aSN1Tag, inputStream));
        }
    }
}

