/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.OidUA;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.DSTU4145Params;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;

public class SubjectPublicKeyInfo
extends AbstractASN1Sequence {
    private final AlgorithmIdentifier a;
    private final ASN1BitString b;
    public static final ASN1Template TEMPLATE = new a();

    public SubjectPublicKeyInfo(PublicKey publicKey) throws InvalidBERException {
        super(SubjectPublicKeyInfo.class);
        this.debug("pubk = " + publicKey);
        publicKey = (ASN1Sequence)ASN1Util.decode((ASN1Template)((a)TEMPLATE).getSeqt(), (byte[])publicKey.getEncoded());
        this.a = (AlgorithmIdentifier)publicKey.elementAt(0);
        this.b = (ASN1BitString)publicKey.elementAt(1);
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        super(SubjectPublicKeyInfo.class);
        this.debug("algorithm = " + algorithmIdentifier + ", subjectPublicKey = " + aSN1BitString);
        PKIXUtils.verifyNotNull(new Object[0]);
        this.a = algorithmIdentifier;
        this.b = aSN1BitString;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.a;
    }

    public ASN1BitString getSubjectPublicKey() {
        return this.b;
    }

    public byte[] getPublicKeyBytes() {
        return this.b.getBits();
    }

    public DSTU4145Params getDSTU4145Params() throws CryptoException {
        try {
            if (this.a.getAlgorithm().checkParentBranch(OidUA.PKI_DSTU4145_WITH_GOST3411)) {
                ASN1Any aSN1Any = (ASN1Any)this.a.getParameters();
                return (DSTU4145Params)aSN1Any.decodeWith(DSTU4145Params.TEMPLATE);
            }
            throw new CryptoException("Illegal algorithm OID.");
        }
        catch (InvalidBERException invalidBERException) {
            throw new CryptoException("Error getting params", (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "SubjectPublicKeyInfo [algorithm=" + this.a + ", subjectPublicKey=" + this.b + "]";
    }

    public static SubjectPublicKeyInfo fromPublicKey(PublicKey publicKey) throws InvalidBERException {
        return (SubjectPublicKeyInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])publicKey.getEncoded());
    }

    public static SubjectPublicKeyInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (SubjectPublicKeyInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)aSN1Tag.elementAt(0), (ASN1BitString)aSN1Tag.elementAt(1));
        }
    }
}

