/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class AcceptableResponses
extends BaseExtension {
    private final ASN1Sequence a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.4");
    private static final ASN1Template b = ASN1Sequence.getSequenceTemplate((ASN1Template)ASN1ObjectIdentifier.TEMPLATE);

    public AcceptableResponses(Extension extension) throws InvalidBERException {
        super(extension, AcceptableResponses.class, OID);
        this.a = ASN1Sequence.getInstance((ASN1Template)b, (byte[])extension.getContent());
    }

    public AcceptableResponses(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(AcceptableResponses.class);
        this.debug("OID = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = new ASN1Sequence();
        this.a.addElement((ASN1Value)aSN1ObjectIdentifier);
    }

    public void addElement(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("OID = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a.addElement((ASN1Value)aSN1ObjectIdentifier);
    }

    public ASN1Value elementAt(int n) {
        this.debug("INDEX = " + n);
        return this.a.elementAt(n);
    }

    public void insertElementAt(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) {
        this.debug("OID = " + aSN1ObjectIdentifier + ", INDEX = " + n);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a.insertElementAt((ASN1Value)aSN1ObjectIdentifier, n);
    }

    public void removeAllElements() {
        this.a.removeAllElements();
    }

    public void removeElementAt(int n) {
        this.debug("INDEX = " + n);
        this.a.removeElementAt(n);
    }

    public int size() {
        return this.a.size();
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (AcceptableResponses)object;
        return !(this.a == null ? ((AcceptableResponses)object).a != null : !this.a.equals((Object)((AcceptableResponses)object).a));
    }

    public String toString() {
        return "AcceptableResponses [types=" + this.a + "]";
    }
}

