/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.GeneralNames;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class CertificateIssuer
extends BaseExtension {
    private GeneralNames a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.29");

    public CertificateIssuer(GeneralNames generalNames) {
        super(CertificateIssuer.class);
        this.debug("issuer = " + generalNames);
        PKIXUtils.verifyNotNull(generalNames);
        this.a = generalNames;
    }

    public CertificateIssuer(Extension extension) throws PKIXException {
        super(extension, CertificateIssuer.class, OID);
        this.a = GeneralNames.getInstance(extension.getContent());
    }

    public void setIssuer(GeneralNames generalNames) {
        this.debug("issuer = " + generalNames);
        PKIXUtils.verifyNotNull(generalNames);
        this.a = generalNames;
    }

    public GeneralNames getIssuer() {
        return this.a;
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (CertificateIssuer)object;
        return !(this.a == null ? ((CertificateIssuer)object).a != null : !this.a.equals(((CertificateIssuer)object).a));
    }

    public String toString() {
        return "CertificateIssuer [issuer=" + this.a + "]";
    }
}

