/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class DeltaCRLIndicator
extends BaseExtension {
    private ASN1Integer a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.27");

    public DeltaCRLIndicator(ASN1Integer aSN1Integer) {
        super(DeltaCRLIndicator.class);
        this.debug("deltaValue = " + aSN1Integer);
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.a = aSN1Integer;
    }

    public DeltaCRLIndicator(Extension extension) throws InvalidBERException {
        super(extension, DeltaCRLIndicator.class, OID);
        this.a = ASN1Integer.getInstance((byte[])extension.getContent());
    }

    public void setDeltaValue(ASN1Integer aSN1Integer) {
        this.debug("deltaValue = " + aSN1Integer);
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.a = aSN1Integer;
    }

    public ASN1Integer getDeltaValue() {
        return this.a;
    }

    public String printHex() {
        return PKIXUtils.arrayToString(this.a.toByteArray());
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (DeltaCRLIndicator)object;
        return !(this.a == null ? ((DeltaCRLIndicator)object).a != null : !this.a.equals((Object)((DeltaCRLIndicator)object).a));
    }

    public String toString() {
        return "DeltaCRLIndicator [deltaValue=" + this.a + "]";
    }
}

